"""
Test better implementation of gen_sym_mat
9/6/2020

Results: Old gen_sym_mat is not as general as the new one, but is faster and generates the same results for all
symmetry operations in spacegroup tables.
"""

import time
import re
import numpy as np


def gen_sym_mat(sym_ops):
    """
     Generate transformation matrix from symmetry operation
     Currently very ugly but it seems to work
     sym_mat = gen_syn_mat(['x,y,z','y,-x,z+1/2'])
     sym_mat[0] = [[ 1.,  0.,  0.,  0.],
                   [ 0.,  1.,  0.,  0.],
                   [ 0.,  0.,  1.,  0.]])
     sym_mat[1] = [[ 0. ,  1. ,  0. ,  0. ],
                   [-1. ,  0. ,  0. ,  0. ],
                   [ 0. ,  0. ,  1. ,  0.5]]
    """

    #regex_xyz = re.compile(r'[\+-]?[xyz]')
    sym_mat = []
    for sym in sym_ops:
        sym = sym.lower()
        sym = sym.strip('\"\'')
        sym = sym.replace('/', './')  # float division
        ops = sym.split(',')
        mat = np.zeros((4, 4))
        mat[3, 3] = 1

        for n in range(3):
            op = ops[n]
            #op = op.strip('\"\'')
            if 'x' in op: mat[n, 0] = 1
            if '-x' in op: mat[n, 0] = -1
            if 'y' in op: mat[n, 1] = 1
            if '-y' in op: mat[n, 1] = -1
            if 'z' in op: mat[n, 2] = 1
            if '-z' in op: mat[n, 2] = -1

            # remove these parts
            #op = regex_xyz.sub('', op)
            op = op.replace('-x', '').replace('x', '')
            op = op.replace('-y', '').replace('y', '')
            op = op.replace('-z', '').replace('z', '')
            op = op.replace('+', '')
            #op = op.replace('/', './')  # Allow float division

            if len(op.strip()) > 0:
                mat[n, 3] = eval(op)
        sym_mat += [mat]
    return sym_mat


def gen_sym_mat2(sym_ops):
    """
     Generate transformation matrix from symmetry operation
     Currently very ugly but it seems to work
     sym_mat = gen_syn_mat(['x,y,z','y,-x,z+1/2'])
     sym_mat[0] = [[ 1.,  0.,  0.,  0.],
                   [ 0.,  1.,  0.,  0.],
                   [ 0.,  0.,  1.,  0.]])
     sym_mat[1] = [[ 0. ,  1. ,  0. ,  0. ],
                   [-1. ,  0. ,  0. ,  0. ],
                   [ 0. ,  0. ,  1. ,  0.5]]
    """

    eval_dict = {
        'x': np.array([1, 0, 0]),
        'y': np.array([0, 1, 0]),
        'z': np.array([0, 0, 1])
    }
    #regex_xyz = re.compile(r'[\+-]?[xyz]')
    regex_num = re.compile(r'[+-]?\d./\d[+-]?')

    sym_mat = []
    for sym in sym_ops:
        sym = sym.lower()
        sym = sym.strip('\"\'')
        sym = sym.replace('/', './')  # float division
        ops = sym.split(',')
        mat = np.eye(4)

        for n in range(3):
            op = ops[n]
            # Get translations
            mat[n, 3] = np.sum([eval(val) for val in regex_num.findall(op)])
            # Remove translations
            op = regex_num.sub('', op)
            # evaluate operation
            mat[n, :3] = eval(op, eval_dict)
        sym_mat += [mat]
    return sym_mat


# General positions R-3'c' #167.106
ops = [
    'x,  y,  z, +1',
    '-y,  x-y,  z, +1',
    '-x+y,  -x,  z, +1',
    'x-y,  -y,  -z+1/2, +1',
    'y,  x,  -z+1/2, +1',
    '-x,  -x+y,  -z+1/2, +1',
    '-x,  -y,  -z, -1',
    'y,  -x+y,  -z, -1',
    'x-y,  x,  -z, -1',
    '-x+y,  y,  z+1/2, -1',
    '-y,  -x,  z+1/2, -1',
    'x,  x-y,  z+1/2, -1',
    'x+2/3,  y+1/3,  z+1/3, +1',
    '-y+2/3,  x-y+1/3,  z+1/3, +1',
    '-x+y+2/3,  -x+1/3,  z+1/3, +1',
    'x-y+2/3,  -y+1/3,  -z+5/6, +1',
    'y+2/3,  x+1/3,  -z+5/6, +1',
    '-x+2/3,  -x+y+1/3,  -z+5/6, +1',
    '-x+2/3,  -y+1/3,  -z+1/3, -1',
    'y+2/3,  -x+y+1/3,  -z+1/3, -1',
    'x-y+2/3,  x+1/3,  -z+1/3, -1',
    '-x+y+2/3,  y+1/3,  z+5/6, -1',
    '-y+2/3,  -x+1/3,  z+5/6, -1',
    'x+2/3,  x-y+1/3,  z+5/6, -1',
    'x+1/3,  y+2/3,  z+2/3, +1',
    '-y+1/3,  x-y+2/3,  z+2/3, +1',
    '-x+y+1/3,  -x+2/3,  z+2/3, +1',
    'x-y+1/3,  -y+2/3,  -z+1/6, +1',
    'y+1/3,  x+2/3,  -z+1/6, +1',
    '-x+1/3,  -x+y+2/3,  -z+1/6, +1',
    '-x+1/3,  -y+2/3,  -z+2/3, -1',
    'y+1/3,  -x+y+2/3,  -z+2/3, -1',
    'x-y+1/3,  x+2/3,  -z+2/3, -1',
    '-x+y+1/3,  y+2/3,  z+1/6, -1',
    '-y+1/3,  -x+2/3,  z+1/6, -1',
    'x+1/3,  x-y+2/3,  z+1/6, -1'
]

t1 = time.time()
for n in range(1000):
    mat1 = gen_sym_mat(ops)
t2 = time.time()
for n in range(1000):
    mat2 = gen_sym_mat2(ops)
t3 = time.time()

for n in range(len(ops)):
    a1, a2, a3, a4 = mat1[n][0, :]
    b1, b2, b3, b4 = mat2[n][0, :]
    print('%2d %30s |%3.3g,%3.3g,%3.3g,%5.3g|    |%3.3g,%3.3g,%3.3g,%5.3g|' % (n, ops[n], a1, a2, a3, a4, b1, b2, b3, b4))
    a1, a2, a3, a4 = mat1[n][1, :]
    b1, b2, b3, b4 = mat2[n][1, :]
    print('   %30s |%3.3g,%3.3g,%3.3g,%5.3g|    |%3.3g,%3.3g,%3.3g,%5.3g|' % ('', a1, a2, a3, a4, b1, b2, b3, b4))
    a1, a2, a3, a4 = mat1[n][2, :]
    b1, b2, b3, b4 = mat2[n][2, :]
    print('   %30s |%3.3g,%3.3g,%3.3g,%5.3g|    |%3.3g,%3.3g,%3.3g,%5.3g|' % ('', a1, a2, a3, a4, b1, b2, b3, b4))
    a1, a2, a3, a4 = mat1[n][3, :]
    b1, b2, b3, b4 = mat2[n][3, :]
    print('   %30s |%3.3g,%3.3g,%3.3g,%5.3g|    |%3.3g,%3.3g,%3.3g,%5.3g|' % ('', a1, a2, a3, a4, b1, b2, b3, b4))

print('Difference: %s' % [np.sum((m2 - m1) ** 2) for m1, m2 in zip(mat1, mat2)])
print('Method 1: %s s' % (t2 - t1))
print('Method 2: %s s' % (t3 - t2))

import Dans_Diffraction as dif
msgs = dif.fc.spacegroups_magnetic()

print('\nLooping all magnetic spacegroups:')
diff_count = 0
tested = 0
for key, msg in msgs.items():
    ops = msg['positions general']
    tested += len(ops)
    mat1 = gen_sym_mat(ops)
    mat2 = gen_sym_mat(ops)
    ncount = np.sum([np.sum((m2-m1)**2) > 0.01 for m1,m2 in zip(mat1, mat2)])
    diff_count += ncount
    if ncount > 0:
        print(key, ncount)

print('Differences: %d / %d' % (ncount, tested))

"""
 0                  x,  y,  z, +1 |  1,  0,  0,    0|    |  1,  0,  0,    0|
                                  |  0,  1,  0,    0|    |  0,  1,  0,    0|
                                  |  0,  0,  1,    0|    |  0,  0,  1,    0|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
 1               -y,  x-y,  z, +1 |  0, -1,  0,    0|    |  0, -1,  0,    0|
                                  |  1, -1,  0,    0|    |  1, -1,  0,    0|
                                  |  0,  0,  1,    0|    |  0,  0,  1,    0|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
 2              -x+y,  -x,  z, +1 | -1,  1,  0,    0|    | -1,  1,  0,    0|
                                  | -1,  0,  0,    0|    | -1,  0,  0,    0|
                                  |  0,  0,  1,    0|    |  0,  0,  1,    0|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
 3          x-y,  -y,  -z+1/2, +1 |  1, -1,  0,    0|    |  1, -1,  0,    0|
                                  |  0, -1,  0,    0|    |  0, -1,  0,    0|
                                  |  0,  0, -1,  0.5|    |  0,  0, -1,  0.5|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
 4             y,  x,  -z+1/2, +1 |  0,  1,  0,    0|    |  0,  1,  0,    0|
                                  |  1,  0,  0,    0|    |  1,  0,  0,    0|
                                  |  0,  0, -1,  0.5|    |  0,  0, -1,  0.5|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
 5         -x,  -x+y,  -z+1/2, +1 | -1,  0,  0,    0|    | -1,  0,  0,    0|
                                  | -1,  1,  0,    0|    | -1,  1,  0,    0|
                                  |  0,  0, -1,  0.5|    |  0,  0, -1,  0.5|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
 6               -x,  -y,  -z, -1 | -1,  0,  0,    0|    | -1,  0,  0,    0|
                                  |  0, -1,  0,    0|    |  0, -1,  0,    0|
                                  |  0,  0, -1,    0|    |  0,  0, -1,    0|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
 7              y,  -x+y,  -z, -1 |  0,  1,  0,    0|    |  0,  1,  0,    0|
                                  | -1,  1,  0,    0|    | -1,  1,  0,    0|
                                  |  0,  0, -1,    0|    |  0,  0, -1,    0|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
 8               x-y,  x,  -z, -1 |  1, -1,  0,    0|    |  1, -1,  0,    0|
                                  |  1,  0,  0,    0|    |  1,  0,  0,    0|
                                  |  0,  0, -1,    0|    |  0,  0, -1,    0|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
 9           -x+y,  y,  z+1/2, -1 | -1,  1,  0,    0|    | -1,  1,  0,    0|
                                  |  0,  1,  0,    0|    |  0,  1,  0,    0|
                                  |  0,  0,  1,  0.5|    |  0,  0,  1,  0.5|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
10            -y,  -x,  z+1/2, -1 |  0, -1,  0,    0|    |  0, -1,  0,    0|
                                  | -1,  0,  0,    0|    | -1,  0,  0,    0|
                                  |  0,  0,  1,  0.5|    |  0,  0,  1,  0.5|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
11            x,  x-y,  z+1/2, -1 |  1,  0,  0,    0|    |  1,  0,  0,    0|
                                  |  1, -1,  0,    0|    |  1, -1,  0,    0|
                                  |  0,  0,  1,  0.5|    |  0,  0,  1,  0.5|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
12      x+2/3,  y+1/3,  z+1/3, +1 |  1,  0,  0,0.667|    |  1,  0,  0,0.667|
                                  |  0,  1,  0,0.333|    |  0,  1,  0,0.333|
                                  |  0,  0,  1,0.333|    |  0,  0,  1,0.333|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
13   -y+2/3,  x-y+1/3,  z+1/3, +1 |  0, -1,  0,0.667|    |  0, -1,  0,0.667|
                                  |  1, -1,  0,0.333|    |  1, -1,  0,0.333|
                                  |  0,  0,  1,0.333|    |  0,  0,  1,0.333|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
14  -x+y+2/3,  -x+1/3,  z+1/3, +1 | -1,  1,  0,0.667|    | -1,  1,  0,0.667|
                                  | -1,  0,  0,0.333|    | -1,  0,  0,0.333|
                                  |  0,  0,  1,0.333|    |  0,  0,  1,0.333|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
15  x-y+2/3,  -y+1/3,  -z+5/6, +1 |  1, -1,  0,0.667|    |  1, -1,  0,0.667|
                                  |  0, -1,  0,0.333|    |  0, -1,  0,0.333|
                                  |  0,  0, -1,0.833|    |  0,  0, -1,0.833|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
16     y+2/3,  x+1/3,  -z+5/6, +1 |  0,  1,  0,0.667|    |  0,  1,  0,0.667|
                                  |  1,  0,  0,0.333|    |  1,  0,  0,0.333|
                                  |  0,  0, -1,0.833|    |  0,  0, -1,0.833|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
17 -x+2/3,  -x+y+1/3,  -z+5/6, +1 | -1,  0,  0,0.667|    | -1,  0,  0,0.667|
                                  | -1,  1,  0,0.333|    | -1,  1,  0,0.333|
                                  |  0,  0, -1,0.833|    |  0,  0, -1,0.833|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
18   -x+2/3,  -y+1/3,  -z+1/3, -1 | -1,  0,  0,0.667|    | -1,  0,  0,0.667|
                                  |  0, -1,  0,0.333|    |  0, -1,  0,0.333|
                                  |  0,  0, -1,0.333|    |  0,  0, -1,0.333|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
19  y+2/3,  -x+y+1/3,  -z+1/3, -1 |  0,  1,  0,0.667|    |  0,  1,  0,0.667|
                                  | -1,  1,  0,0.333|    | -1,  1,  0,0.333|
                                  |  0,  0, -1,0.333|    |  0,  0, -1,0.333|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
20   x-y+2/3,  x+1/3,  -z+1/3, -1 |  1, -1,  0,0.667|    |  1, -1,  0,0.667|
                                  |  1,  0,  0,0.333|    |  1,  0,  0,0.333|
                                  |  0,  0, -1,0.333|    |  0,  0, -1,0.333|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
21   -x+y+2/3,  y+1/3,  z+5/6, -1 | -1,  1,  0,0.667|    | -1,  1,  0,0.667|
                                  |  0,  1,  0,0.333|    |  0,  1,  0,0.333|
                                  |  0,  0,  1,0.833|    |  0,  0,  1,0.833|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
22    -y+2/3,  -x+1/3,  z+5/6, -1 |  0, -1,  0,0.667|    |  0, -1,  0,0.667|
                                  | -1,  0,  0,0.333|    | -1,  0,  0,0.333|
                                  |  0,  0,  1,0.833|    |  0,  0,  1,0.833|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
23    x+2/3,  x-y+1/3,  z+5/6, -1 |  1,  0,  0,0.667|    |  1,  0,  0,0.667|
                                  |  1, -1,  0,0.333|    |  1, -1,  0,0.333|
                                  |  0,  0,  1,0.833|    |  0,  0,  1,0.833|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
24      x+1/3,  y+2/3,  z+2/3, +1 |  1,  0,  0,0.333|    |  1,  0,  0,0.333|
                                  |  0,  1,  0,0.667|    |  0,  1,  0,0.667|
                                  |  0,  0,  1,0.667|    |  0,  0,  1,0.667|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
25   -y+1/3,  x-y+2/3,  z+2/3, +1 |  0, -1,  0,0.333|    |  0, -1,  0,0.333|
                                  |  1, -1,  0,0.667|    |  1, -1,  0,0.667|
                                  |  0,  0,  1,0.667|    |  0,  0,  1,0.667|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
26  -x+y+1/3,  -x+2/3,  z+2/3, +1 | -1,  1,  0,0.333|    | -1,  1,  0,0.333|
                                  | -1,  0,  0,0.667|    | -1,  0,  0,0.667|
                                  |  0,  0,  1,0.667|    |  0,  0,  1,0.667|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
27  x-y+1/3,  -y+2/3,  -z+1/6, +1 |  1, -1,  0,0.333|    |  1, -1,  0,0.333|
                                  |  0, -1,  0,0.667|    |  0, -1,  0,0.667|
                                  |  0,  0, -1,0.167|    |  0,  0, -1,0.167|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
28     y+1/3,  x+2/3,  -z+1/6, +1 |  0,  1,  0,0.333|    |  0,  1,  0,0.333|
                                  |  1,  0,  0,0.667|    |  1,  0,  0,0.667|
                                  |  0,  0, -1,0.167|    |  0,  0, -1,0.167|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
29 -x+1/3,  -x+y+2/3,  -z+1/6, +1 | -1,  0,  0,0.333|    | -1,  0,  0,0.333|
                                  | -1,  1,  0,0.667|    | -1,  1,  0,0.667|
                                  |  0,  0, -1,0.167|    |  0,  0, -1,0.167|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
30   -x+1/3,  -y+2/3,  -z+2/3, -1 | -1,  0,  0,0.333|    | -1,  0,  0,0.333|
                                  |  0, -1,  0,0.667|    |  0, -1,  0,0.667|
                                  |  0,  0, -1,0.667|    |  0,  0, -1,0.667|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
31  y+1/3,  -x+y+2/3,  -z+2/3, -1 |  0,  1,  0,0.333|    |  0,  1,  0,0.333|
                                  | -1,  1,  0,0.667|    | -1,  1,  0,0.667|
                                  |  0,  0, -1,0.667|    |  0,  0, -1,0.667|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
32   x-y+1/3,  x+2/3,  -z+2/3, -1 |  1, -1,  0,0.333|    |  1, -1,  0,0.333|
                                  |  1,  0,  0,0.667|    |  1,  0,  0,0.667|
                                  |  0,  0, -1,0.667|    |  0,  0, -1,0.667|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
33   -x+y+1/3,  y+2/3,  z+1/6, -1 | -1,  1,  0,0.333|    | -1,  1,  0,0.333|
                                  |  0,  1,  0,0.667|    |  0,  1,  0,0.667|
                                  |  0,  0,  1,0.167|    |  0,  0,  1,0.167|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
34    -y+1/3,  -x+2/3,  z+1/6, -1 |  0, -1,  0,0.333|    |  0, -1,  0,0.333|
                                  | -1,  0,  0,0.667|    | -1,  0,  0,0.667|
                                  |  0,  0,  1,0.167|    |  0,  0,  1,0.167|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
35    x+1/3,  x-y+2/3,  z+1/6, -1 |  1,  0,  0,0.333|    |  1,  0,  0,0.333|
                                  |  1, -1,  0,0.667|    |  1, -1,  0,0.667|
                                  |  0,  0,  1,0.167|    |  0,  0,  1,0.167|
                                  |  0,  0,  0,    1|    |  0,  0,  0,    1|
Difference: [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
Method 1: 0.9537832736968994 s
Method 2: 3.2175748348236084 s
Looping all magnetic spacegroups:
Differences: 0 / 47961
"""