# Springheel
A static site generator for webcomics (in beta)

![](springheel-logo.svg)

![](jackie.svg)

Springheel is a static site generator for webcomics.

Whether it's static site generators or Wordpress plugins, most existing software is geared towards blogs, not comics. Adapting them to work with comics is kludgey and fragile, and unnecessarily exposes you to security problems. But why force a square peg into a round hole when round pegs are easy enough to make? With that in mind I created Springheel. (The name comes from Spring-heel Jack, for the "English monster" naming scheme that many static generators keep to.)

Springheel is built with Python >= 3.7, [Feedgenerator](https://pypi.org/project/feedgen), [python-slugify](https://pypi.org/project/python-slugify), and [tdqm](https://pypi.org/project/tqdm).

A pre-built version of the documentation is available in the source package. To build documentation from source, you will need [Sphinx](https://pypi.org/project/sphinx) and [Numpydoc](https://pypi.org/project/numpydoc). To build documentation in the HTML format, you will also need a Sphinx theme called "pyramida" -- you can either edit the value of `html_theme` in `docsource/conf.py`, or open your Sphinx theme directory and create a symbolic link from the existing "pyramid" theme to "pyramida".

Keep in mind that I'm self-taught \([obligatory xkcd](http://www.xkcd.com/1513/)\) and maybe don't look too closely at the actual code.

## Features

+ Easy to use. Updating is a matter of putting a couple of files in a folder and running a single script. Building hundreds of pages takes less than a minute even on a slowish computer.
+ Lots of customization. Use your site as a hub for multiple comics or just one; select any of *dozens* of (responsive) default themes or roll your own; fiddle with almost any aspect of the finished site you can think of. Not to mention that the generated HTML is clean and easy to modify. It's all up to you!
+ Small and secure. Keep hosting costs down, and never worry about updating Wordpress again (and again and again...) because of yet another gaping security flaw.
+ Relatively accessible. Generated sites use semantic HTML5 with alt text, skip links, and link rel navigation. They're designed to include plaintext transcripts too. The default themes are large and easy to read, and their color schemes comply with WCAG AAA.
+ Everything a comic (not a blog) needs. Making a characters page is so quick, you'll never have an out-of-date one again! Sections for creator commentaries are included by default too.
+ Bring back creator-run syndication. Springheel generates RSS feeds and even [JSON Feeds](https://jsonfeed.org/), so no one has to miss a strip due to fickle corporate social media algorithms.
+ Easy reading. If your comic is divided into chapters, Springheel generates easily navigable "chapter pages" that display all of each chapter's strips at once.
+ Freely licensed. Springheel is GPLv3+ software that anyone can fork and contribute to. (Releasing Springheeled comics under a Free Culture license is encouraged but not required.)
+ Cute mascot!

## Installing

Springheel requires at least **Python 3.7.**

If you want to build from the git source, you'll need the following dependencies:

+ [Feedgenerator](https://pypi.org/project/feedgen)
+ [python-slugify](https://pypi.org/project/python-slugify)
+ [tdqm](https://pypi.org/project/tqdm)

Then navigate to the springheel directory, and run `setup.py install`. You may need to start a virtual environment, or run this with `su -c` or `--user`, depending on the type of Python install you have.

**Important**: If you're on Windows and get an error about Visual C++ while installing dependencies (lxml especially), do not panic! Just use pip to install that specific library directly, then try to install springheel again.

**Also important**: Multiple different Python libraries call themselves "slugify" and collide with each other, so bad things happen if you have e.g. both `python-slugify` and `unicode-slugify` installed. To ensure that this software works as intended, you will need to either install Springheel in a clean virtual environment, or completely remove all "slugify" libraries but `python-slugify`.

## License

Copyright 2017-2021 garrick. Some rights reserved.

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.

To the extent possible under the law of the United States, the image files included in `themes/` and `arrows/` are released into the public domain.
