import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type Stackery::Open::Bastion::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Parameters
     */
    readonly parameters?: CfnModulePropsParameters;
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsParameters
 */
export interface CfnModulePropsParameters {
    /**
     * VPC to run bastion server in.
     *
     * @schema CfnModulePropsParameters#VPCId
     */
    readonly vpcId?: CfnModulePropsParametersVpcId;
    /**
     * Subnets to pick from to run a bastion server in.
     *
     * @schema CfnModulePropsParameters#VPCSubnets
     */
    readonly vpcSubnets?: CfnModulePropsParametersVpcSubnets;
    /**
     * EC2 instance class to provision.
     *
     * @schema CfnModulePropsParameters#InstanceClass
     */
    readonly instanceClass?: CfnModulePropsParametersInstanceClass;
}
/**
 * Converts an object of type 'CfnModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnModulePropsParameters(obj: CfnModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#AutoScalingGroup
     */
    readonly autoScalingGroup?: CfnModulePropsResourcesAutoScalingGroup;
    /**
     * @schema CfnModulePropsResources#IAMRole
     */
    readonly iamRole?: CfnModulePropsResourcesIamRole;
    /**
     * @schema CfnModulePropsResources#IAMInstanceProfile
     */
    readonly iamInstanceProfile?: CfnModulePropsResourcesIamInstanceProfile;
    /**
     * @schema CfnModulePropsResources#InstancesSecurityGroup
     */
    readonly instancesSecurityGroup?: CfnModulePropsResourcesInstancesSecurityGroup;
    /**
     * @schema CfnModulePropsResources#LaunchConfiguration
     */
    readonly launchConfiguration?: CfnModulePropsResourcesLaunchConfiguration;
    /**
     * @schema CfnModulePropsResources#SSMAgentAutoUpdate
     */
    readonly ssmAgentAutoUpdate?: CfnModulePropsResourcesSsmAgentAutoUpdate;
    /**
     * @schema CfnModulePropsResources#CloudWatchAgentUpdateAndStart
     */
    readonly cloudWatchAgentUpdateAndStart?: CfnModulePropsResourcesCloudWatchAgentUpdateAndStart;
    /**
     * @schema CfnModulePropsResources#CloudWatchAgentAutoUpdate
     */
    readonly cloudWatchAgentAutoUpdate?: CfnModulePropsResourcesCloudWatchAgentAutoUpdate;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * VPC to run bastion server in.
 *
 * @schema CfnModulePropsParametersVpcId
 */
export interface CfnModulePropsParametersVpcId {
    /**
     * @schema CfnModulePropsParametersVpcId#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcId#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcId' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcId(obj: CfnModulePropsParametersVpcId | undefined): Record<string, any> | undefined;
/**
 * Subnets to pick from to run a bastion server in.
 *
 * @schema CfnModulePropsParametersVpcSubnets
 */
export interface CfnModulePropsParametersVpcSubnets {
    /**
     * @schema CfnModulePropsParametersVpcSubnets#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersVpcSubnets#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersVpcSubnets' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersVpcSubnets(obj: CfnModulePropsParametersVpcSubnets | undefined): Record<string, any> | undefined;
/**
 * EC2 instance class to provision.
 *
 * @schema CfnModulePropsParametersInstanceClass
 */
export interface CfnModulePropsParametersInstanceClass {
    /**
     * @schema CfnModulePropsParametersInstanceClass#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersInstanceClass#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersInstanceClass' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersInstanceClass(obj: CfnModulePropsParametersInstanceClass | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesAutoScalingGroup
 */
export interface CfnModulePropsResourcesAutoScalingGroup {
    /**
     * @schema CfnModulePropsResourcesAutoScalingGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesAutoScalingGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesAutoScalingGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesAutoScalingGroup(obj: CfnModulePropsResourcesAutoScalingGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesIamRole
 */
export interface CfnModulePropsResourcesIamRole {
    /**
     * @schema CfnModulePropsResourcesIamRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesIamRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesIamRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesIamRole(obj: CfnModulePropsResourcesIamRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesIamInstanceProfile
 */
export interface CfnModulePropsResourcesIamInstanceProfile {
    /**
     * @schema CfnModulePropsResourcesIamInstanceProfile#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesIamInstanceProfile#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesIamInstanceProfile' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesIamInstanceProfile(obj: CfnModulePropsResourcesIamInstanceProfile | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesInstancesSecurityGroup
 */
export interface CfnModulePropsResourcesInstancesSecurityGroup {
    /**
     * @schema CfnModulePropsResourcesInstancesSecurityGroup#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesInstancesSecurityGroup#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesInstancesSecurityGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesInstancesSecurityGroup(obj: CfnModulePropsResourcesInstancesSecurityGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesLaunchConfiguration
 */
export interface CfnModulePropsResourcesLaunchConfiguration {
    /**
     * @schema CfnModulePropsResourcesLaunchConfiguration#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesLaunchConfiguration#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesLaunchConfiguration' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesLaunchConfiguration(obj: CfnModulePropsResourcesLaunchConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesSsmAgentAutoUpdate
 */
export interface CfnModulePropsResourcesSsmAgentAutoUpdate {
    /**
     * @schema CfnModulePropsResourcesSsmAgentAutoUpdate#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesSsmAgentAutoUpdate#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesSsmAgentAutoUpdate' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesSsmAgentAutoUpdate(obj: CfnModulePropsResourcesSsmAgentAutoUpdate | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesCloudWatchAgentUpdateAndStart
 */
export interface CfnModulePropsResourcesCloudWatchAgentUpdateAndStart {
    /**
     * @schema CfnModulePropsResourcesCloudWatchAgentUpdateAndStart#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesCloudWatchAgentUpdateAndStart#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesCloudWatchAgentUpdateAndStart' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesCloudWatchAgentUpdateAndStart(obj: CfnModulePropsResourcesCloudWatchAgentUpdateAndStart | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesCloudWatchAgentAutoUpdate
 */
export interface CfnModulePropsResourcesCloudWatchAgentAutoUpdate {
    /**
     * @schema CfnModulePropsResourcesCloudWatchAgentAutoUpdate#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesCloudWatchAgentAutoUpdate#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesCloudWatchAgentAutoUpdate' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesCloudWatchAgentAutoUpdate(obj: CfnModulePropsResourcesCloudWatchAgentAutoUpdate | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Stackery::Open::Bastion::MODULE`.
 *
 * @external
 * @cloudformationResource Stackery::Open::Bastion::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Stackery::Open::Bastion::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `Stackery::Open::Bastion::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
