# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['yara_scanner']

package_data = \
{'': ['*']}

install_requires = \
['plyara>=2.0.3,<3.0.0', 'psutil>=5.6.7,<6.0.0', 'yara-python>=3.11.0,<4.0.0']

entry_points = \
{'console_scripts': ['scan = yara_scanner:main',
                     'ysc = ysc:main',
                     'yss = yss:main']}

setup_kwargs = {
    'name': 'yara-scanner',
    'version': '1.0.16',
    'description': 'A Python wrapper library for libyara and a local server for fully utilizing the CPUs of the system to scan with yara.',
    'long_description': '[![ace-ecosystem](https://circleci.com/gh/ace-ecosystem/yara_scanner.svg?style=svg)](https://circleci.com/gh/ace-ecosystem/yara_scanner)\n\n# Yara Scanner # \n\nA wrapper around the [yara-python](https://github.com/VirusTotal/yara-python) project the provides the following capabilities.\n- Change tracking of yara files, directories of yara files, or git repositories of yara files.\n- File and data scanning with the ability to filter based on meta data matching.\n- Distributed scanning processes that maximize the use of multi-core systems.\n- Command line interface.\n\n## Python Examples ##\n\nLoading a single yara file and then scanning data.\n\n```python\nfrom pprint import pprint\nfrom yara_scanner import YaraScanner\n\nscanner = YaraScanner()\n# tells the scanner to start tracking this yara file\nscanner.track_yara_file(\'my_rules.yar\')\nscanner.load_rules()\nif scanner.scan(\'/path/to/scan_target.txt\'):\n   pprint(scanner.scan_results)\n   \n# this returns True if any tracked yara files have changed\nif scanner.check_rules():\n   scanner.load_rules()\n```\n\n## Installation Instructions ##\n\n```bash\npip install yara-scanner\n```\n\n## Command Line Instructions ##\n\n   ```\n   usage: scan [-h] [-r] [--from-stdin] [--debug] [-j] [-t] [-y YARA_RULES]\n               [-Y YARA_DIRS] [-G YARA_REPOS] [-c] [-b BLACKLISTED_RULES]\n               [-B BLACKLISTED_RULES_PATH] [-d SIGNATURE_DIR]\n               [PATHS [PATHS ...]]\n\n   Scan the given file with yara using all available rulesets.\n\n   positional arguments:\n     PATHS                 One or more files or directories to scan with yara.\n\n   optional arguments:\n     -h, --help            show this help message and exit\n     -r, --recursive       Recursively scan directories.\n     --from-stdin          Read the list of files to scan from stdin.\n     --debug               Log debug level messages.\n     -j, --dump-json       Dump JSON details of matches. Otherwise just list the\n                           rules that hit.\n     -t, --test            Test each yara file separately against different types\n                           of buffers for performance issues.\n     -y YARA_RULES, --yara-rules YARA_RULES\n                           One yara rule to load. You can specify more than one\n                           of these.\n     -Y YARA_DIRS, --yara-dirs YARA_DIRS\n                           One directory containing yara rules to load. You can\n                           specify more than one of these.\n     -G YARA_REPOS, --yara-repos YARA_REPOS\n                           One directory that is a git repository that contains\n                           yara rules to load. You can specify more than one of\n                           these.\n     -c, --compile-only    Compile the rules and exit.\n     -b BLACKLISTED_RULES, --blacklist BLACKLISTED_RULES\n                           A rule to blacklist (remove from the results.) You can\n                           specify more than one of these options.\n     -B BLACKLISTED_RULES_PATH, --blacklist-path BLACKLISTED_RULES_PATH\n                           Path to a file that contains a list of rules to\n                           blacklist, one per line.\n   ```\n   \n## Command Line Examples ##\n- scan a single file\n   ```bash\n   scan ms0day.ppsx\n   ```\n- scan a single file and generate JSON output\n   ```bash\n   scan -j ms0day.ppsx\n   scan -j ms0day.ppsx | json_pp\n   ```  \n- scan multiple files\n   ```bash\n   scan file1 file2 file3\n   ```\n- scan all files in a directory and all sub-directories\n   ```bash\n   scan -r dir\n   ```\n- scan a list of files passed in on standard input\n   ``` bash\n   find dridex -type f | scan --from-stdin\n   ```\n- scan a single file with a single yara rule\n   ```bash\n   scan -y myrule.yar target_file\n   ```\n- scan a single file with all rules in a given directory\n  ```bash\n  scan -Y my_rule_dir target_file\n  ```\n- check the syntax of all the rules in a given directory\n   ```bash\n   scan -c -Y my_rule_dir\n   ```\n\n## Blacklisting ##\nThe scan tool also supports "blacklisting" rules. These are specified by using the -b and -B command line options. These allow you to exclude certain rules from the search results rather than making changes to the rules themselves. We use this technique to allow us to use the open source yara repository as-is, rather than trying to maintain a modified branch.       \n   \n## Rule Output Selection ##\nYou can specify when a rule should (or should not) be displayed. This allows you to prevent some rules from matching against certain kinds of files, or for a rule to be matched against only one specific file.\n\nThe rules are specified as metadata name and value pairs. (example rule syntax)\n   \n```yara\nrule html_rule: odd html\n{\nmeta:\n   mime_type = "text/html"\nstrings:\n   ...\ncondition:\n   ...\n}\n```\n### Metadata Names and Descriptions ###\n```\nfile_ext   | Matches everything past the first period in the file name.\nfile_name  | Matches the full name of the file (not including the path.)\nfull_path  | Matches against the full path of the file, if one was specified.\nmime_type  | Matches against the output of file -b --mime-type.\n```\n\nThe value of the metadata variable is the string to match. By default the library matches as is, but special modifiers can be used to perform sub string matching and regular expressions. ** Special modifiers are added to the beginning of the value (or list of values) and apply to all values in the string. **\n      \n### Matching Modifiers ###\n```\n!     | negation    | Negates the match. This can be placed before other modifiers.\nsub:  | sub-search  | Match if this string appears anywhere.\nre:   | regex       | Match if the regular expression is satisfied.\n```\n\nValues can be a comma separated list of values, regardless of the modifiers. Therefor, commas cannot be used in the patterns.\n\n### Rule Selection Examples ###\nOnly match files the end with the .exe extension.\n\n``` \nfile_ext = "exe"\n```\n      \nOnly match files that end with .exe, .dll or .ocx extension.\n\n```\nfile_ext = "exe, dll, ocx"\n```\n      \nOnly match files that do not end with .exe, .dll or .ocx extension.\n\n```\nfile_ext = "!exe, dll, ocx"\n```\n     \nOnly matches files that do not end with .bmp.\n\n```\nfile_ext = "!bmp"\n```\n      \nOnly match files identified as PDF despite the file name.\n\n```\nmime_type = "application/pdf"\n```\n      \nOnly match files not identified as images.\n\n```\nmime_type = "!sub:image/"\n```\n      \nOnly match files that look like an invoice phish.\n\n```\nfile_name = "re:invoice[0-9]+\\\\.doc$"\n```\n      \nOnly match files in a subdirectory called /ole.\n\n```\nfull_path = "sub:/ole/"\n```\n',
    'author': 'John Davison',
    'author_email': 'unixfreak0037@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ace-ecosystem/yara_scanner',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
