# coding: utf-8

"""
    ExtremeCloud IQ API

    ExtremeCloud IQ RESTful API for external and internal applications.  # noqa: E501

    The version of the OpenAPI document: 22.6.4.1
    Contact: support@extremenetworks.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from extremecloudiq.configuration import Configuration


class XiqRpRadioUsageOptimization(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'create_time': 'datetime',
        'update_time': 'datetime',
        'preamble': 'str',
        'beacon_period': 'int',
        'enable_frame_burst': 'bool',
        'enable_smart_antenna': 'bool',
        'enable_backhaul_failover': 'bool',
        'wireless_backhaul_switch_trigger_time': 'int',
        'wired_backhaul_revert_hold_time': 'int',
        'enable_band_steering': 'bool',
        'band_steering_mode': 'str',
        'ignore_initial_client_connection_number': 'int',
        'enable_client_load_balancing': 'bool',
        'load_balancing_mode': 'str',
        'crc_error_rate_per_device': 'int',
        'rf_interference_per_device': 'int',
        'average_airtime_per_client': 'int',
        'anchor_period': 'int',
        'neighbor_query_interval': 'int',
        'enable_weak_signal_probe_request_suppression': 'bool',
        'weak_snr_threshold': 'int',
        'enable_safety_net': 'bool',
        'safety_net_period': 'int',
        'enable_high_density': 'bool',
        'management_frame_basic_data_rate': 'str',
        'enable_suppress_successive_probe_request': 'bool',
        'probe_response_reduction_option': 'str',
        'suppression_limit': 'int',
        'enable_radio_balance': 'bool',
        'enable_ampdu': 'bool',
        'enable_mu_mimo': 'bool',
        'enable_ofdma_down_link': 'bool',
        'enable_ofdma_up_link': 'bool',
        'bss_coloring': 'int',
        'enable_target_weak_time': 'bool',
        'mac_ouis': 'list[XiqRpMacOuiProfile]',
        'ratio_for_5g_clients': 'int'
    }

    attribute_map = {
        'id': 'id',
        'create_time': 'create_time',
        'update_time': 'update_time',
        'preamble': 'preamble',
        'beacon_period': 'beacon_period',
        'enable_frame_burst': 'enable_frame_burst',
        'enable_smart_antenna': 'enable_smart_antenna',
        'enable_backhaul_failover': 'enable_backhaul_failover',
        'wireless_backhaul_switch_trigger_time': 'wireless_backhaul_switch_trigger_time',
        'wired_backhaul_revert_hold_time': 'wired_backhaul_revert_hold_time',
        'enable_band_steering': 'enable_band_steering',
        'band_steering_mode': 'band_steering_mode',
        'ignore_initial_client_connection_number': 'ignore_initial_client_connection_number',
        'enable_client_load_balancing': 'enable_client_load_balancing',
        'load_balancing_mode': 'load_balancing_mode',
        'crc_error_rate_per_device': 'crc_error_rate_per_device',
        'rf_interference_per_device': 'rf_interference_per_device',
        'average_airtime_per_client': 'average_airtime_per_client',
        'anchor_period': 'anchor_period',
        'neighbor_query_interval': 'neighbor_query_interval',
        'enable_weak_signal_probe_request_suppression': 'enable_weak_signal_probe_request_suppression',
        'weak_snr_threshold': 'weak_snr_threshold',
        'enable_safety_net': 'enable_safety_net',
        'safety_net_period': 'safety_net_period',
        'enable_high_density': 'enable_high_density',
        'management_frame_basic_data_rate': 'management_frame_basic_data_rate',
        'enable_suppress_successive_probe_request': 'enable_suppress_successive_probe_request',
        'probe_response_reduction_option': 'probe_response_reduction_option',
        'suppression_limit': 'suppression_limit',
        'enable_radio_balance': 'enable_radio_balance',
        'enable_ampdu': 'enable_ampdu',
        'enable_mu_mimo': 'enable_mu_mimo',
        'enable_ofdma_down_link': 'enable_ofdma_down_link',
        'enable_ofdma_up_link': 'enable_ofdma_up_link',
        'bss_coloring': 'bss_coloring',
        'enable_target_weak_time': 'enable_target_weak_time',
        'mac_ouis': 'mac_ouis',
        'ratio_for_5g_clients': 'ratio_for_5g_clients'
    }

    def __init__(self, id=None, create_time=None, update_time=None, preamble=None, beacon_period=None, enable_frame_burst=None, enable_smart_antenna=None, enable_backhaul_failover=None, wireless_backhaul_switch_trigger_time=None, wired_backhaul_revert_hold_time=None, enable_band_steering=None, band_steering_mode=None, ignore_initial_client_connection_number=None, enable_client_load_balancing=None, load_balancing_mode=None, crc_error_rate_per_device=None, rf_interference_per_device=None, average_airtime_per_client=None, anchor_period=None, neighbor_query_interval=None, enable_weak_signal_probe_request_suppression=None, weak_snr_threshold=None, enable_safety_net=None, safety_net_period=None, enable_high_density=None, management_frame_basic_data_rate=None, enable_suppress_successive_probe_request=None, probe_response_reduction_option=None, suppression_limit=None, enable_radio_balance=None, enable_ampdu=None, enable_mu_mimo=None, enable_ofdma_down_link=None, enable_ofdma_up_link=None, bss_coloring=None, enable_target_weak_time=None, mac_ouis=None, ratio_for_5g_clients=None, local_vars_configuration=None):  # noqa: E501
        """XiqRpRadioUsageOptimization - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._create_time = None
        self._update_time = None
        self._preamble = None
        self._beacon_period = None
        self._enable_frame_burst = None
        self._enable_smart_antenna = None
        self._enable_backhaul_failover = None
        self._wireless_backhaul_switch_trigger_time = None
        self._wired_backhaul_revert_hold_time = None
        self._enable_band_steering = None
        self._band_steering_mode = None
        self._ignore_initial_client_connection_number = None
        self._enable_client_load_balancing = None
        self._load_balancing_mode = None
        self._crc_error_rate_per_device = None
        self._rf_interference_per_device = None
        self._average_airtime_per_client = None
        self._anchor_period = None
        self._neighbor_query_interval = None
        self._enable_weak_signal_probe_request_suppression = None
        self._weak_snr_threshold = None
        self._enable_safety_net = None
        self._safety_net_period = None
        self._enable_high_density = None
        self._management_frame_basic_data_rate = None
        self._enable_suppress_successive_probe_request = None
        self._probe_response_reduction_option = None
        self._suppression_limit = None
        self._enable_radio_balance = None
        self._enable_ampdu = None
        self._enable_mu_mimo = None
        self._enable_ofdma_down_link = None
        self._enable_ofdma_up_link = None
        self._bss_coloring = None
        self._enable_target_weak_time = None
        self._mac_ouis = None
        self._ratio_for_5g_clients = None
        self.discriminator = None

        self.id = id
        self.create_time = create_time
        self.update_time = update_time
        if preamble is not None:
            self.preamble = preamble
        if beacon_period is not None:
            self.beacon_period = beacon_period
        if enable_frame_burst is not None:
            self.enable_frame_burst = enable_frame_burst
        if enable_smart_antenna is not None:
            self.enable_smart_antenna = enable_smart_antenna
        if enable_backhaul_failover is not None:
            self.enable_backhaul_failover = enable_backhaul_failover
        if wireless_backhaul_switch_trigger_time is not None:
            self.wireless_backhaul_switch_trigger_time = wireless_backhaul_switch_trigger_time
        if wired_backhaul_revert_hold_time is not None:
            self.wired_backhaul_revert_hold_time = wired_backhaul_revert_hold_time
        if enable_band_steering is not None:
            self.enable_band_steering = enable_band_steering
        if band_steering_mode is not None:
            self.band_steering_mode = band_steering_mode
        if ignore_initial_client_connection_number is not None:
            self.ignore_initial_client_connection_number = ignore_initial_client_connection_number
        if enable_client_load_balancing is not None:
            self.enable_client_load_balancing = enable_client_load_balancing
        if load_balancing_mode is not None:
            self.load_balancing_mode = load_balancing_mode
        if crc_error_rate_per_device is not None:
            self.crc_error_rate_per_device = crc_error_rate_per_device
        if rf_interference_per_device is not None:
            self.rf_interference_per_device = rf_interference_per_device
        if average_airtime_per_client is not None:
            self.average_airtime_per_client = average_airtime_per_client
        if anchor_period is not None:
            self.anchor_period = anchor_period
        if neighbor_query_interval is not None:
            self.neighbor_query_interval = neighbor_query_interval
        if enable_weak_signal_probe_request_suppression is not None:
            self.enable_weak_signal_probe_request_suppression = enable_weak_signal_probe_request_suppression
        if weak_snr_threshold is not None:
            self.weak_snr_threshold = weak_snr_threshold
        if enable_safety_net is not None:
            self.enable_safety_net = enable_safety_net
        if safety_net_period is not None:
            self.safety_net_period = safety_net_period
        if enable_high_density is not None:
            self.enable_high_density = enable_high_density
        if management_frame_basic_data_rate is not None:
            self.management_frame_basic_data_rate = management_frame_basic_data_rate
        if enable_suppress_successive_probe_request is not None:
            self.enable_suppress_successive_probe_request = enable_suppress_successive_probe_request
        if probe_response_reduction_option is not None:
            self.probe_response_reduction_option = probe_response_reduction_option
        if suppression_limit is not None:
            self.suppression_limit = suppression_limit
        if enable_radio_balance is not None:
            self.enable_radio_balance = enable_radio_balance
        if enable_ampdu is not None:
            self.enable_ampdu = enable_ampdu
        if enable_mu_mimo is not None:
            self.enable_mu_mimo = enable_mu_mimo
        if enable_ofdma_down_link is not None:
            self.enable_ofdma_down_link = enable_ofdma_down_link
        if enable_ofdma_up_link is not None:
            self.enable_ofdma_up_link = enable_ofdma_up_link
        if bss_coloring is not None:
            self.bss_coloring = bss_coloring
        if enable_target_weak_time is not None:
            self.enable_target_weak_time = enable_target_weak_time
        if mac_ouis is not None:
            self.mac_ouis = mac_ouis
        if ratio_for_5g_clients is not None:
            self.ratio_for_5g_clients = ratio_for_5g_clients

    @property
    def id(self):
        """Gets the id of this XiqRpRadioUsageOptimization.  # noqa: E501

        The unique identifier  # noqa: E501

        :return: The id of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this XiqRpRadioUsageOptimization.

        The unique identifier  # noqa: E501

        :param id: The id of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def create_time(self):
        """Gets the create_time of this XiqRpRadioUsageOptimization.  # noqa: E501

        The create time  # noqa: E501

        :return: The create_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: datetime
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this XiqRpRadioUsageOptimization.

        The create time  # noqa: E501

        :param create_time: The create_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and create_time is None:  # noqa: E501
            raise ValueError("Invalid value for `create_time`, must not be `None`")  # noqa: E501

        self._create_time = create_time

    @property
    def update_time(self):
        """Gets the update_time of this XiqRpRadioUsageOptimization.  # noqa: E501

        The last update time  # noqa: E501

        :return: The update_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: datetime
        """
        return self._update_time

    @update_time.setter
    def update_time(self, update_time):
        """Sets the update_time of this XiqRpRadioUsageOptimization.

        The last update time  # noqa: E501

        :param update_time: The update_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and update_time is None:  # noqa: E501
            raise ValueError("Invalid value for `update_time`, must not be `None`")  # noqa: E501

        self._update_time = update_time

    @property
    def preamble(self):
        """Gets the preamble of this XiqRpRadioUsageOptimization.  # noqa: E501

        The preamble data length -- \"AUTO\" or \"LONG\"  # noqa: E501

        :return: The preamble of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: str
        """
        return self._preamble

    @preamble.setter
    def preamble(self, preamble):
        """Sets the preamble of this XiqRpRadioUsageOptimization.

        The preamble data length -- \"AUTO\" or \"LONG\"  # noqa: E501

        :param preamble: The preamble of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: str
        """

        self._preamble = preamble

    @property
    def beacon_period(self):
        """Gets the beacon_period of this XiqRpRadioUsageOptimization.  # noqa: E501

        The amount of time between beacons from 40 up to 3500.  # noqa: E501

        :return: The beacon_period of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._beacon_period

    @beacon_period.setter
    def beacon_period(self, beacon_period):
        """Sets the beacon_period of this XiqRpRadioUsageOptimization.

        The amount of time between beacons from 40 up to 3500.  # noqa: E501

        :param beacon_period: The beacon_period of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._beacon_period = beacon_period

    @property
    def enable_frame_burst(self):
        """Gets the enable_frame_burst of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable Frame Burst  # noqa: E501

        :return: The enable_frame_burst of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_frame_burst

    @enable_frame_burst.setter
    def enable_frame_burst(self, enable_frame_burst):
        """Sets the enable_frame_burst of this XiqRpRadioUsageOptimization.

        Whether to enable Frame Burst  # noqa: E501

        :param enable_frame_burst: The enable_frame_burst of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_frame_burst = enable_frame_burst

    @property
    def enable_smart_antenna(self):
        """Gets the enable_smart_antenna of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable Smart Antenna (Enabling this option will disable (Null) for MU-MIMO)  # noqa: E501

        :return: The enable_smart_antenna of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_smart_antenna

    @enable_smart_antenna.setter
    def enable_smart_antenna(self, enable_smart_antenna):
        """Sets the enable_smart_antenna of this XiqRpRadioUsageOptimization.

        Whether to enable Smart Antenna (Enabling this option will disable (Null) for MU-MIMO)  # noqa: E501

        :param enable_smart_antenna: The enable_smart_antenna of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_smart_antenna = enable_smart_antenna

    @property
    def enable_backhaul_failover(self):
        """Gets the enable_backhaul_failover of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable backhaul failover. Backhaul failover settings determine the thresholds at which the device switches from a wired to a wireless backhaul link, and the thresholds at which the device switches back  # noqa: E501

        :return: The enable_backhaul_failover of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_backhaul_failover

    @enable_backhaul_failover.setter
    def enable_backhaul_failover(self, enable_backhaul_failover):
        """Sets the enable_backhaul_failover of this XiqRpRadioUsageOptimization.

        Whether to enable backhaul failover. Backhaul failover settings determine the thresholds at which the device switches from a wired to a wireless backhaul link, and the thresholds at which the device switches back  # noqa: E501

        :param enable_backhaul_failover: The enable_backhaul_failover of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_backhaul_failover = enable_backhaul_failover

    @property
    def wireless_backhaul_switch_trigger_time(self):
        """Gets the wireless_backhaul_switch_trigger_time of this XiqRpRadioUsageOptimization.  # noqa: E501

        Switch to Wireless Backhaul after 1 up to 5 seconds after the wired link fails  # noqa: E501

        :return: The wireless_backhaul_switch_trigger_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._wireless_backhaul_switch_trigger_time

    @wireless_backhaul_switch_trigger_time.setter
    def wireless_backhaul_switch_trigger_time(self, wireless_backhaul_switch_trigger_time):
        """Sets the wireless_backhaul_switch_trigger_time of this XiqRpRadioUsageOptimization.

        Switch to Wireless Backhaul after 1 up to 5 seconds after the wired link fails  # noqa: E501

        :param wireless_backhaul_switch_trigger_time: The wireless_backhaul_switch_trigger_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._wireless_backhaul_switch_trigger_time = wireless_backhaul_switch_trigger_time

    @property
    def wired_backhaul_revert_hold_time(self):
        """Gets the wired_backhaul_revert_hold_time of this XiqRpRadioUsageOptimization.  # noqa: E501

        Revert Back to Wired Backhaul after 1 up to 300 seconds after the wired link is established  # noqa: E501

        :return: The wired_backhaul_revert_hold_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._wired_backhaul_revert_hold_time

    @wired_backhaul_revert_hold_time.setter
    def wired_backhaul_revert_hold_time(self, wired_backhaul_revert_hold_time):
        """Sets the wired_backhaul_revert_hold_time of this XiqRpRadioUsageOptimization.

        Revert Back to Wired Backhaul after 1 up to 300 seconds after the wired link is established  # noqa: E501

        :param wired_backhaul_revert_hold_time: The wired_backhaul_revert_hold_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._wired_backhaul_revert_hold_time = wired_backhaul_revert_hold_time

    @property
    def enable_band_steering(self):
        """Gets the enable_band_steering of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable band steering. Enabling steers clients from 2.4 GHz to 5.0 GHz radio band  # noqa: E501

        :return: The enable_band_steering of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_band_steering

    @enable_band_steering.setter
    def enable_band_steering(self, enable_band_steering):
        """Sets the enable_band_steering of this XiqRpRadioUsageOptimization.

        Whether to enable band steering. Enabling steers clients from 2.4 GHz to 5.0 GHz radio band  # noqa: E501

        :param enable_band_steering: The enable_band_steering of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_band_steering = enable_band_steering

    @property
    def band_steering_mode(self):
        """Gets the band_steering_mode of this XiqRpRadioUsageOptimization.  # noqa: E501

        The band steering mode -- \"BALANCE\", \"URGE_5G\", or \"ENFORCE_5G\"  # noqa: E501

        :return: The band_steering_mode of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: str
        """
        return self._band_steering_mode

    @band_steering_mode.setter
    def band_steering_mode(self, band_steering_mode):
        """Sets the band_steering_mode of this XiqRpRadioUsageOptimization.

        The band steering mode -- \"BALANCE\", \"URGE_5G\", or \"ENFORCE_5G\"  # noqa: E501

        :param band_steering_mode: The band_steering_mode of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: str
        """

        self._band_steering_mode = band_steering_mode

    @property
    def ignore_initial_client_connection_number(self):
        """Gets the ignore_initial_client_connection_number of this XiqRpRadioUsageOptimization.  # noqa: E501

        The number of connection attempts from 1 to 100 for 2.4 GHz clients to ignore before responding for URGE_5G steering mode.  # noqa: E501

        :return: The ignore_initial_client_connection_number of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._ignore_initial_client_connection_number

    @ignore_initial_client_connection_number.setter
    def ignore_initial_client_connection_number(self, ignore_initial_client_connection_number):
        """Sets the ignore_initial_client_connection_number of this XiqRpRadioUsageOptimization.

        The number of connection attempts from 1 to 100 for 2.4 GHz clients to ignore before responding for URGE_5G steering mode.  # noqa: E501

        :param ignore_initial_client_connection_number: The ignore_initial_client_connection_number of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._ignore_initial_client_connection_number = ignore_initial_client_connection_number

    @property
    def enable_client_load_balancing(self):
        """Gets the enable_client_load_balancing of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable client load balancing.  Enabling load-balances clients across neighboring Extreme Networks within the same hive. Set WiFi0 and WiFi1 radios to the same load balancing mode when it is based on the number of associated stations.  # noqa: E501

        :return: The enable_client_load_balancing of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_client_load_balancing

    @enable_client_load_balancing.setter
    def enable_client_load_balancing(self, enable_client_load_balancing):
        """Sets the enable_client_load_balancing of this XiqRpRadioUsageOptimization.

        Whether to enable client load balancing.  Enabling load-balances clients across neighboring Extreme Networks within the same hive. Set WiFi0 and WiFi1 radios to the same load balancing mode when it is based on the number of associated stations.  # noqa: E501

        :param enable_client_load_balancing: The enable_client_load_balancing of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_client_load_balancing = enable_client_load_balancing

    @property
    def load_balancing_mode(self):
        """Gets the load_balancing_mode of this XiqRpRadioUsageOptimization.  # noqa: E501

        The client load balancing mode -- \"AIRTIME_BASED\" or \"CLIENT_NUMBER\"  # noqa: E501

        :return: The load_balancing_mode of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: str
        """
        return self._load_balancing_mode

    @load_balancing_mode.setter
    def load_balancing_mode(self, load_balancing_mode):
        """Sets the load_balancing_mode of this XiqRpRadioUsageOptimization.

        The client load balancing mode -- \"AIRTIME_BASED\" or \"CLIENT_NUMBER\"  # noqa: E501

        :param load_balancing_mode: The load_balancing_mode of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: str
        """

        self._load_balancing_mode = load_balancing_mode

    @property
    def crc_error_rate_per_device(self):
        """Gets the crc_error_rate_per_device of this XiqRpRadioUsageOptimization.  # noqa: E501

        The CRC Error rate threshold from 1 up to 99 for \"AIRTIME_BASED\" load balancing. Ignore probe and association requests per device when CRC Error rate exceeds the threshold.  # noqa: E501

        :return: The crc_error_rate_per_device of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._crc_error_rate_per_device

    @crc_error_rate_per_device.setter
    def crc_error_rate_per_device(self, crc_error_rate_per_device):
        """Sets the crc_error_rate_per_device of this XiqRpRadioUsageOptimization.

        The CRC Error rate threshold from 1 up to 99 for \"AIRTIME_BASED\" load balancing. Ignore probe and association requests per device when CRC Error rate exceeds the threshold.  # noqa: E501

        :param crc_error_rate_per_device: The crc_error_rate_per_device of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._crc_error_rate_per_device = crc_error_rate_per_device

    @property
    def rf_interference_per_device(self):
        """Gets the rf_interference_per_device of this XiqRpRadioUsageOptimization.  # noqa: E501

        The RF Interference threshold from 1 up to 99 for \"AIRTIME_BASED\" load balancing. Ignore probe and association requests per device when RF Interference exceeds the threshold.  # noqa: E501

        :return: The rf_interference_per_device of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._rf_interference_per_device

    @rf_interference_per_device.setter
    def rf_interference_per_device(self, rf_interference_per_device):
        """Sets the rf_interference_per_device of this XiqRpRadioUsageOptimization.

        The RF Interference threshold from 1 up to 99 for \"AIRTIME_BASED\" load balancing. Ignore probe and association requests per device when RF Interference exceeds the threshold.  # noqa: E501

        :param rf_interference_per_device: The rf_interference_per_device of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._rf_interference_per_device = rf_interference_per_device

    @property
    def average_airtime_per_client(self):
        """Gets the average_airtime_per_client of this XiqRpRadioUsageOptimization.  # noqa: E501

        The Average Airtime Per Client threshold from 1 up to 5 for \"AIRTIME_BASED\" load balancing. Ignore probe and association requests per device when Average Airtime Per Client exceeds the threshold.  # noqa: E501

        :return: The average_airtime_per_client of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._average_airtime_per_client

    @average_airtime_per_client.setter
    def average_airtime_per_client(self, average_airtime_per_client):
        """Sets the average_airtime_per_client of this XiqRpRadioUsageOptimization.

        The Average Airtime Per Client threshold from 1 up to 5 for \"AIRTIME_BASED\" load balancing. Ignore probe and association requests per device when Average Airtime Per Client exceeds the threshold.  # noqa: E501

        :param average_airtime_per_client: The average_airtime_per_client of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._average_airtime_per_client = average_airtime_per_client

    @property
    def anchor_period(self):
        """Gets the anchor_period of this XiqRpRadioUsageOptimization.  # noqa: E501

        The Anchor Period from 10 up to 600 for both \"AIRTIME_BASED\" and \"CLIENT_NUMBER\" load balancing. Ignore probe and association requests from clients associated with other Extreme Networks devices until Anchor Period Eelapses in the range of 10 to 600 seconds  # noqa: E501

        :return: The anchor_period of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._anchor_period

    @anchor_period.setter
    def anchor_period(self, anchor_period):
        """Sets the anchor_period of this XiqRpRadioUsageOptimization.

        The Anchor Period from 10 up to 600 for both \"AIRTIME_BASED\" and \"CLIENT_NUMBER\" load balancing. Ignore probe and association requests from clients associated with other Extreme Networks devices until Anchor Period Eelapses in the range of 10 to 600 seconds  # noqa: E501

        :param anchor_period: The anchor_period of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._anchor_period = anchor_period

    @property
    def neighbor_query_interval(self):
        """Gets the neighbor_query_interval of this XiqRpRadioUsageOptimization.  # noqa: E501

        In both client load balancing modes, query neighbors about client load every 1 up to 600 seconds  # noqa: E501

        :return: The neighbor_query_interval of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._neighbor_query_interval

    @neighbor_query_interval.setter
    def neighbor_query_interval(self, neighbor_query_interval):
        """Sets the neighbor_query_interval of this XiqRpRadioUsageOptimization.

        In both client load balancing modes, query neighbors about client load every 1 up to 600 seconds  # noqa: E501

        :param neighbor_query_interval: The neighbor_query_interval of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._neighbor_query_interval = neighbor_query_interval

    @property
    def enable_weak_signal_probe_request_suppression(self):
        """Gets the enable_weak_signal_probe_request_suppression of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable Weak Signal Probe Request Suppression. Weak Signal Probe Request Suppression allows the configuration of signal-to-noise threshold beyond which the device does not respond to client probes.  # noqa: E501

        :return: The enable_weak_signal_probe_request_suppression of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_weak_signal_probe_request_suppression

    @enable_weak_signal_probe_request_suppression.setter
    def enable_weak_signal_probe_request_suppression(self, enable_weak_signal_probe_request_suppression):
        """Sets the enable_weak_signal_probe_request_suppression of this XiqRpRadioUsageOptimization.

        Whether to enable Weak Signal Probe Request Suppression. Weak Signal Probe Request Suppression allows the configuration of signal-to-noise threshold beyond which the device does not respond to client probes.  # noqa: E501

        :param enable_weak_signal_probe_request_suppression: The enable_weak_signal_probe_request_suppression of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_weak_signal_probe_request_suppression = enable_weak_signal_probe_request_suppression

    @property
    def weak_snr_threshold(self):
        """Gets the weak_snr_threshold of this XiqRpRadioUsageOptimization.  # noqa: E501

        The signal to noise threshold from 1 up to 100 for Weak Signal Probe Request Suppression.  # noqa: E501

        :return: The weak_snr_threshold of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._weak_snr_threshold

    @weak_snr_threshold.setter
    def weak_snr_threshold(self, weak_snr_threshold):
        """Sets the weak_snr_threshold of this XiqRpRadioUsageOptimization.

        The signal to noise threshold from 1 up to 100 for Weak Signal Probe Request Suppression.  # noqa: E501

        :param weak_snr_threshold: The weak_snr_threshold of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._weak_snr_threshold = weak_snr_threshold

    @property
    def enable_safety_net(self):
        """Gets the enable_safety_net of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable Safety Net. When a device is overloaded or is probed by clients with a low signal-to-noise ratio,  Safety Net allows the device to respond to association requests  after a certain time period lapses.  # noqa: E501

        :return: The enable_safety_net of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_safety_net

    @enable_safety_net.setter
    def enable_safety_net(self, enable_safety_net):
        """Sets the enable_safety_net of this XiqRpRadioUsageOptimization.

        Whether to enable Safety Net. When a device is overloaded or is probed by clients with a low signal-to-noise ratio,  Safety Net allows the device to respond to association requests  after a certain time period lapses.  # noqa: E501

        :param enable_safety_net: The enable_safety_net of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_safety_net = enable_safety_net

    @property
    def safety_net_period(self):
        """Gets the safety_net_period of this XiqRpRadioUsageOptimization.  # noqa: E501

        The Safety Net Time Period from 5 up to 300 seconds.  # noqa: E501

        :return: The safety_net_period of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._safety_net_period

    @safety_net_period.setter
    def safety_net_period(self, safety_net_period):
        """Sets the safety_net_period of this XiqRpRadioUsageOptimization.

        The Safety Net Time Period from 5 up to 300 seconds.  # noqa: E501

        :param safety_net_period: The safety_net_period of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._safety_net_period = safety_net_period

    @property
    def enable_high_density(self):
        """Gets the enable_high_density of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable High Density Configuration. Enabling optimizes performance in high density environments  # noqa: E501

        :return: The enable_high_density of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_high_density

    @enable_high_density.setter
    def enable_high_density(self, enable_high_density):
        """Sets the enable_high_density of this XiqRpRadioUsageOptimization.

        Whether to enable High Density Configuration. Enabling optimizes performance in high density environments  # noqa: E501

        :param enable_high_density: The enable_high_density of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_high_density = enable_high_density

    @property
    def management_frame_basic_data_rate(self):
        """Gets the management_frame_basic_data_rate of this XiqRpRadioUsageOptimization.  # noqa: E501

        The data rates to support in high density environment -- \"HIGH\" or \"LOW\"  # noqa: E501

        :return: The management_frame_basic_data_rate of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: str
        """
        return self._management_frame_basic_data_rate

    @management_frame_basic_data_rate.setter
    def management_frame_basic_data_rate(self, management_frame_basic_data_rate):
        """Sets the management_frame_basic_data_rate of this XiqRpRadioUsageOptimization.

        The data rates to support in high density environment -- \"HIGH\" or \"LOW\"  # noqa: E501

        :param management_frame_basic_data_rate: The management_frame_basic_data_rate of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: str
        """

        self._management_frame_basic_data_rate = management_frame_basic_data_rate

    @property
    def enable_suppress_successive_probe_request(self):
        """Gets the enable_suppress_successive_probe_request of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to Reduce Response to Probe Requests. Enabling suppresses successive requests within the same beacon interval  # noqa: E501

        :return: The enable_suppress_successive_probe_request of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_suppress_successive_probe_request

    @enable_suppress_successive_probe_request.setter
    def enable_suppress_successive_probe_request(self, enable_suppress_successive_probe_request):
        """Sets the enable_suppress_successive_probe_request of this XiqRpRadioUsageOptimization.

        Whether to Reduce Response to Probe Requests. Enabling suppresses successive requests within the same beacon interval  # noqa: E501

        :param enable_suppress_successive_probe_request: The enable_suppress_successive_probe_request of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_suppress_successive_probe_request = enable_suppress_successive_probe_request

    @property
    def probe_response_reduction_option(self):
        """Gets the probe_response_reduction_option of this XiqRpRadioUsageOptimization.  # noqa: E501

        The suppress response to broadcast probes options --  \"ONLY_ONE_SSID_RESPOND_AT_A_TIME\" (allowed for only one SSID to respond at a time), \"REDUCE_CERTAIN_CLIENTS_RESPONSE\" (reducing responses to certain client devices).  # noqa: E501

        :return: The probe_response_reduction_option of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: str
        """
        return self._probe_response_reduction_option

    @probe_response_reduction_option.setter
    def probe_response_reduction_option(self, probe_response_reduction_option):
        """Sets the probe_response_reduction_option of this XiqRpRadioUsageOptimization.

        The suppress response to broadcast probes options --  \"ONLY_ONE_SSID_RESPOND_AT_A_TIME\" (allowed for only one SSID to respond at a time), \"REDUCE_CERTAIN_CLIENTS_RESPONSE\" (reducing responses to certain client devices).  # noqa: E501

        :param probe_response_reduction_option: The probe_response_reduction_option of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: str
        """

        self._probe_response_reduction_option = probe_response_reduction_option

    @property
    def suppression_limit(self):
        """Gets the suppression_limit of this XiqRpRadioUsageOptimization.  # noqa: E501

        The Number of Connection Attempts from 1 up to 10  # noqa: E501

        :return: The suppression_limit of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._suppression_limit

    @suppression_limit.setter
    def suppression_limit(self, suppression_limit):
        """Sets the suppression_limit of this XiqRpRadioUsageOptimization.

        The Number of Connection Attempts from 1 up to 10  # noqa: E501

        :param suppression_limit: The suppression_limit of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._suppression_limit = suppression_limit

    @property
    def enable_radio_balance(self):
        """Gets the enable_radio_balance of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable Radio Load Balancing. Enabling distributes wireless clients that support 5 GHz band evenly across the two radios in Dual-5G mode when an SSID is available on both radios  # noqa: E501

        :return: The enable_radio_balance of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_radio_balance

    @enable_radio_balance.setter
    def enable_radio_balance(self, enable_radio_balance):
        """Sets the enable_radio_balance of this XiqRpRadioUsageOptimization.

        Whether to enable Radio Load Balancing. Enabling distributes wireless clients that support 5 GHz band evenly across the two radios in Dual-5G mode when an SSID is available on both radios  # noqa: E501

        :param enable_radio_balance: The enable_radio_balance of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_radio_balance = enable_radio_balance

    @property
    def enable_ampdu(self):
        """Gets the enable_ampdu of this XiqRpRadioUsageOptimization.  # noqa: E501

        Enable Aggregate MAC Protocol Data Units to combine data frames into larger frames before transmission.  # noqa: E501

        :return: The enable_ampdu of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_ampdu

    @enable_ampdu.setter
    def enable_ampdu(self, enable_ampdu):
        """Sets the enable_ampdu of this XiqRpRadioUsageOptimization.

        Enable Aggregate MAC Protocol Data Units to combine data frames into larger frames before transmission.  # noqa: E501

        :param enable_ampdu: The enable_ampdu of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_ampdu = enable_ampdu

    @property
    def enable_mu_mimo(self):
        """Gets the enable_mu_mimo of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable Multiple-Input Multiple-Output (802.11ac & 802.11ax) for multiple-user access by using different spatial streams.  # noqa: E501

        :return: The enable_mu_mimo of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_mu_mimo

    @enable_mu_mimo.setter
    def enable_mu_mimo(self, enable_mu_mimo):
        """Sets the enable_mu_mimo of this XiqRpRadioUsageOptimization.

        Whether to enable Multiple-Input Multiple-Output (802.11ac & 802.11ax) for multiple-user access by using different spatial streams.  # noqa: E501

        :param enable_mu_mimo: The enable_mu_mimo of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_mu_mimo = enable_mu_mimo

    @property
    def enable_ofdma_down_link(self):
        """Gets the enable_ofdma_down_link of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable OFDMA for AP downlink communication.  # noqa: E501

        :return: The enable_ofdma_down_link of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_ofdma_down_link

    @enable_ofdma_down_link.setter
    def enable_ofdma_down_link(self, enable_ofdma_down_link):
        """Sets the enable_ofdma_down_link of this XiqRpRadioUsageOptimization.

        Whether to enable OFDMA for AP downlink communication.  # noqa: E501

        :param enable_ofdma_down_link: The enable_ofdma_down_link of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_ofdma_down_link = enable_ofdma_down_link

    @property
    def enable_ofdma_up_link(self):
        """Gets the enable_ofdma_up_link of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable OFDMA for AP uplink communication.  # noqa: E501

        :return: The enable_ofdma_up_link of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_ofdma_up_link

    @enable_ofdma_up_link.setter
    def enable_ofdma_up_link(self, enable_ofdma_up_link):
        """Sets the enable_ofdma_up_link of this XiqRpRadioUsageOptimization.

        Whether to enable OFDMA for AP uplink communication.  # noqa: E501

        :param enable_ofdma_up_link: The enable_ofdma_up_link of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_ofdma_up_link = enable_ofdma_up_link

    @property
    def bss_coloring(self):
        """Gets the bss_coloring of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable BSS Coloring (802.11ax ) to identify overlapping basic service sets (OBSSs).  # noqa: E501

        :return: The bss_coloring of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._bss_coloring

    @bss_coloring.setter
    def bss_coloring(self, bss_coloring):
        """Sets the bss_coloring of this XiqRpRadioUsageOptimization.

        Whether to enable BSS Coloring (802.11ax ) to identify overlapping basic service sets (OBSSs).  # noqa: E501

        :param bss_coloring: The bss_coloring of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._bss_coloring = bss_coloring

    @property
    def enable_target_weak_time(self):
        """Gets the enable_target_weak_time of this XiqRpRadioUsageOptimization.  # noqa: E501

        Whether to enable Target Weak Time.  # noqa: E501

        :return: The enable_target_weak_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: bool
        """
        return self._enable_target_weak_time

    @enable_target_weak_time.setter
    def enable_target_weak_time(self, enable_target_weak_time):
        """Sets the enable_target_weak_time of this XiqRpRadioUsageOptimization.

        Whether to enable Target Weak Time.  # noqa: E501

        :param enable_target_weak_time: The enable_target_weak_time of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: bool
        """

        self._enable_target_weak_time = enable_target_weak_time

    @property
    def mac_ouis(self):
        """Gets the mac_ouis of this XiqRpRadioUsageOptimization.  # noqa: E501

        The device vendor identifiers for the \"REDUCE_CERTAIN_CLIENTS_RESPONSE\" for the probe response reduction option  # noqa: E501

        :return: The mac_ouis of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: list[XiqRpMacOuiProfile]
        """
        return self._mac_ouis

    @mac_ouis.setter
    def mac_ouis(self, mac_ouis):
        """Sets the mac_ouis of this XiqRpRadioUsageOptimization.

        The device vendor identifiers for the \"REDUCE_CERTAIN_CLIENTS_RESPONSE\" for the probe response reduction option  # noqa: E501

        :param mac_ouis: The mac_ouis of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: list[XiqRpMacOuiProfile]
        """

        self._mac_ouis = mac_ouis

    @property
    def ratio_for_5g_clients(self):
        """Gets the ratio_for_5g_clients of this XiqRpRadioUsageOptimization.  # noqa: E501

        The percentage distribution from 1 up to 100 for 2.4 and 5.0 GHz clients for \"BALANCE\" steering mode.  # noqa: E501

        :return: The ratio_for_5g_clients of this XiqRpRadioUsageOptimization.  # noqa: E501
        :rtype: int
        """
        return self._ratio_for_5g_clients

    @ratio_for_5g_clients.setter
    def ratio_for_5g_clients(self, ratio_for_5g_clients):
        """Sets the ratio_for_5g_clients of this XiqRpRadioUsageOptimization.

        The percentage distribution from 1 up to 100 for 2.4 and 5.0 GHz clients for \"BALANCE\" steering mode.  # noqa: E501

        :param ratio_for_5g_clients: The ratio_for_5g_clients of this XiqRpRadioUsageOptimization.  # noqa: E501
        :type: int
        """

        self._ratio_for_5g_clients = ratio_for_5g_clients

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, XiqRpRadioUsageOptimization):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, XiqRpRadioUsageOptimization):
            return True

        return self.to_dict() != other.to_dict()
