<!--gterm notebook command=r-->
## Graphterm Notebook using R: Example 2



```{r}
# Load GraphTerm API helper functions
source(paste(Sys.getenv("GTERM_DIR"),"/bin/gterm.R", sep=""))

```

```output

```

```{r}
g <- gcairo()         # Setup device for GraphTerm
require("ggplot2")
p <- ggplot(mtcars, aes(factor(cyl), mpg))
p + geom_boxplot()
g$frame()             # Display plot as inline image
```

```output

format = ARGB (400 x 300)

```

![image][output-fig1-R-example2.R.md]

[output-fig1-R-example2.R.md]: data:image/png;base64,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
