# Afterburner Package

## What is Afterburner?

Afterburner is a Python package that provides functionality for analysing and
processing climate model data, in particular, though not exclusively, data
produced by the UK Met Office's [Unified Model](https://www.metoffice.gov.uk/research/approach/modelling-systems/unified-model/index).

At present the Afterburner codebase is compatible with both Python 2.7 and
Python 3.6 or later. However, since official support for Python 2.7 has now
ceased the use of Python 3 is firmly recommended.

## License

Afterburner software is made available under a 3-Clause BSD license, as detailed
in the LICENSE.TXT file which can be found in the root directory of the Afterburner
distribution.

## Dependencies

The `afterburner` package depends upon the following packages, each of which have
their own dependencies.

* [scitools-iris](https://pypi.org/project/scitools-iris/) (version 2.1 or later; version 2.4 recommended)
* [pyparsing](https://pypi.org/project/pyparsing/)
* [windspharm](https://pypi.org/project/windspharm/)
* [sphinx](https://pypi.org/project/Sphinx/) (only required if you intend to build
and install the documentation set)
* [nose](https://pypi.org/project/nose/) (only required if you intend to run the unit tests)

## Installation

The `afterburner` package can be installed from [PyPI](https://test.pypi.org/project/metoffice-afterburner/)
or [conda-forge](https://conda-forge.org/). Installing from conda-forge is the
recommended method.

### Installing from PyPI

Although the `afterburner` package can be installed from PyPI, installing certain
prerequisite packages (notably `cartopy`) can be challenging. Consequently, it is
recommended that you first install Iris into a suitable conda environment, and
then use `pip` to install `afterburner` into that environment, but skipping
installation of dependent packages (using the `--no-deps` option).

```
% conda activate <your-env>
% conda info -c conda-forge iris==2.4.0   # just to preview package dependencies
% conda install -c conda-forge iris==2.4.0
% conda install -c conda-forge windspharm
% pip install --no-deps metoffice-afterburner
```

Note: installing Iris should take care of installing the `pyparsing` package.

### Installing from conda-forge

```
% conda activate <your-env>
% conda install -c conda-forge iris==2.4.0
% conda install -c conda-forge windspharm
% conda install -c conda-forge metoffice-afterburner
```

### Installing from a tarball

You may also install directly from the source distribution. After downloading the
package tarball from PyPI, unpack it, change to the source directory, then enter
the following command (with associated options if required: use `--help` to see
which ones are supported):

```
% python setup.py install
```

### Integration with Rose and Cylc

If you are intending to utilise the `afterburner` Python package in combination
with [Rose](https://github.com/metomi/rose) and [Cylc](https://github.com/cylc)
-- for example, to incorporate an Afterburner app into a Rose suite -- then you
should also install those packages onto your system.

In addition to their respective GitHub project home pages (linked above), both
packages can be found on PyPI ([Rose](https://pypi.org/project/metomi-rose/) |
[Cylc](https://pypi.org/project/cylc-flow/)).

Note, however, that the `afterburner` Python package should build and install
successfully without the Rose and Cylc packages being installed.

## Documentation

The sphinx-based documentation for Afterburner may be generated by running the
`build_docs` subcommand:

```
% python setup.py build_docs
```

That command will build HTML documentation within the directory `doc/src/_build/html`.
If desired, the documentation may then be installed into a target directory
using the `install_docs` subcommand:

```
% python setup.py install_docs --dst-dir=<destination-dir> [--host=<hostname>]
```

Alternatively, if preferred you can manually modify and run the shell script at
`doc/src/build_docs.sh`.

## Testing

If desired, the Afterburner unit tests may be run using the following command:

```
% python setup.py test
```

Depending on which packages are installed in your Python runtime environment,
some unit tests may be skipped.
