import datetime
from ..adapters.informix import Informix
from .base import SQLRepresenter
from . import representers


@representers.register_for(Informix)
class InformixRepresenter(SQLRepresenter):
    def exceptions(self, obj, field_type):
        if field_type == "date":
            if isinstance(obj, (datetime.date, datetime.datetime)):
                obj = obj.isoformat()[:10]
            else:
                obj = str(obj)
            return "to_date('%s','%%Y-%%m-%%d')" % obj
        elif field_type == "datetime":
            if isinstance(obj, datetime.datetime):
                obj = obj.isoformat()[:19].replace("T", " ")
            elif isinstance(obj, datetime.date):
                obj = obj.isoformat()[:10] + " 00:00:00"
            else:
                obj = str(obj)
            return "to_date('%s','%%Y-%%m-%%d %%H:%%M:%%S')" % obj
        return None
