/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class UnitsConversionUtil {
    private static final String[] UNITS = new String[]{"p", "n", "u", "m", "", "k", "M", "G", "T", "P", "Ki", "Mi", "Gi", "Ti", "Pi"};
    private static final List<String> SORTED_UNITS = Arrays.asList(UNITS);
    public static final Set<String> KNOWN_UNITS = UnitsConversionUtil.createKnownUnitsSet();
    private static final Converter PICO = new Converter(1L, 1000000000000L);
    private static final Converter NANO = new Converter(1L, 1000000000L);
    private static final Converter MICRO = new Converter(1L, 1000000L);
    private static final Converter MILLI = new Converter(1L, 1000L);
    private static final Converter BASE = new Converter(1L, 1L);
    private static final Converter KILO = new Converter(1000L, 1L);
    private static final Converter MEGA = new Converter(1000000L, 1L);
    private static final Converter GIGA = new Converter(1000000000L, 1L);
    private static final Converter TERA = new Converter(1000000000000L, 1L);
    private static final Converter PETA = new Converter(1000000000000000L, 1L);
    private static final Converter KILO_BINARY = new Converter(1024L, 1L);
    private static final Converter MEGA_BINARY = new Converter(0x100000L, 1L);
    private static final Converter GIGA_BINARY = new Converter(0x40000000L, 1L);
    private static final Converter TERA_BINARY = new Converter(0x10000000000L, 1L);
    private static final Converter PETA_BINARY = new Converter(0x4000000000000L, 1L);

    private static Set<String> createKnownUnitsSet() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(Arrays.asList(UNITS));
        return ret;
    }

    private static Converter getConverter(String unit) {
        switch (unit) {
            case "p": {
                return PICO;
            }
            case "n": {
                return NANO;
            }
            case "u": {
                return MICRO;
            }
            case "m": {
                return MILLI;
            }
            case "": {
                return BASE;
            }
            case "k": {
                return KILO;
            }
            case "M": {
                return MEGA;
            }
            case "G": {
                return GIGA;
            }
            case "T": {
                return TERA;
            }
            case "P": {
                return PETA;
            }
            case "Ki": {
                return KILO_BINARY;
            }
            case "Mi": {
                return MEGA_BINARY;
            }
            case "Gi": {
                return GIGA_BINARY;
            }
            case "Ti": {
                return TERA_BINARY;
            }
            case "Pi": {
                return PETA_BINARY;
            }
        }
        throw new IllegalArgumentException("Unknown unit '" + unit + "'. Known units are " + KNOWN_UNITS);
    }

    public static long convert(String fromUnit, String toUnit, long fromValue) {
        if (toUnit == null || fromUnit == null) {
            throw new IllegalArgumentException("One or more arguments are null");
        }
        if (fromUnit.equals(toUnit)) {
            return fromValue;
        }
        Converter fc = UnitsConversionUtil.getConverter(fromUnit);
        Converter tc = UnitsConversionUtil.getConverter(toUnit);
        long numerator = fc.numerator * tc.denominator;
        long denominator = fc.denominator * tc.numerator;
        long numeratorMultiplierLimit = Long.MAX_VALUE / numerator;
        if (numerator < denominator) {
            if (numeratorMultiplierLimit < fromValue) {
                String overflowMsg = "Converting " + fromValue + " from '" + fromUnit + "' to '" + toUnit + "' will result in an overflow of Long";
                throw new IllegalArgumentException(overflowMsg);
            }
            return fromValue * numerator / denominator;
        }
        if (numeratorMultiplierLimit > fromValue) {
            return numerator * fromValue / denominator;
        }
        long tmp = numerator / denominator;
        if (Long.MAX_VALUE / tmp < fromValue) {
            String overflowMsg = "Converting " + fromValue + " from '" + fromUnit + "' to '" + toUnit + "' will result in an overflow of Long";
            throw new IllegalArgumentException(overflowMsg);
        }
        return fromValue * tmp;
    }

    public static int compare(String unitA, long valueA, String unitB, long valueB) {
        UnitsConversionUtil.checkUnitArgument(unitA);
        UnitsConversionUtil.checkUnitArgument(unitB);
        if (unitA.equals(unitB)) {
            return Long.compare(valueA, valueB);
        }
        Converter unitAC = UnitsConversionUtil.getConverter(unitA);
        Converter unitBC = UnitsConversionUtil.getConverter(unitB);
        int unitAPos = SORTED_UNITS.indexOf(unitA);
        int unitBPos = SORTED_UNITS.indexOf(unitB);
        try {
            long tmpA = valueA;
            long tmpB = valueB;
            if (unitAPos < unitBPos) {
                tmpB = UnitsConversionUtil.convert(unitB, unitA, valueB);
            } else {
                tmpA = UnitsConversionUtil.convert(unitA, unitB, valueA);
            }
            return Long.compare(tmpA, tmpB);
        }
        catch (IllegalArgumentException ie) {
            BigInteger tmpA = BigInteger.valueOf(valueA);
            BigInteger tmpB = BigInteger.valueOf(valueB);
            if (unitAPos < unitBPos) {
                tmpB = tmpB.multiply(BigInteger.valueOf(unitBC.numerator));
                tmpB = tmpB.multiply(BigInteger.valueOf(unitAC.denominator));
                tmpB = tmpB.divide(BigInteger.valueOf(unitBC.denominator));
                tmpB = tmpB.divide(BigInteger.valueOf(unitAC.numerator));
            } else {
                tmpA = tmpA.multiply(BigInteger.valueOf(unitAC.numerator));
                tmpA = tmpA.multiply(BigInteger.valueOf(unitBC.denominator));
                tmpA = tmpA.divide(BigInteger.valueOf(unitAC.denominator));
                tmpA = tmpA.divide(BigInteger.valueOf(unitBC.numerator));
            }
            return tmpA.compareTo(tmpB);
        }
    }

    private static void checkUnitArgument(String unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit cannot be null");
        }
        if (!KNOWN_UNITS.contains(unit)) {
            throw new IllegalArgumentException("Unknown unit '" + unit + "'");
        }
    }

    public static int compareUnits(String unitA, String unitB) {
        UnitsConversionUtil.checkUnitArgument(unitA);
        UnitsConversionUtil.checkUnitArgument(unitB);
        int unitAPos = SORTED_UNITS.indexOf(unitA);
        int unitBPos = SORTED_UNITS.indexOf(unitB);
        return Integer.compare(unitAPos, unitBPos);
    }

    public static class Converter {
        private long numerator;
        private long denominator;

        Converter(long n, long d) {
            this.numerator = n;
            this.denominator = d;
        }
    }
}

