/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.scope;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.ui.scope.RDDOperationCluster;
import org.apache.spark.ui.scope.RDDOperationEdge;
import org.apache.spark.ui.scope.RDDOperationGraph;
import org.apache.spark.ui.scope.RDDOperationNode;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.xml.Utility$;

public final class RDDOperationGraph$
implements Logging,
scala.Serializable {
    public static RDDOperationGraph$ MODULE$;
    private final String STAGE_CLUSTER_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RDDOperationGraph$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String STAGE_CLUSTER_PREFIX() {
        return this.STAGE_CLUSTER_PREFIX;
    }

    public RDDOperationGraph makeOperationGraph(StageInfo stage, int retainedNodes) {
        ListBuffer edges = new ListBuffer();
        HashMap nodes = new HashMap();
        HashMap clusters = new HashMap();
        String stageClusterId = new StringBuilder(0).append(this.STAGE_CLUSTER_PREFIX()).append(stage.stageId()).toString();
        String stageClusterName = new StringBuilder(6).append("Stage ").append(stage.stageId()).append((Object)(stage.attemptNumber() == 0 ? "" : new StringBuilder(11).append(" (attempt ").append(stage.attemptNumber()).append(")").toString())).toString();
        RDDOperationCluster rootCluster = new RDDOperationCluster(stageClusterId, false, stageClusterName);
        IntRef rootNodeCount = IntRef.create((int)0);
        HashSet addRDDIds = new HashSet();
        HashSet dropRDDIds = new HashSet();
        ((IterableLike)stage.rddInfos().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)rdd -> {
            RDDOperationGraph$.$anonfun$makeOperationGraph$2(rootNodeCount, retainedNodes, addRDDIds, dropRDDIds, edges, nodes, rootCluster, clusters, rdd);
            return BoxedUnit.UNIT;
        });
        ListBuffer internalEdges = new ListBuffer();
        ListBuffer outgoingEdges = new ListBuffer();
        ListBuffer incomingEdges = new ListBuffer();
        edges.foreach(arg_0 -> RDDOperationGraph$.$anonfun$makeOperationGraph$14(nodes, internalEdges, outgoingEdges, incomingEdges, stage, arg_0));
        return new RDDOperationGraph((Seq<RDDOperationEdge>)internalEdges, (Seq<RDDOperationEdge>)outgoingEdges, (Seq<RDDOperationEdge>)incomingEdges, rootCluster);
    }

    /*
     * WARNING - void declaration
     */
    public String makeDotFile(RDDOperationGraph graph) {
        void var3_3;
        scala.collection.mutable.StringBuilder dotFile = new scala.collection.mutable.StringBuilder();
        dotFile.append("digraph G {\n");
        this.makeDotSubgraph(dotFile, graph.rootCluster(), "  ");
        graph.edges().foreach((Function1 & Serializable & scala.Serializable)edge -> dotFile.append(new StringBuilder(6).append("  ").append(edge.fromId()).append("->").append(edge.toId()).append(";\n").toString()));
        dotFile.append("}");
        String result = dotFile.toString();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> result);
        return var3_3;
    }

    private String makeDotNode(RDDOperationNode node) {
        String isCached = node.cached() ? " [Cached]" : "";
        String isBarrier = node.barrier() ? " [Barrier]" : "";
        String escapedCallsite = Utility$.MODULE$.escape(node.callsite());
        String label = new StringBuilder(7).append(node.name()).append(" [").append(node.id()).append("]").append(isCached).append(isBarrier).append("<br>").append(escapedCallsite).toString();
        return new StringBuilder(28).append(node.id()).append(" [labelType=\"html\" label=\"").append(StringEscapeUtils.escapeJava((String)label)).append("\"]").toString();
    }

    private void makeDotSubgraph(scala.collection.mutable.StringBuilder subgraph, RDDOperationCluster cluster, String indent) {
        subgraph.append(indent).append(new StringBuilder(19).append("subgraph cluster").append(cluster.id()).append(" {\n").toString()).append(indent).append(new StringBuilder(12).append("  label=\"").append(StringEscapeUtils.escapeJava((String)cluster.name())).append("\";\n").toString());
        cluster.childNodes().foreach((Function1 & Serializable & scala.Serializable)node -> subgraph.append(indent).append(new StringBuilder(4).append("  ").append(MODULE$.makeDotNode((RDDOperationNode)node)).append(";\n").toString()));
        cluster.childClusters().foreach((Function1 & Serializable & scala.Serializable)cscope -> {
            RDDOperationGraph$.MODULE$.makeDotSubgraph(subgraph, cscope, new StringBuilder(2).append(indent).append("  ").toString());
            return BoxedUnit.UNIT;
        });
        subgraph.append(indent).append("}\n");
    }

    public RDDOperationGraph apply(Seq<RDDOperationEdge> edges, Seq<RDDOperationEdge> outgoingEdges, Seq<RDDOperationEdge> incomingEdges, RDDOperationCluster rootCluster) {
        return new RDDOperationGraph(edges, outgoingEdges, incomingEdges, rootCluster);
    }

    public Option<Tuple4<Seq<RDDOperationEdge>, Seq<RDDOperationEdge>, Seq<RDDOperationEdge>, RDDOperationCluster>> unapply(RDDOperationGraph x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4(x$0.edges(), x$0.outgoingEdges(), x$0.incomingEdges(), (Object)x$0.rootCluster()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ RDDOperationEdge $anonfun$makeOperationGraph$5(RDDInfo rdd$1, int x$6) {
        return new RDDOperationEdge(x$6, rdd$1.id());
    }

    public static final /* synthetic */ void $anonfun$makeOperationGraph$11(Seq pc) {
        block0: {
            if (pc.size() != 2) break block0;
            RDDOperationCluster parentCluster = (RDDOperationCluster)pc.apply(0);
            RDDOperationCluster childCluster = (RDDOperationCluster)pc.apply(1);
            parentCluster.attachChildCluster(childCluster);
        }
    }

    public static final /* synthetic */ void $anonfun$makeOperationGraph$12(RDDOperationCluster rootCluster$1, RDDOperationCluster cluster) {
        block0: {
            if (rootCluster$1.childClusters().contains((Object)cluster)) break block0;
            rootCluster$1.attachChildCluster(cluster);
        }
    }

    public static final /* synthetic */ void $anonfun$makeOperationGraph$2(IntRef rootNodeCount$1, int retainedNodes$1, HashSet addRDDIds$1, HashSet dropRDDIds$1, ListBuffer edges$1, HashMap nodes$1, RDDOperationCluster rootCluster$1, HashMap clusters$1, RDDInfo rdd) {
        block5: {
            RDDOperationNode node;
            boolean isAllowed;
            block4: {
                HashSet hashSet;
                boolean bl;
                Seq<Object> parentIds = rdd.parentIds();
                if (parentIds.isEmpty()) {
                    ++rootNodeCount$1.elem;
                    bl = rootNodeCount$1.elem <= retainedNodes$1;
                } else {
                    bl = isAllowed = parentIds.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)id -> addRDDIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)) || !dropRDDIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)));
                }
                if (isAllowed) {
                    addRDDIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rdd.id()));
                    hashSet = edges$1.$plus$plus$eq((TraversableOnce)((TraversableLike)parentIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)id -> !dropRDDIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)))).map((Function1 & Serializable & scala.Serializable)x$6 -> RDDOperationGraph$.$anonfun$makeOperationGraph$5(rdd, BoxesRunTime.unboxToInt((Object)x$6)), Seq$.MODULE$.canBuildFrom()));
                } else {
                    hashSet = dropRDDIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rdd.id()));
                }
                node = (RDDOperationNode)nodes$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rdd.id()), (Function0 & Serializable & scala.Serializable)() -> {
                    StorageLevel storageLevel = rdd.storageLevel();
                    StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                    return new RDDOperationNode(rdd.id(), rdd.name(), storageLevel == null ? storageLevel2 != null : !((Object)storageLevel).equals(storageLevel2), rdd.isBarrier(), rdd.callSite());
                });
                if (!rdd.scope().isEmpty()) break block4;
                if (!isAllowed) break block5;
                rootCluster$1.attachChildNode(node);
                break block5;
            }
            Seq rddScopes = (Seq)rdd.scope().map((Function1 & Serializable & scala.Serializable)scope -> scope.getAllScopes()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
            Seq rddClusters = (Seq)rddScopes.map((Function1 & Serializable & scala.Serializable)scope -> {
                String clusterId = scope.id();
                String clusterName = scope.name().replaceAll("\\n", "\\\\n");
                return (RDDOperationCluster)clusters$1.getOrElseUpdate((Object)clusterId, (Function0 & Serializable & scala.Serializable)() -> new RDDOperationCluster(clusterId, false, clusterName));
            }, Seq$.MODULE$.canBuildFrom());
            rddClusters.sliding(2).foreach((Function1 & Serializable & scala.Serializable)pc -> {
                RDDOperationGraph$.$anonfun$makeOperationGraph$11(pc);
                return BoxedUnit.UNIT;
            });
            rddClusters.headOption().foreach((Function1 & Serializable & scala.Serializable)cluster -> {
                RDDOperationGraph$.$anonfun$makeOperationGraph$12(rootCluster$1, cluster);
                return BoxedUnit.UNIT;
            });
            if (!isAllowed) break block5;
            rddClusters.lastOption().foreach((Function1 & Serializable & scala.Serializable)cluster -> {
                cluster.attachChildNode(node);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ String $anonfun$makeOperationGraph$15(StageInfo stage$1, RDDOperationEdge x2$1) {
        return new StringBuilder(32).append("Found an orphan edge in stage ").append(stage$1.stageId()).append(": ").append(x2$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$makeOperationGraph$14(HashMap nodes$1, ListBuffer internalEdges$1, ListBuffer outgoingEdges$1, ListBuffer incomingEdges$1, StageInfo stage$1, RDDOperationEdge x0$1) {
        block4: {
            block2: {
                block5: {
                    block3: {
                        var8_6 = x0$1;
                        if (var8_6 == null) break block2;
                        var9_7 = var8_6;
                        fromThisGraph = nodes$1.contains((Object)BoxesRunTime.boxToInteger((int)var9_7.fromId()));
                        var12_10 = new Tuple2.mcZZ.sp(fromThisGraph, toThisGraph = nodes$1.contains((Object)BoxesRunTime.boxToInteger((int)var9_7.toId())));
                        if (var12_10 == null) break block3;
                        var13_11 = var12_10._1$mcZ$sp();
                        var14_12 = var12_10._2$mcZ$sp();
                        if (!var13_11 || !var14_12) break block3;
                        var7_13 = internalEdges$1.$plus$eq((Object)var9_7);
                        break block4;
                    }
                    if (var12_10 == null) break block5;
                    var15_14 = var12_10._1$mcZ$sp();
                    var16_15 = var12_10._2$mcZ$sp();
                    if (!var15_14 || var16_15) break block5;
                    var7_13 = outgoingEdges$1.$plus$eq((Object)var9_7);
                    break block4;
                }
                if (var12_10 == null) ** GOTO lbl-1000
                var17_16 = var12_10._1$mcZ$sp();
                var18_17 = var12_10._2$mcZ$sp();
                if (!var17_16 && var18_17) {
                    var7_13 = incomingEdges$1.$plus$eq((Object)var9_7);
                } else lbl-1000:
                // 2 sources

                {
                    RDDOperationGraph$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeOperationGraph$15(org.apache.spark.scheduler.StageInfo org.apache.spark.ui.scope.RDDOperationEdge ), ()Ljava/lang/String;)((StageInfo)stage$1, (RDDOperationEdge)var9_7));
                    var7_13 = BoxedUnit.UNIT;
                }
                break block4;
            }
            throw new MatchError((Object)var8_6);
        }
        var6_18 = var7_13;
        return var6_18;
    }

    private RDDOperationGraph$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.STAGE_CLUSTER_PREFIX = "stage_";
    }
}

