/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.ApplicationDescription;
import org.apache.spark.deploy.ApplicationDescription$;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.client.StandaloneAppClient;
import org.apache.spark.deploy.client.StandaloneAppClientListener;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.launcher.LauncherBackend;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.resource.ResourceRequirement;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tma!B\u0015+\u00019\"\u0004\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u0006G\u0002!\t\u0001\u001a\u0005\by\u0001\u0001\r\u0011\"\u0003j\u0011\u001di\u0007\u00011A\u0005\n9Da\u0001\u001e\u0001!B\u0013Q\u0007bB;\u0001\u0005\u0004%IA\u001e\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003x\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\u0007\u0011-\tY\u0002\u0001a\u0001\u0002\u0004%\t!!\b\t\u0017\u0005\u0015\u0002\u00011AA\u0002\u0013\u0005\u0011q\u0005\u0005\f\u0003W\u0001\u0001\u0019!A!B\u0013\ty\u0002C\u0006\u00026\u0001\u0001\r\u00111A\u0005\n\u0005]\u0002bCA\u001d\u0001\u0001\u0007\t\u0019!C\u0005\u0003wA!\"a\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003Y\u0011%\t\u0019\u0005\u0001b\u0001\n\u0013\t)\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA$\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA+\u0011%\t\u0019\u0007\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA.\u0011\u001d\tI\u0007\u0001C!\u0003WBq!!\u001c\u0001\t\u0003\nY\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005U\u0004\u0001\"\u0011\u0002l!9\u0011q\u000f\u0001\u0005B\u0005e\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\ty\u000b\u0001C!\u0003cCq!a/\u0001\t\u0003\ni\fC\u0004\u0002@\u0002!\t%!1\t\u000f\u0005\r\u0007\u0001\"\u0015\u0002F\"9\u0011Q\u001b\u0001\u0005R\u0005]\u0007bBAx\u0001\u0011\u0005\u0013\u0011\u001f\u0005\b\u0003w\u0004A\u0011BA6\u0011\u001d\ti\u0010\u0001C\u0005\u0003WBq!!\u001c\u0001\t\u0013\ty\u0010\u0003\b\u0003\u0014\u0001\u0001\n1!A\u0001\n\u0013\t\tM!\u0006\u00035M#\u0018M\u001c3bY>tWmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u000b\u0005-b\u0013aB2mkN$XM\u001d\u0006\u0003[9\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001cB\u0001A\u001b:\u0003B\u0011agN\u0007\u0002U%\u0011\u0001H\u000b\u0002\u001e\u0007>\f'o]3He\u0006Lg.\u001a3TG\",G-\u001e7fe\n\u000b7m[3oIB\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0007G2LWM\u001c;\u000b\u0005yr\u0013A\u00023fa2|\u00170\u0003\u0002Aw\tY2\u000b^1oI\u0006dwN\\3BaB\u001cE.[3oi2K7\u000f^3oKJ\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0018\u0002\u0011%tG/\u001a:oC2L!AR\"\u0003\u000f1{wmZ5oO\u000e\u0001\u0001CA%K\u001b\u0005a\u0013BA&-\u0005E!\u0016m]6TG\",G-\u001e7fe&k\u0007\u000f\\\u0001\u0003g\u000e\u0004\"AT(\u000e\u00039J!\u0001\u0015\u0018\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002\u000f5\f7\u000f^3sgB\u00191K\u0016-\u000e\u0003QS\u0011!V\u0001\u0006g\u000e\fG.Y\u0005\u0003/R\u0013Q!\u0011:sCf\u0004\"!\u00171\u000f\u0005is\u0006CA.U\u001b\u0005a&BA/H\u0003\u0019a$o\\8u}%\u0011q\fV\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`)\u00061A(\u001b8jiz\"B!\u001a4hQB\u0011a\u0007\u0001\u0005\u0006[\u0011\u0001\r\u0001\u0013\u0005\u0006\u0019\u0012\u0001\r!\u0014\u0005\u0006#\u0012\u0001\rAU\u000b\u0002UB\u0011!h[\u0005\u0003Yn\u00121c\u0015;b]\u0012\fGn\u001c8f\u0003B\u00048\t\\5f]R\f!b\u00197jK:$x\fJ3r)\ty'\u000f\u0005\u0002Ta&\u0011\u0011\u000f\u0016\u0002\u0005+:LG\u000fC\u0004t\r\u0005\u0005\t\u0019\u00016\u0002\u0007a$\u0013'A\u0004dY&,g\u000e\u001e\u0011\u0002\u0011M$x\u000e\u001d9j]\u001e,\u0012a\u001e\t\u0004q\u0006\rQ\"A=\u000b\u0005i\\\u0018AB1u_6L7M\u0003\u0002}{\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005y|\u0018\u0001B;uS2T!!!\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000bI(!D!u_6L7MQ8pY\u0016\fg.A\u0005ti>\u0004\b/\u001b8hA\u0005yA.Y;oG\",'OQ1dW\u0016tG-\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u00149\n\u0001\u0002\\1v]\u000eDWM]\u0005\u0005\u0003/\t\tBA\bMCVt7\r[3s\u0005\u0006\u001c7.\u001a8e\u0003Aa\u0017-\u001e8dQ\u0016\u0014()Y2lK:$\u0007%\u0001\ttQV$Hm\\<o\u0007\u0006dGNY1dWV\u0011\u0011q\u0004\t\u0006'\u0006\u0005Rm\\\u0005\u0004\u0003G!&!\u0003$v]\u000e$\u0018n\u001c82\u0003Q\u0019\b.\u001e;e_^t7)\u00197mE\u0006\u001c7n\u0018\u0013fcR\u0019q.!\u000b\t\u0011Ml\u0011\u0011!a\u0001\u0003?\t\u0011c\u001d5vi\u0012|wO\\\"bY2\u0014\u0017mY6!Q\rq\u0011q\u0006\t\u0004'\u0006E\u0012bAA\u001a)\nAao\u001c7bi&dW-A\u0003baBLE-F\u0001Y\u0003%\t\u0007\u000f]%e?\u0012*\u0017\u000fF\u0002p\u0003{Aqa\u001d\t\u0002\u0002\u0003\u0007\u0001,\u0001\u0004baBLE\r\t\u0015\u0004#\u0005=\u0012a\u0005:fO&\u001cHO]1uS>t')\u0019:sS\u0016\u0014XCAA$!\u0011\tI%a\u0013\u000e\u0003mL1!!\u0014|\u0005%\u0019V-\\1qQ>\u0014X-\u0001\u000bsK\u001eL7\u000f\u001e:bi&|gNQ1se&,'\u000fI\u0001\t[\u0006D8i\u001c:fgV\u0011\u0011Q\u000b\t\u0006'\u0006]\u00131L\u0005\u0004\u00033\"&AB(qi&|g\u000eE\u0002T\u0003;J1!a\u0018U\u0005\rIe\u000e^\u0001\n[\u0006D8i\u001c:fg\u0002\n!\u0003^8uC2,\u0005\u0010]3di\u0016$7i\u001c:fgV\u0011\u00111L\u0001\u0014i>$\u0018\r\\#ya\u0016\u001cG/\u001a3D_J,7\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0002_\u0006!1\u000f^8q\u0003%\u0019wN\u001c8fGR,G\rF\u0002p\u0003gBa!!\u000e\u001b\u0001\u0004A\u0016\u0001\u00043jg\u000e|gN\\3di\u0016$\u0017\u0001\u00023fC\u0012$2a\\A>\u0011\u0019\ti\b\ba\u00011\u00061!/Z1t_:\fQ\"\u001a=fGV$xN]!eI\u0016$GcC8\u0002\u0004\u0006\u001d\u00151RAH\u0003'Ca!!\"\u001e\u0001\u0004A\u0016A\u00024vY2LE\r\u0003\u0004\u0002\nv\u0001\r\u0001W\u0001\to>\u00148.\u001a:JI\"1\u0011QR\u000fA\u0002a\u000b\u0001\u0002[8tiB{'\u000f\u001e\u0005\b\u0003#k\u0002\u0019AA.\u0003\u0015\u0019wN]3t\u0011\u001d\t)*\ba\u0001\u00037\na!\\3n_JL\u0018aD3yK\u000e,Ho\u001c:SK6|g/\u001a3\u0015\u0013=\fY*!(\u0002\"\u0006\u0015\u0006BBAC=\u0001\u0007\u0001\f\u0003\u0004\u0002 z\u0001\r\u0001W\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\t\u0019K\ba\u0001\u0003+\n!\"\u001a=jiN#\u0018\r^;t\u0011\u001d\t9K\ba\u0001\u0003S\u000b!b^8sW\u0016\u0014Hj\\:u!\r\u0019\u00161V\u0005\u0004\u0003[#&a\u0002\"p_2,\u0017M\\\u0001\u000eo>\u00148.\u001a:SK6|g/\u001a3\u0015\u000f=\f\u0019,!.\u0002:\"1\u0011\u0011R\u0010A\u0002aCa!a. \u0001\u0004A\u0016\u0001\u00025pgRDa!a( \u0001\u0004A\u0016!H:vM\u001aL7-[3oiJ+7o\\;sG\u0016\u001c(+Z4jgR,'/\u001a3\u0015\u0005\u0005%\u0016!D1qa2L7-\u0019;j_:LE\rF\u0001Y\u0003]!wNU3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0002H\u0006E\u0007CBAe\u0003\u001b\fI+\u0004\u0002\u0002L*\u0011A\u0010V\u0005\u0005\u0003\u001f\fYM\u0001\u0004GkR,(/\u001a\u0005\b\u0003'\u0014\u0003\u0019AA.\u00039\u0011X-];fgR,G\rV8uC2\fq\u0002Z8LS2dW\t_3dkR|'o\u001d\u000b\u0005\u0003\u000f\fI\u000eC\u0004\u0002\\\u000e\u0002\r!!8\u0002\u0017\u0015DXmY;u_JLEm\u001d\t\u0006\u0003?\fI\u000f\u0017\b\u0005\u0003C\f)OD\u0002\\\u0003GL\u0011!V\u0005\u0004\u0003O$\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003W\fiOA\u0002TKFT1!a:U\u0003A9W\r\u001e#sSZ,'\u000fT8h+Jd7/\u0006\u0002\u0002tB)1+a\u0016\u0002vB)\u0011,a>Y1&\u0019\u0011\u0011 2\u0003\u00075\u000b\u0007/A\nxC&$hi\u001c:SK\u001eL7\u000f\u001e:bi&|g.A\u0007o_RLg-_\"p]R,\u0007\u0010\u001e\u000b\u0004_\n\u0005\u0001b\u0002B\u0002O\u0001\u0007!QA\u0001\u000bM&t\u0017\r\\*uCR,\u0007\u0003\u0002B\u0004\u0005\u001bqA!a\u0004\u0003\n%!!1BA\t\u00039\u0019\u0006/\u0019:l\u0003B\u0004\b*\u00198eY\u0016LAAa\u0004\u0003\u0012\t)1\u000b^1uK*!!1BA\t\u0003M\u0019X\u000f]3sI\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0013\u0011\tyLa\u0006\n\u0007\teAF\u0001\tTG\",G-\u001e7fe\n\u000b7m[3oI\u0002")
public class StandaloneSchedulerBackend
extends CoarseGrainedSchedulerBackend
implements StandaloneAppClientListener {
    private final TaskSchedulerImpl scheduler;
    public final SparkContext org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc;
    private final String[] masters;
    private StandaloneAppClient client;
    private final AtomicBoolean stopping;
    private final LauncherBackend launcherBackend;
    private volatile Function1<StandaloneSchedulerBackend, BoxedUnit> shutdownCallback;
    private volatile String appId;
    private final Semaphore registrationBarrier;
    private final Option<Object> maxCores;
    private final int totalExpectedCores;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$(this);
    }

    private StandaloneAppClient client() {
        return this.client;
    }

    private void client_$eq(StandaloneAppClient x$1) {
        this.client = x$1;
    }

    private AtomicBoolean stopping() {
        return this.stopping;
    }

    private LauncherBackend launcherBackend() {
        return this.launcherBackend;
    }

    public Function1<StandaloneSchedulerBackend, BoxedUnit> shutdownCallback() {
        return this.shutdownCallback;
    }

    public void shutdownCallback_$eq(Function1<StandaloneSchedulerBackend, BoxedUnit> x$1) {
        this.shutdownCallback = x$1;
    }

    private String appId() {
        return this.appId;
    }

    private void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    private Semaphore registrationBarrier() {
        return this.registrationBarrier;
    }

    private Option<Object> maxCores() {
        return this.maxCores;
    }

    private int totalExpectedCores() {
        return this.totalExpectedCores;
    }

    @Override
    public void start() {
        super.start();
        String string = this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.deployMode();
        String string2 = "client";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.launcherBackend().connect();
        }
        String driverUrl = RpcEndpointAddress$.MODULE$.apply(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().get(package$.MODULE$.DRIVER_HOST_ADDRESS()), BoxesRunTime.unboxToInt((Object)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().get(package$.MODULE$.DRIVER_PORT())), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--driver-url", driverUrl, "--executor-id", "{{EXECUTOR_ID}}", "--hostname", "{{HOSTNAME}}", "--cores", "{{CORES}}", "--app-id", "{{APP_ID}}", "--worker-url", "{{WORKER_URL}}"}));
        Seq extraJavaOpts = (Seq)((Option)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().get(package$.MODULE$.EXECUTOR_JAVA_OPTIONS())).map((Function1 & Serializable & scala.Serializable)s -> Utils$.MODULE$.splitCommandString((String)s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq classPathEntries = (Seq)((Option)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().get(package$.MODULE$.EXECUTOR_CLASS_PATH())).map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(File.pathSeparator))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq libraryPathEntries = (Seq)((Option)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().get(package$.MODULE$.EXECUTOR_LIBRARY_PATH())).map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split(File.pathSeparator))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Nil$ testingClassPath = scala.sys.package$.MODULE$.props().contains(Tests$.MODULE$.IS_TESTING().key()) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)scala.sys.package$.MODULE$.props().apply((Object)"java.class.path")).split(File.pathSeparator))).toSeq() : Nil$.MODULE$;
        Seq<String> sparkJavaOpts = Utils$.MODULE$.sparkJavaOpts(this.conf(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
        Seq javaOpts = (Seq)sparkJavaOpts.$plus$plus((GenTraversableOnce)extraJavaOpts, Seq$.MODULE$.canBuildFrom());
        Command command = new Command("org.apache.spark.executor.CoarseGrainedExecutorBackend", (Seq<String>)args, (Map<String, String>)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.executorEnvs(), (Seq<String>)((Seq)classPathEntries.$plus$plus((GenTraversableOnce)testingClassPath, Seq$.MODULE$.canBuildFrom())), (Seq<String>)libraryPathEntries, (Seq<String>)javaOpts);
        String webUrl = (String)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.ui().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.webUrl()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Option coresPerExecutor = this.conf().getOption(package$.MODULE$.EXECUTOR_CORES().key()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StandaloneSchedulerBackend.$anonfun$start$10(x$4)));
        None$ initialExecutorLimit = Utils$.MODULE$.isDynamicAllocationEnabled(this.conf()) ? new Some((Object)BoxesRunTime.boxToInteger((int)0)) : None$.MODULE$;
        Seq<ResourceRequirement> executorResourceReqs = ResourceUtils$.MODULE$.parseResourceRequirements(this.conf(), package$.MODULE$.SPARK_EXECUTOR_PREFIX());
        String x$12 = this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.appName();
        Option<Object> x$22 = this.maxCores();
        int x$32 = this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.executorMemory();
        Command x$42 = command;
        String x$5 = webUrl;
        Option<URI> x$6 = this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.eventLogDir();
        Option<String> x$7 = this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.eventLogCodec();
        Option x$8 = coresPerExecutor;
        None$ x$9 = initialExecutorLimit;
        Seq<ResourceRequirement> x$10 = executorResourceReqs;
        String x$11 = ApplicationDescription$.MODULE$.apply$default$10();
        ApplicationDescription appDesc = new ApplicationDescription(x$12, x$22, x$32, x$42, x$5, x$6, x$7, (Option<Object>)x$8, (Option<Object>)x$9, x$11, x$10);
        this.client_$eq(new StandaloneAppClient(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.env().rpcEnv(), this.masters, appDesc, this, this.conf()));
        this.client().start();
        this.launcherBackend().setState(SparkAppHandle.State.SUBMITTED);
        this.waitForRegistration();
        this.launcherBackend().setState(SparkAppHandle.State.RUNNING);
    }

    @Override
    public void stop() {
        this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State.FINISHED);
    }

    @Override
    public void connected(String appId) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Connected to Spark cluster with app ID ").append(appId).toString());
        this.appId_$eq(appId);
        this.notifyContext();
        this.launcherBackend().setAppId(appId);
    }

    @Override
    public void disconnected() {
        block0: {
            this.notifyContext();
            if (this.stopping().get()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disconnected from Spark cluster! Waiting for reconnection...");
        }
    }

    @Override
    public void dead(String reason) {
        this.notifyContext();
        if (!this.stopping().get()) {
            this.launcherBackend().setState(SparkAppHandle.State.KILLED);
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Application has been killed. Reason: ").append(reason).toString());
            try {
                this.scheduler.error(reason);
            }
            finally {
                this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.stopInNewThread();
            }
        }
    }

    @Override
    public void executorAdded(String fullId, String workerId, String hostPort, int cores, int memory) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Granted executor ID %s on hostPort %s with %d core(s), %s RAM")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullId, hostPort, BoxesRunTime.boxToInteger((int)cores), Utils$.MODULE$.megabytesToString(memory)})));
    }

    @Override
    public void executorRemoved(String fullId, String message, Option<Object> exitStatus, boolean workerLost) {
        ExecutorLossReason executorLossReason;
        Option<Object> option = exitStatus;
        if (option instanceof Some) {
            Some some = (Some)option;
            int code = BoxesRunTime.unboxToInt((Object)some.value());
            executorLossReason = new ExecutorExited(code, true, message);
        } else if (None$.MODULE$.equals(option)) {
            executorLossReason = new SlaveLost(message, workerLost);
        } else {
            throw new MatchError(option);
        }
        SlaveLost reason = executorLossReason;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Executor %s removed: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullId, message})));
        this.removeExecutor(fullId.split("/")[1], reason);
    }

    @Override
    public void workerRemoved(String workerId, String host, String message) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Worker %s removed: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workerId, message})));
        this.removeWorker(workerId, host, message);
    }

    @Override
    public boolean sufficientResourcesRegistered() {
        return (double)this.totalCoreCount().get() >= (double)this.totalExpectedCores() * this.minRegisteredRatio();
    }

    @Override
    public String applicationId() {
        return (String)Option$.MODULE$.apply((Object)this.appId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Application ID is not initialized yet.");
            return this.super$applicationId();
        });
    }

    @Override
    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        Future future;
        Option option = Option$.MODULE$.apply((Object)this.client());
        if (option instanceof Some) {
            Some some = (Some)option;
            StandaloneAppClient c = (StandaloneAppClient)some.value();
            future = c.requestTotalExecutors(requestedTotal);
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to request executors before driver fully initialized.");
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    @Override
    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        Future future;
        Option option = Option$.MODULE$.apply((Object)this.client());
        if (option instanceof Some) {
            Some some = (Some)option;
            StandaloneAppClient c = (StandaloneAppClient)some.value();
            future = c.killExecutors(executorIds);
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to kill executors before driver fully initialized.");
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getDriverLogUrls() {
        String prefix = "SPARK_DRIVER_LOG_URL_";
        scala.collection.immutable.Map driverLogUrls = ((scala.collection.immutable.Map)scala.sys.package$.MODULE$.env().filterKeys((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith(prefix))).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2((Object)((String)e._1()).substring(prefix.length()).toLowerCase(Locale.ROOT), e._2()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return driverLogUrls.nonEmpty() ? new Some((Object)driverLogUrls) : None$.MODULE$;
    }

    private void waitForRegistration() {
        this.registrationBarrier().acquire();
    }

    private void notifyContext() {
        this.registrationBarrier().release();
    }

    public void org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State finalState) {
        if (this.stopping().compareAndSet(false, true)) {
            try {
                Function1<StandaloneSchedulerBackend, BoxedUnit> callback;
                super.stop();
                if (this.client() != null) {
                    this.client().stop();
                }
                if ((callback = this.shutdownCallback()) != null) {
                    callback.apply((Object)this);
                }
            }
            finally {
                this.launcherBackend().setState(finalState);
                this.launcherBackend().close();
            }
        }
    }

    public static final /* synthetic */ int $anonfun$start$10(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public StandaloneSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, String[] masters) {
        this.scheduler = scheduler;
        this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc = sc;
        this.masters = masters;
        super(scheduler, sc.env().rpcEnv());
        this.client = null;
        this.stopping = new AtomicBoolean(false);
        this.launcherBackend = new LauncherBackend(this){
            private final /* synthetic */ StandaloneSchedulerBackend $outer;

            public SparkConf conf() {
                return this.$outer.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf();
            }

            public void onStopRequest() {
                this.$outer.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State.KILLED);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.registrationBarrier = new Semaphore(0);
        this.maxCores = (Option)this.conf().get(package$.MODULE$.CORES_MAX());
        this.totalExpectedCores = BoxesRunTime.unboxToInt((Object)this.maxCores().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }
}

