/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.spark.scheduler.HighlyCompressedMapStatus$;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ma!B\n\u0015\u0001Ya\u0002\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0015B\u0019\t\u0011]\u0002!\u0011!Q!\naB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006K\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)Q\u0005\u0007\"Aa\t\u0001B\u0001B\u0003&q\t\u0003\u0005Q\u0001\t\u0005\t\u0015)\u0003D\u0011\u0015\t\u0006\u0001\"\u0003S\u0011\u0015\t\u0006\u0001\"\u0005[\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015i\u0007\u0001\"\u0011o\u000f\u0019!H\u0003#\u0001\u0017k\u001a11\u0003\u0006E\u0001-YDQ!U\b\u0005\u0002iDQa_\b\u0005\u0002qD\u0011\"a\u0003\u0010\u0003\u0003%I!!\u0004\u00033!Kw\r\u001b7z\u0007>l\u0007O]3tg\u0016$W*\u00199Ti\u0006$Xo\u001d\u0006\u0003+Y\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001cB\u0001A\u000f$OA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u0004\"\u0001J\u0013\u000e\u0003QI!A\n\u000b\u0003\u00135\u000b\u0007o\u0015;biV\u001c\bC\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\tIwNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059J#AD#yi\u0016\u0014h.\u00197ju\u0006\u0014G.Z\u0001\u0004Y>\u001c7\u0001\u0001\t\u0003eUj\u0011a\r\u0006\u0003iY\tqa\u001d;pe\u0006<W-\u0003\u00027g\tq!\t\\8dW6\u000bg.Y4fe&#\u0017!\u00058v[:{g.R7qif\u0014En\\2lgB\u0011a$O\u0005\u0003u}\u00111!\u00138u\u0003-)W\u000e\u001d;z\u00052|7m[:\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}R\u0012!\u0004:pCJLgn\u001a2ji6\f\u0007/\u0003\u0002B}\ti!k\\1sS:<')\u001b;nCB\fq!\u0019<h'&TX\r\u0005\u0002\u001f\t&\u0011Qi\b\u0002\u0005\u0019>tw-\u0001\bik\u001e,'\t\\8dWNK'0Z:\u0011\t![\u0005(T\u0007\u0002\u0013*\u0011!jH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001'J\u0005\ri\u0015\r\u001d\t\u0003=9K!aT\u0010\u0003\t\tKH/Z\u0001\u000b?6\f\u0007\u000fV1tW&#\u0017A\u0002\u001fj]&$h\bF\u0004T)V3v\u000bW-\u0011\u0005\u0011\u0002\u0001\"B\u0018\b\u0001\u0004\t\u0004\"B\u001c\b\u0001\u0004A\u0004\"B\u001e\b\u0001\u0004a\u0004\"\u0002\"\b\u0001\u0004\u0019\u0005\"\u0002$\b\u0001\u00049\u0005\"\u0002)\b\u0001\u0004\u0019E#A*\u0002\u00111|7-\u0019;j_:,\u0012!M\u0001\u0010O\u0016$8+\u001b>f\r>\u0014(\t\\8dWR\u00111i\u0018\u0005\u0006A*\u0001\r\u0001O\u0001\te\u0016$WoY3JI\u0006)Q.\u00199JIV\t1)A\u0007xe&$X-\u0012=uKJt\u0017\r\u001c\u000b\u0003K\"\u0004\"A\b4\n\u0005\u001d|\"\u0001B+oSRDQ!\u001b\u0007A\u0002)\f1a\\;u!\tA3.\u0003\u0002mS\taqJ\u00196fGR|U\u000f\u001e9vi\u0006a!/Z1e\u000bb$XM\u001d8bYR\u0011Qm\u001c\u0005\u0006a6\u0001\r!]\u0001\u0003S:\u0004\"\u0001\u000b:\n\u0005ML#aC(cU\u0016\u001cG/\u00138qkR\f\u0011\u0004S5hQ2L8i\\7qe\u0016\u001c8/\u001a3NCB\u001cF/\u0019;vgB\u0011AeD\n\u0004\u001fu9\bC\u0001\u0010y\u0013\tIxD\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001v\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0019VP`A\u0004\u0011\u0015y\u0013\u00031\u00012\u0011\u0019y\u0018\u00031\u0001\u0002\u0002\u0005\tRO\\2p[B\u0014Xm]:fINK'0Z:\u0011\ty\t\u0019aQ\u0005\u0004\u0003\u000by\"!B!se\u0006L\bBBA\u0005#\u0001\u00071)A\u0005nCB$\u0016m]6JI\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bK\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001a\u0005M!AB(cU\u0016\u001cG\u000f")
public class HighlyCompressedMapStatus
implements MapStatus,
Externalizable {
    private BlockManagerId loc;
    private int numNonEmptyBlocks;
    private RoaringBitmap emptyBlocks;
    private long avgSize;
    private Map<Object, Object> hugeBlockSizes;
    private long _mapTaskId;

    public static HighlyCompressedMapStatus apply(BlockManagerId blockManagerId, long[] lArray, long l) {
        return HighlyCompressedMapStatus$.MODULE$.apply(blockManagerId, lArray, l);
    }

    @Override
    public BlockManagerId location() {
        return this.loc;
    }

    @Override
    public long getSizeForBlock(int reduceId) {
        long l;
        Predef$.MODULE$.assert(this.hugeBlockSizes != null);
        if (this.emptyBlocks.contains(reduceId)) {
            l = 0L;
        } else {
            long l2;
            Option option = this.hugeBlockSizes.get((Object)BoxesRunTime.boxToInteger((int)reduceId));
            if (option instanceof Some) {
                Some some = (Some)option;
                byte size = BoxesRunTime.unboxToByte((Object)some.value());
                l2 = MapStatus$.MODULE$.decompressSize(size);
            } else if (None$.MODULE$.equals(option)) {
                l2 = this.avgSize;
            } else {
                throw new MatchError((Object)option);
            }
            l = l2;
        }
        return l;
    }

    @Override
    public long mapId() {
        return this._mapTaskId;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.loc.writeExternal(out);
            $this.emptyBlocks.writeExternal(out);
            out.writeLong($this.avgSize);
            out.writeInt($this.hugeBlockSizes.size());
            $this.hugeBlockSizes.foreach((Function1 & Serializable & scala.Serializable)kv -> {
                HighlyCompressedMapStatus.$anonfun$writeExternal$3(out, kv);
                return BoxedUnit.UNIT;
            });
            out.writeLong($this._mapTaskId);
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.loc = BlockManagerId$.MODULE$.apply(in);
            $this.numNonEmptyBlocks = -1;
            $this.emptyBlocks = new RoaringBitmap();
            $this.emptyBlocks.readExternal(in);
            $this.avgSize = in.readLong();
            int count = in.readInt();
            scala.collection.mutable.Map hugeBlockSizesImpl = Map$.MODULE$.empty();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
                int block = in.readInt();
                byte size = in.readByte();
                hugeBlockSizesImpl.update((Object)BoxesRunTime.boxToInteger((int)block), (Object)BoxesRunTime.boxToByte((byte)size));
            });
            $this.hugeBlockSizes = hugeBlockSizesImpl;
            $this._mapTaskId = in.readLong();
        });
    }

    public static final /* synthetic */ void $anonfun$writeExternal$3(ObjectOutput out$2, Tuple2 kv) {
        out$2.writeInt(kv._1$mcI$sp());
        out$2.writeByte(BoxesRunTime.unboxToByte((Object)kv._2()));
    }

    public HighlyCompressedMapStatus(BlockManagerId loc, int numNonEmptyBlocks, RoaringBitmap emptyBlocks, long avgSize, Map<Object, Object> hugeBlockSizes, long _mapTaskId) {
        this.loc = loc;
        this.numNonEmptyBlocks = numNonEmptyBlocks;
        this.emptyBlocks = emptyBlocks;
        this.avgSize = avgSize;
        this.hugeBlockSizes = hugeBlockSizes;
        this._mapTaskId = _mapTaskId;
        Predef$.MODULE$.require(loc == null || avgSize > 0L || hugeBlockSizes.size() > 0 || numNonEmptyBlocks == 0 || _mapTaskId > 0L, (Function0 & Serializable & scala.Serializable)() -> "Average size can only be zero for map stages that produced no output");
    }

    public HighlyCompressedMapStatus() {
        this(null, -1, null, -1L, null, -1L);
    }
}

