"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDatabase = exports.toJson_CfnDatabaseProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnDatabaseProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnDatabaseProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'DataRetentionTimeInDays': obj.dataRetentionTimeInDays,
        'MaxDataExtensionTimeInDays': obj.maxDataExtensionTimeInDays,
        'DefaultDdlCollation': obj.defaultDdlCollation,
        'Comment': obj.comment,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnDatabaseProps = toJson_CfnDatabaseProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Snowflake::Database::Database`
 *
 * @cloudformationResource Snowflake::Database::Database
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-snowflake-resource-providers.git
 */
class CfnDatabase extends cdk.CfnResource {
    /**
     * Create a new `Snowflake::Database::Database`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDatabase.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnDatabaseProps(props) });
        this.props = props;
    }
}
exports.CfnDatabase = CfnDatabase;
_a = JSII_RTTI_SYMBOL_1;
CfnDatabase[_a] = { fqn: "@cdk-cloudformation/snowflake-database-database.CfnDatabase", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnDatabase.CFN_RESOURCE_TYPE_NAME = "Snowflake::Database::Database";
//# sourceMappingURL=data:application/json;base64,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