# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_sync_scala.ipynb (unless otherwise specified).

__all__ = ['get_name', 'qual_name', 'source_nb', 'nbdev_update_lib', 'nbdev_diff_nbs', 'nbdev_trust_nbs']

# Cell
from nbdev.imports import *
# from nbdev.export import *
from fastcore.script import *
import nbformat
from nbformat.sign import NotebookNotary

# Cell
import sys
import os

# SCRIPT_DIR = os.path.dirname(os.getcwd()) + '/chisel_nbdev'
# sys.path.append(os.path.normpath(SCRIPT_DIR))
# from export_scala import *
from .export_scala import *

# Cell
def _get_property_name(p):
    "Get the name of property `p`"
    if hasattr(p, 'fget'):
        return p.fget.func.__qualname__ if hasattr(p.fget, 'func') else p.fget.__qualname__
    else: return next(iter(re.findall(r'\'(.*)\'', str(p)))).split('.')[-1]

def get_name(obj):
    "Get the name of `obj`"
    if hasattr(obj, '__name__'):       return obj.__name__
    elif getattr(obj, '_name', False): return obj._name
    elif hasattr(obj,'__origin__'):    return str(obj.__origin__).split('.')[-1] #for types
    elif type(obj)==property:          return _get_property_name(obj)
    else:                              return str(obj).split('.')[-1]

# Cell
def qual_name(obj):
    "Get the qualified name of `obj`"
    if hasattr(obj,'__qualname__'): return obj.__qualname__
    if inspect.ismethod(obj):       return f"{get_name(obj.__self__)}.{get_name(fn)}"
    return get_name(obj)

# Cell
def source_nb(func, is_name=None, return_all=False, mod=None):
    "Return the name of the notebook where `func` was defined"
    is_name = is_name or isinstance(func, str)
    if mod is None: mod = get_nbdev_module()
    index = mod.index
    name = func if is_name else qual_name(func)
#     print(f'source_nb : name = {name}')
    while len(name) > 0:
        if name in index: return (name,index[name]) if return_all else index[name]
        name = '.'.join(name.split('.')[:-1])

# Cell
_re_cell = re.compile(r'^// Cell|^// Internal Cell|^// Comes from\s+(\S+), cell')

# Cell
def _split(code):
    lines = code.split('\n')
    nbs_path = Config().path("nbs_path").relative_to(Config().config_file.parent)
    prefix = '' if nbs_path == Path('.') else f'{nbs_path}/'
    default_nb = re.search(f'File to edit: {prefix}(\\S+)\\s+', lines[0]).groups()[0]
    s,res = 1,[]
    while _re_cell.search(lines[s]) is None: s += 1
    e = s+1
    while e < len(lines):
        while e < len(lines) and _re_cell.search(lines[e]) is None: e += 1
        grps = _re_cell.search(lines[s]).groups()
        nb = grps[0] or default_nb
        content = lines[s+1:e]
        while len(content) > 1 and content[-1] == '': content = content[:-1]
        res.append((nb, '\n'.join(content)))
        s,e = e,e+1
    return res

# Cell
def _script2notebook(fname, dic, silent=False):
    "Put the content of `fname` back in the notebooks it came from."
    if os.environ.get('IN_TEST',0): return  # don't export if running tests
    fname = Path(fname)
    with open(fname, encoding='utf8') as f: code = f.read()
    splits = _split(code)
    rel_name = fname.absolute().resolve().relative_to(Config().path("lib_path"))
    key = str(rel_name.with_suffix(''))
    assert len(splits)==len(dic[key]), f'"{rel_name}" exported from notebooks should have {len(dic[key])} cells but has {len(splits)}.'
    assert all([c1[0]==c2[1]] for c1,c2 in zip(splits, dic[key]))
    splits = [(c2[0],c1[0],c1[1]) for c1,c2 in zip(splits, dic[key])]
#     print(f'fname: {fname}, rel_name: {rel_name}, splits: {splits}')
    # get index, dest_filename, code of each cell in the script
    nb_fnames = {Config().path("nbs_path")/s[1] for s in splits}
    for nb_fname in nb_fnames:
#         print(f'nb_fname: {nb_fname}')
        nb = read_nb(nb_fname)
        for i,f,c in splits:
#             c = _deal_loc_import(c, str(fname))
#             print(f'{f} : {c}')
            if f == nb_fname.name:
                flags = split_flags_and_code(nb['cells'][i], str)[0]
                nb['cells'][i]['source'] = flags + '\n' + c
#                 print(f"updated cell to: {nb['cells'][i]['source']}")
#                 nb['cells'][i]['source'] = flags + '\n' + c.replace('', '')
            NotebookNotary().sign(nb)
            nbformat.write(nb, str(nb_fname), version=4)

    if not silent: print(f"Converted {rel_name}.")

# Cell
@call_parse
def nbdev_update_lib(fname:Param("A python filename or glob to convert", str)=None,
                     silent:Param("Don't print results", bool_arg)=False):
    "Propagates any change in the modules matching `fname` to the notebooks that created them"
#     if fname.endswith('.ipynb'): raise ValueError("`nbdev_update_lib` operates on .py files.  If you wish to convert notebooks instead, see `nbdev_build_lib`.")
    if os.environ.get('IN_TEST',0): return
    dic = scala_notebook2script(silent=True, to_dict=True)
    exported = get_nbdev_module().modules
#     print('exported', exported)

    if fname is None:
        files = [f for f in Config().path("lib_path").glob('**/*.sc') if str(f.relative_to(Config().path("lib_path"))) in exported]
#         print(files)
    else: files = glob.glob(fname)
    [ _script2notebook(f, dic, silent=silent) for f in files]

# Cell
import subprocess
from distutils.dir_util import copy_tree

# Cell
@call_parse
def nbdev_diff_nbs():
    "Prints the diff between an export of the library in notebooks and the actual modules"
    lib_folder = Config().path("lib_path")
    with tempfile.TemporaryDirectory() as d1, tempfile.TemporaryDirectory() as d2:
        copy_tree(Config().path("lib_path"), d1)
        scala_notebook2script(silent=True)
        copy_tree(Config().path("lib_path"), d2)
        shutil.rmtree(Config().path("lib_path"))
        shutil.copytree(d1, str(Config().path("lib_path")))
        for d in [d1, d2]:
            if (Path(d)/'__pycache__').exists(): shutil.rmtree(Path(d)/'__pycache__')
        res = subprocess.run(['diff', '-ru', d1, d2], stdout=subprocess.PIPE)
        print(res.stdout.decode('utf-8'))

# Cell
@call_parse
def nbdev_trust_nbs(fname:Param("A notebook name or glob to convert", str)=None,
                    force_all:Param("Trust even notebooks that haven't changed", bool)=False):
    "Trust notebooks matching `fname`"
    check_fname = Config().path("nbs_path")/".last_checked"
    last_checked = os.path.getmtime(check_fname) if check_fname.exists() else None
    files = Config().path("nbs_path").glob('**/*.ipynb') if fname is None else glob.glob(fname)
    for fn in files:
        if last_checked and not force_all:
            last_changed = os.path.getmtime(fn)
            if last_changed < last_checked: continue
        nb = read_nb(fn)
        if not NotebookNotary().check_signature(nb): NotebookNotary().sign(nb)
    check_fname.touch(exist_ok=True)