# -*- coding: utf-8 -*-

"""
coingeckoapiv3

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3.api_helper import APIHelper
from coingeckoapiv3.configuration import Server
from coingeckoapiv3.controllers.base_controller import BaseController


class FinanceController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3 API."""

    def __init__(self, config, call_back=None):
        super(FinanceController, self).__init__(config, call_back)

    def listallfinanceplatforms(self,
                                per_page=None,
                                page=None):
        """Does a GET request to /finance_platforms.

        List all finance platforms

        Args:
            per_page (int, optional): Total results per page
            page (string, optional): page of results (paginated to 100 by
                default)

        Returns:
            void: Response from the API. List all finance platforms

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/finance_platforms'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'per_page': per_page,
            'page': page
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def listallfinanceproducts(self,
                               per_page=None,
                               page=None,
                               start_at=None,
                               end_at=None):
        """Does a GET request to /finance_products.

        List all finance products

        Args:
            per_page (int, optional): Total results per page
            page (string, optional): page of results (paginated to 100 by
                default)
            start_at (string, optional): start date of the financial products
            end_at (string, optional): end date of the financial products

        Returns:
            void: Response from the API. List all finance products

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/finance_products'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'per_page': per_page,
            'page': page,
            'start_at': start_at,
            'end_at': end_at
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)
