# -*- coding: utf-8 -*-

"""
coingeckoapiv3

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from coingeckoapiv3.api_helper import APIHelper
from coingeckoapiv3.configuration import Server
from coingeckoapiv3.controllers.base_controller import BaseController


class ExchangesController(BaseController):

    """A Controller to access Endpoints in the coingeckoapiv3 API."""

    def __init__(self, config, call_back=None):
        super(ExchangesController, self).__init__(config, call_back)

    def listallexchanges(self,
                         per_page=None,
                         page=None):
        """Does a GET request to /exchanges.

        List all exchanges

        Args:
            per_page (int, optional): Valid values: 1...250 Total results per
                page Default value:: 100
            page (string, optional): page through results

        Returns:
            void: Response from the API. List all exchanges

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/exchanges'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'per_page': per_page,
            'page': page
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def listallsupportedmarketsidandname_nopaginationrequired(self):
        """Does a GET request to /exchanges/list.

        Use this to obtain all the markets' id in order to make API calls

        Returns:
            void: Response from the API. List all coins with id and name

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/exchanges/list'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getexchangevolumein_bt_candtop_100_tickersonly(self,
                                                       id):
        """Does a GET request to /exchanges/{id}.

        Get exchange volume in BTC and tickers<br><br> **IMPORTANT**:
         Ticker object is limited to 100 items, to get more tickers, use
         `/exchanges/{id}/tickers`
         Ticker `is_stale` is true when ticker that has not been
         updated/unchanged from the exchange for a while.
         Ticker `is_anomaly` is true if ticker's price is outliered by our
         system.
         You are responsible for managing how you want to display these
         information (e.g. footnote, different background, change opacity,
         hide)

        Args:
            id (string): pass the exchange id (can be obtained from
                /exchanges/list) eg. binance

        Returns:
            void: Response from the API. Get exchange volume in BTC and top
                100 tickers

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/exchanges/{id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getexchangetickers_paginated_100_tickersperpage(self,
                                                        id,
                                                        coin_ids=None,
                                                        include_exchange_logo=None,
                                                        page=None,
                                                        depth=None,
                                                        order=None):
        """Does a GET request to /exchanges/{id}/tickers.

        Get exchange tickers (paginated)<br><br> **IMPORTANT**:
         Ticker `is_stale` is true when ticker that has not been
         updated/unchanged from the exchange for a while.
         Ticker `is_anomaly` is true if ticker's price is outliered by our
         system.
         You are responsible for managing how you want to display these
         information (e.g. footnote, different background, change opacity,
         hide)

        Args:
            id (string): pass the exchange id (can be obtained from
                /exchanges/list) eg. binance
            coin_ids (string, optional): filter tickers by coin_ids (ref:
                v3/coins/list)
            include_exchange_logo (string, optional): flag to show
                exchange_logo
            page (int, optional): Page through results
            depth (string, optional): flag to show 2% orderbook depth i.e.,
                cost_to_move_up_usd and cost_to_move_down_usd
            order (string, optional): valid values: <b>trust_score_desc
                (default), trust_score_asc and volume_desc</b>

        Returns:
            void: Response from the API. Get exchange tickers

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/exchanges/{id}/tickers'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'coin_ids': coin_ids,
            'include_exchange_logo': include_exchange_logo,
            'page': page,
            'depth': depth,
            'order': order
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getstatusupdatesforagivenexchange(self,
                                          id,
                                          per_page=None,
                                          page=None):
        """Does a GET request to /exchanges/{id}/status_updates.

        Get status updates for a given exchange

        Args:
            id (string): pass the exchange id (can be obtained from
                /exchanges/list) eg. binance
            per_page (int, optional): Total results per page
            page (int, optional): Page through results

        Returns:
            void: Response from the API. Get paginated status updates for a
                given coin

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/exchanges/{id}/status_updates'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'per_page': per_page,
            'page': page
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)

    def getvolume_chartdataforagivenexchange(self,
                                             id,
                                             days):
        """Does a GET request to /exchanges/{id}/volume_chart.

        Get volume_chart data for a given exchange

        Args:
            id (string): pass the exchange id (can be obtained from
                /exchanges/list) eg. binance
            days (int): Data up to number of days ago (eg. 1,14,30)

        Returns:
            void: Response from the API. Get exchange volume_chart data

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/exchanges/{id}/volume_chart'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, {
            'id': {'value': id, 'encode': True}
        })
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_parameters = {
            'days': days
        }
        _query_builder = APIHelper.append_url_with_query_parameters(
            _query_builder,
            _query_parameters
        )
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare and execute request
        _request = self.config.http_client.get(_query_url)
        _response = self.execute_request(_request)
        self.validate_response(_response)
