from .iter import iter, generator
from .lib_basic import (
    cons,
    uncons,
    first,
    second,
    nth,
    find,
    last,
    only,
    is_empty,
    length,
    consume,
)
from .lib_creation import (
    cycle,
    iterate,
    iterate_indexed,
    repeat,
    repeatedly,
    singleton,
    unfold,
)
from .lib_grouping import (
    group_by,
    chunks,
    chunks_by,
    window,
    pairs,
    partition,
    distribute,
)
from .lib_reducers import (
    fold,
    reduce,
    scan,
    acc,
    reduce_by,
    fold_by,
    fold_together,
    reduce_together,
    scan_together,
    acc_together,
    product,
    products,
    sums,
    all_by,
    any_by,
    top_k,
)
from .lib_selecting import (
    filter,
    remove,
    separate,
    drop,
    rdrop,
    take,
    rtake,
    unique,
    dedupe,
    converge,
)

__all__ = [
    # Core
    "iter",
    "generator",
    # Basic
    "cons",
    "uncons",
    "first",
    "second",
    "nth",
    "find",
    "only",
    "last",
    "is_empty",
    "length",
    "consume",
    # Creation
    "cycle",
    "iterate",
    "iterate_indexed",
    "repeat",
    "repeatedly",
    "singleton",
    "unfold",
    # Selection
    "filter",
    "remove",
    "separate",
    "drop",
    "rdrop",
    "take",
    "rtake",
    "unique",
    "dedupe",
    "converge",
    # Reducers
    "fold",
    "reduce",
    "scan",
    "acc",
    "reduce_by",
    "fold_by",
    "fold_together",
    "reduce_together",
    "scan_together",
    "acc_together",
    "product",
    "products",
    "sums",
    "all_by",
    "any_by",
    "top_k",
    # Grouping
    "group_by",
    "chunks",
    "chunks_by",
    "window",
    "pairs",
    "partition",
    "distribute",
]
