/**
 * Error thrown if the allocation is already ended.
 *
 */
export declare class AllocationAlreadyEndedError extends Error {
    constructor(id: string);
}
/**
 * Error thrown if the input is invalid.
 */
export declare class InvalidInputError extends Error {
    constructor(message: string);
}
/**
 * Error thrown if the allocation is not found.
 */
export declare class AllocationNotFoundError extends Error {
    constructor(id: string);
}
/**
 * Options for `start`.
 */
export interface AllocationsStartOptions {
    /**
     * Allocation id.
     */
    readonly id: string;
    /**
     * Account of the environment to be allocated.
     */
    readonly account: string;
    /**
     * Region of the environment to be allocated.
     */
    readonly region: string;
    /**
     * Which pool the environment belongs to.
     */
    readonly pool: string;
    /**
     * Identifier for the requester.
     */
    readonly requester: string;
}
/**
 * Options for `end`.
 */
export interface AllocationsEndOptions {
    /**
     * Allocation id.
     */
    readonly id: string;
    /**
     * Allocation outcome.
     */
    readonly outcome: string;
}
/**
 * Allocation data after it has ended.
 */
export interface Allocation {
    /**
     * Account of the environment to be allocated.
     */
    readonly account: string;
    /**
     * Region of the environment to be allocated.
     */
    readonly region: string;
    /**
     * Which pool the allocation is in.
     */
    readonly pool: string;
    /**
     * Start date of the allocation.
     */
    readonly start: string;
    /**
     * End date of the allocation.
     *
     * @default - undefined (allocation is not ended)
     */
    readonly end?: string;
    /**
     * Identifier for the requester.
     */
    readonly requester: string;
    /**
     * Allocation id.
     */
    readonly id: string;
    /**
     * Allocation outcome.
     *
     * @default - undefined (allocation is not ended)
     */
    readonly outcome?: string;
}
/**
 * Client for accessing the allocations table at runtime.
 */
export declare class AllocationsClient {
    private readonly tableName;
    private readonly ddbClient;
    constructor(tableName: string);
    /**
     * Retrieve an allocation by id.
     */
    get(id: string): Promise<Allocation>;
    /**
     * Start an allocation for a specific environment. Returns the allocation id.
     */
    start(opts: AllocationsStartOptions): Promise<void>;
    /**
     * End the allocation. Throws if the allocation has already ended.
     */
    end(opts: AllocationsEndOptions): Promise<Allocation>;
}
