"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AtmosphereService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const allocate_1 = require("./allocate");
const api_1 = require("./api");
const cleanup_1 = require("./cleanup");
const configuration_1 = require("./config/configuration");
const deallocate_1 = require("./deallocate");
const scheduler_1 = require("./scheduler");
const storage_1 = require("./storage");
/**
 * Atmosphere service to allocate AWS environments on-demand.
 */
class AtmosphereService extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.config = new configuration_1.Configuration(this, 'Configuration', {
            data: props.config,
        });
        this.environments = new storage_1.Environments(this, 'Environments');
        this.allocations = new storage_1.Allocations(this, 'Allocations');
        this.cleanup = new cleanup_1.Cleanup(this, 'Cleanup', {
            configuration: this.config,
            environments: this.environments,
            allocations: this.allocations,
        });
        this.scheduler = new scheduler_1.Scheduler(this, 'Scheduler', {
            environments: this.environments,
            allocations: this.allocations,
        });
        this.allocate = new allocate_1.Allocate(this, 'Allocate', {
            configuration: this.config,
            allocations: this.allocations,
            environments: this.environments,
            scheduler: this.scheduler,
        });
        this.deallocate = new deallocate_1.Deallocate(this, 'Deallocate', {
            environments: this.environments,
            allocations: this.allocations,
            scheduler: this.scheduler,
            cleanup: this.cleanup,
        });
        this.endpoint = new api_1.Endpoint(this, 'Endpoint', {
            allocate: this.allocate,
            deallocate: this.deallocate,
            ...props.endpoint,
        });
    }
}
exports.AtmosphereService = AtmosphereService;
_a = JSII_RTTI_SYMBOL_1;
AtmosphereService[_a] = { fqn: "@cdklabs/cdk-atmosphere-service.AtmosphereService", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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