import { Construct } from 'constructs';
import { Allocate } from './allocate';
import { Endpoint, EndpointOptions } from './api';
import { Cleanup } from './cleanup';
import { Configuration, ConfigurationData } from './config/configuration';
import { Deallocate } from './deallocate';
import { Scheduler } from './scheduler';
import { Allocations, Environments } from './storage';
/**
 * Properties for `AtmosphereService`
 */
export interface AtmosphereServiceProps {
    /**
     * Service Configuration, stored in a dedicated s3 bucket.
     */
    readonly config: ConfigurationData;
    /**
     * Options for the API endpoint.
     */
    readonly endpoint?: EndpointOptions;
}
/**
 * Atmosphere service to allocate AWS environments on-demand.
 */
export declare class AtmosphereService extends Construct {
    /**
     * Provides access to the service configuration file.
     */
    readonly config: Configuration;
    /**
     * Provides access to the environments table.
     */
    readonly environments: Environments;
    /**
     * Provides access to the allocations table.
     */
    readonly allocations: Allocations;
    /**
     * Provides access to the allocate function.
     */
    readonly allocate: Allocate;
    /**
     * Provides access to the deaclloce function.
     */
    readonly deallocate: Deallocate;
    /**
     * Provides access to the API gateway endpoint.
     */
    readonly endpoint: Endpoint;
    /**
     * Provides access to the scheduler.
     */
    readonly scheduler: Scheduler;
    /**
     * Provides access to the cleanup task.
     */
    readonly cleanup: Cleanup;
    constructor(scope: Construct, id: string, props: AtmosphereServiceProps);
}
