"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scheduler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const allocation_timeout_1 = require("./allocation-timeout");
const cleanup_timeout_1 = require("./cleanup-timeout");
/**
 * Scheduler layer.
 */
class Scheduler extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.role = new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('scheduler.amazonaws.com'),
        });
        this.cleanupTimeout = new cleanup_timeout_1.CleanupTimeout(this, 'CleanupTimeout', {
            environments: props.environments,
            allocations: props.allocations,
        });
        this.allocationTimeout = new allocation_timeout_1.AllocationTimeout(this, 'AllocationTimeout', {
            allocations: props.allocations,
        });
        this.cleanupTimeout.grantInvoke(this.role);
        this.allocationTimeout.grantInvoke(this.role);
        this.cleanupTimeout.dlq.grantSendMessages(this.role);
        this.allocationTimeout.dlq.grantSendMessages(this.role);
    }
    grantSchedule(grantee) {
        grantee.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['scheduler:CreateSchedule'],
            resources: ['*'],
        }));
    }
}
exports.Scheduler = Scheduler;
_a = JSII_RTTI_SYMBOL_1;
Scheduler[_a] = { fqn: "@cdklabs/cdk-atmosphere-service.Scheduler", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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