import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { Allocations, Environments } from '../storage';
import { AllocationTimeout } from './allocation-timeout';
import { CleanupTimeout } from './cleanup-timeout';
/**
 * Properties for `Scheduler`.
 */
export interface SchedulerProps {
    /**
     * Environments storage.
     */
    readonly environments: Environments;
    /**
     * Allocations storage.
     */
    readonly allocations: Allocations;
}
/**
 * Scheduler layer.
 */
export declare class Scheduler extends Construct {
    readonly role: iam.Role;
    readonly cleanupTimeout: CleanupTimeout;
    readonly allocationTimeout: AllocationTimeout;
    constructor(scope: Construct, id: string, props: SchedulerProps);
    grantSchedule(grantee: iam.IGrantable): void;
}
