/**
 * Properties for the `SchedulerClient`.
 */
export interface SchedulerClientProps {
    /**
     * The role eventbridge will use to invoke the event on its target.
     */
    readonly roleArn: string;
}
/**
 * Options for `allocationTimeout`.
 */
interface ScheduleAllocationTimeoutOptions {
    /**
     * Allocation id.
     */
    readonly allocationId: string;
    /**
     * Allocation timeout date.
     */
    readonly timeoutDate: Date;
    /**
     * Arn of the function invoked when an allocation times out.
     */
    readonly functionArn: string;
}
interface ScheduleCleanupTimeoutOptions {
    /**
     * Allocation id the environment is allocated to.
     */
    readonly allocationId: string;
    /**
     * Account of the environment being cleaned.
     */
    readonly account: string;
    /**
     * Region of the environment being cleaned.
     */
    readonly region: string;
    /**
     * Allocation timeout date.
     */
    readonly timeoutDate: Date;
    /**
     * Arn of the function invoked when a cleanup task times out.
     */
    readonly functionArn: string;
}
/**
 * Scheduler client to create the EventBridge schedulers needed by the system.
 */
export declare class SchedulerClient {
    private readonly props;
    private static readonly TIMEOUT_EVENT_PREFIX;
    private readonly scheduler;
    constructor(props: SchedulerClientProps);
    scheduleAllocationTimeout(opts: ScheduleAllocationTimeoutOptions): Promise<void>;
    scheduleCleanupTimeout(opts: ScheduleCleanupTimeoutOptions): Promise<void>;
    private scheduleExpression;
    private scheduleLambdaInvoke;
}
export {};
