"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CleanupTimeout = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const sqs = require("aws-cdk-lib/aws-sqs");
const constructs_1 = require("constructs");
const cleanup_timeout_function_1 = require("./cleanup-timeout-function");
const envars = require("../../envars");
class CleanupTimeout extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.dlq = new sqs.Queue(this, 'DLQ', { encryption: sqs.QueueEncryption.KMS_MANAGED });
        this.function = new cleanup_timeout_function_1.CleanupTimeoutFunction(this, 'Function', {
            deadLetterQueue: this.dlq,
            timeout: aws_cdk_lib_1.Duration.minutes(1),
        });
        props.allocations.grantReadWrite(this.function);
        props.environments.grantReadWrite(this.function);
        this.function.addEnvironment(envars.ALLOCATIONS_TABLE_NAME_ENV, props.allocations.table.tableName);
        this.function.addEnvironment(envars.ENVIRONMENTS_TABLE_NAME_ENV, props.environments.table.tableName);
    }
    grantInvoke(grantee) {
        this.function.grantInvoke(grantee);
    }
}
exports.CleanupTimeout = CleanupTimeout;
_a = JSII_RTTI_SYMBOL_1;
CleanupTimeout[_a] = { fqn: "@cdklabs/cdk-atmosphere-service.CleanupTimeout", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xlYW51cC10aW1lb3V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3NjaGVkdWxlci9jbGVhbnVwLXRpbWVvdXQvY2xlYW51cC10aW1lb3V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQXVDO0FBR3ZDLDJDQUEyQztBQUMzQywyQ0FBdUM7QUFDdkMseUVBQW9FO0FBQ3BFLHVDQUF1QztBQVF2QyxNQUFhLGNBQWUsU0FBUSxzQkFBUztJQUszQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLEtBQUssRUFBRSxFQUFFLFVBQVUsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFFdkYsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLGlEQUFzQixDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDM0QsZUFBZSxFQUFFLElBQUksQ0FBQyxHQUFHO1lBQ3pCLE9BQU8sRUFBRSxzQkFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7U0FDN0IsQ0FBQyxDQUFDO1FBRUgsS0FBSyxDQUFDLFdBQVcsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ2hELEtBQUssQ0FBQyxZQUFZLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUVqRCxJQUFJLENBQUMsUUFBUSxDQUFDLGNBQWMsQ0FBQyxNQUFNLENBQUMsMEJBQTBCLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDbkcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxjQUFjLENBQUMsTUFBTSxDQUFDLDJCQUEyQixFQUFFLEtBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBRXZHLENBQUM7SUFFTSxXQUFXLENBQUMsT0FBdUI7UUFDeEMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDckMsQ0FBQzs7QUF6Qkgsd0NBMkJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRHVyYXRpb24gfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzcXMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXNxcyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENsZWFudXBUaW1lb3V0RnVuY3Rpb24gfSBmcm9tICcuL2NsZWFudXAtdGltZW91dC1mdW5jdGlvbic7XG5pbXBvcnQgKiBhcyBlbnZhcnMgZnJvbSAnLi4vLi4vZW52YXJzJztcbmltcG9ydCB7IEFsbG9jYXRpb25zLCBFbnZpcm9ubWVudHMgfSBmcm9tICcuLi8uLi9zdG9yYWdlJztcblxuZXhwb3J0IGludGVyZmFjZSBDbGVhbnVwVGltZW91dFByb3BzIHtcbiAgcmVhZG9ubHkgZW52aXJvbm1lbnRzOiBFbnZpcm9ubWVudHM7XG4gIHJlYWRvbmx5IGFsbG9jYXRpb25zOiBBbGxvY2F0aW9ucztcbn1cblxuZXhwb3J0IGNsYXNzIENsZWFudXBUaW1lb3V0IGV4dGVuZHMgQ29uc3RydWN0IHtcblxuICBwdWJsaWMgcmVhZG9ubHkgZGxxOiBzcXMuUXVldWU7XG4gIHB1YmxpYyByZWFkb25seSBmdW5jdGlvbjogbGFtYmRhLkZ1bmN0aW9uO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDbGVhbnVwVGltZW91dFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMuZGxxID0gbmV3IHNxcy5RdWV1ZSh0aGlzLCAnRExRJywgeyBlbmNyeXB0aW9uOiBzcXMuUXVldWVFbmNyeXB0aW9uLktNU19NQU5BR0VEIH0pO1xuXG4gICAgdGhpcy5mdW5jdGlvbiA9IG5ldyBDbGVhbnVwVGltZW91dEZ1bmN0aW9uKHRoaXMsICdGdW5jdGlvbicsIHtcbiAgICAgIGRlYWRMZXR0ZXJRdWV1ZTogdGhpcy5kbHEsXG4gICAgICB0aW1lb3V0OiBEdXJhdGlvbi5taW51dGVzKDEpLFxuICAgIH0pO1xuXG4gICAgcHJvcHMuYWxsb2NhdGlvbnMuZ3JhbnRSZWFkV3JpdGUodGhpcy5mdW5jdGlvbik7XG4gICAgcHJvcHMuZW52aXJvbm1lbnRzLmdyYW50UmVhZFdyaXRlKHRoaXMuZnVuY3Rpb24pO1xuXG4gICAgdGhpcy5mdW5jdGlvbi5hZGRFbnZpcm9ubWVudChlbnZhcnMuQUxMT0NBVElPTlNfVEFCTEVfTkFNRV9FTlYsIHByb3BzLmFsbG9jYXRpb25zLnRhYmxlLnRhYmxlTmFtZSk7XG4gICAgdGhpcy5mdW5jdGlvbi5hZGRFbnZpcm9ubWVudChlbnZhcnMuRU5WSVJPTk1FTlRTX1RBQkxFX05BTUVfRU5WLCBwcm9wcy5lbnZpcm9ubWVudHMudGFibGUudGFibGVOYW1lKTtcblxuICB9XG5cbiAgcHVibGljIGdyYW50SW52b2tlKGdyYW50ZWU6IGlhbS5JR3JhbnRhYmxlKSB7XG4gICAgdGhpcy5mdW5jdGlvbi5ncmFudEludm9rZShncmFudGVlKTtcbiAgfVxuXG59Il19