import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as sqs from 'aws-cdk-lib/aws-sqs';
import { Construct } from 'constructs';
import { Allocations, Environments } from '../../storage';
export interface CleanupTimeoutProps {
    readonly environments: Environments;
    readonly allocations: Allocations;
}
export declare class CleanupTimeout extends Construct {
    readonly dlq: sqs.Queue;
    readonly function: lambda.Function;
    constructor(scope: Construct, id: string, props: CleanupTimeoutProps);
    grantInvoke(grantee: iam.IGrantable): void;
}
