import { Logger } from '../../logging';
export interface AllocationTimeoutEvent {
    readonly allocationId: string;
}
/**
 * Responsible for forcefully releasing an environment in case its allocation period has
 * expired before the requester explicitly released it (for example if the requester process crashed).
 * This ensures a requester cannot hold an environment forever.
 *
 * It is triggered on a fixed schedule via an EventBridge (one-time) schedule that is created upon allocation.
 * Being a schedule, it may very well be triggered even if the allocation was already explicitly ended by the
 * requester; in that case, this function will simply return and do nothing.
 *
 * Implementation
 * --------------
 *
 * 1. Synchronously invoke the deallocate function with an outcome of `timeout`.
 *
 * > Note that we could have also configured the schedule itself to do so.
 * > However, this function gives us a place to perform additional perations
 * > on an allocation timeout.
*/
export declare function handler(event: AllocationTimeoutEvent): Promise<void>;
export declare function doHandler(event: AllocationTimeoutEvent, log: Logger): Promise<void>;
