"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AllocationTimeout = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const sqs = require("aws-cdk-lib/aws-sqs");
const constructs_1 = require("constructs");
const allocation_timeout_function_1 = require("./allocation-timeout-function");
const envars = require("../../envars");
class AllocationTimeout extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.dlq = new sqs.Queue(this, 'DLQ', { encryption: sqs.QueueEncryption.KMS_MANAGED });
        this.function = new allocation_timeout_function_1.AllocationTimeoutFunction(this, 'Function', {
            deadLetterQueue: this.dlq,
            timeout: aws_cdk_lib_1.Duration.minutes(1),
        });
        props.allocations.grantRead(this.function);
        this.function.addEnvironment(envars.ALLOCATIONS_TABLE_NAME_ENV, props.allocations.table.tableName);
    }
    grantInvoke(grantee) {
        this.function.grantInvoke(grantee);
    }
}
exports.AllocationTimeout = AllocationTimeout;
_a = JSII_RTTI_SYMBOL_1;
AllocationTimeout[_a] = { fqn: "@cdklabs/cdk-atmosphere-service.AllocationTimeout", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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