"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logger = void 0;
/**
 * Log operations with specific context, which is included in the message prefix.
 *
 * Timestamps are not added because they make for very long messages which are hard to look
 * at in the CloudWatch console. Note that CloudWatch provides its own ingestion timestamps,
 * which are probably good enough for us.
 *
 */
class Logger {
    constructor(props) {
        this.prefix = `[${props.component}] [pool:${props.pool}] [aloc:${props.allocationId}]`;
    }
    info(message) {
        console.log(`${this.prefix} ${message}`);
    }
    error(error, message = '') {
        console.error(`${this.prefix} ${message}`, error);
    }
}
exports.Logger = Logger;
//# sourceMappingURL=data:application/json;base64,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