"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Deallocate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const deallocate_function_1 = require("./deallocate-function");
const envars = require("../envars");
/**
 * Deallocate function.
 */
class Deallocate extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.function = new deallocate_function_1.DeallocateFunction(this, 'Function', {
            timeout: aws_cdk_lib_1.Duration.minutes(1),
        });
        props.allocations.grantReadWrite(this.function);
        props.environments.grantReadWrite(this.function);
        props.scheduler.grantSchedule(this.function);
        props.cleanup.grantRun(this.function);
        // creating the cleanup timeout event requires passing the events role
        props.scheduler.role.grantPassRole(this.function.grantPrincipal);
        props.scheduler.allocationTimeout.function.addEnvironment(envars.DEALLOCATE_FUNCTION_NAME_ENV, this.function.functionName);
        this.function.grantInvoke(props.scheduler.allocationTimeout.function);
        this.function.addEnvironment(envars.ENVIRONMENTS_TABLE_NAME_ENV, props.environments.table.tableName);
        this.function.addEnvironment(envars.ALLOCATIONS_TABLE_NAME_ENV, props.allocations.table.tableName);
        this.function.addEnvironment(envars.CLEANUP_TIMEOUT_DLQ_ARN_ENV, props.scheduler.cleanupTimeout.dlq.queueArn);
        this.function.addEnvironment(envars.SCHEDULER_ROLE_ARN_ENV, props.scheduler.role.roleArn);
        this.function.addEnvironment(envars.CLEANUP_TIMEOUT_FUNCTION_ARN_ENV, props.scheduler.cleanupTimeout.function.functionArn);
        this.function.addEnvironment(envars.CLEANUP_CLUSTER_ARN_ENV, props.cleanup.cluster.clusterArn);
        this.function.addEnvironment(envars.CLEANUP_TASK_DEFINITION_ARN_ENV, props.cleanup.task.taskDefinitionArn);
        this.function.addEnvironment(envars.CLEANUP_TASK_SUBNET_ID_ENV, props.cleanup.subnetId);
        this.function.addEnvironment(envars.CLEANUP_TASK_SECURITY_GROUP_ID_ENV, props.cleanup.securityGroupId);
        this.function.addEnvironment(envars.CLEANUP_TASK_CONTAINER_NAME_ENV, props.cleanup.containerName);
    }
}
exports.Deallocate = Deallocate;
_a = JSII_RTTI_SYMBOL_1;
Deallocate[_a] = { fqn: "@cdklabs/cdk-atmosphere-service.Deallocate", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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