import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { Cleanup } from '../cleanup';
import { Scheduler } from '../scheduler';
import { Allocations, Environments } from '../storage';
/**
 * Properties for `Deallocate`.
 */
export interface DeallocateProps {
    /**
     * Allocations storage.
     */
    readonly allocations: Allocations;
    /**
     * Environments storage.
     */
    readonly environments: Environments;
    /**
     * Scheduler.
     */
    readonly scheduler: Scheduler;
    /**
     * Cleanup.
     */
    readonly cleanup: Cleanup;
}
/**
 * Deallocate function.
 */
export declare class Deallocate extends Construct {
    readonly function: lambda.Function;
    constructor(scope: Construct, id: string, props: DeallocateProps);
}
