"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Configuration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const s3 = require("aws-cdk-lib/aws-s3");
const s3Deploy = require("aws-cdk-lib/aws-s3-deployment");
const constructs_1 = require("constructs");
/**
 * Service configuration construct.
 *
 * Configuration data will be written to a JSON file and stored in a dedicated s3 bucket.
 * Logical components that needs access should use the `grantRead` method and then
 * download the file whenever they need to.
 */
class Configuration extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * S3 Object key of configuration file.
         */
        this.key = 'configuration.json';
        this.data = props.data;
        const accessLogsBucket = new s3.Bucket(this, 'AccessLogs', {
            blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
        });
        this.bucket = new s3.Bucket(this, 'Bucket', {
            // makes it easier in integ test cycles.
            // the bucket doesn't store state so its
            // ok to delete its data.
            autoDeleteObjects: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            serverAccessLogsBucket: accessLogsBucket,
        });
        new s3Deploy.BucketDeployment(this, 'Deployment', {
            sources: [s3Deploy.Source.jsonData(this.key, props.data)],
            destinationBucket: this.bucket,
        });
    }
    /**
     * Allow the given identity to download the configuration file(s).
     */
    grantRead(identity) {
        this.bucket.grantRead(identity, this.key);
    }
}
exports.Configuration = Configuration;
_a = JSII_RTTI_SYMBOL_1;
Configuration[_a] = { fqn: "@cdklabs/cdk-atmosphere-service.Configuration", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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