import * as iam from 'aws-cdk-lib/aws-iam';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * Environment Configuration.
 */
export interface Environment {
    /**
     * Account ID.
     */
    readonly account: string;
    /**
     * Region.
     */
    readonly region: string;
    /**
     * Which pool does this environment belong to.
     */
    readonly pool: string;
    /**
     * ARN of an Admin role in the account. This role must be pre-created
     * and allow the service to assume it.
     */
    readonly adminRoleArn: string;
}
/**
 * Configuration Data.
 */
export interface ConfigurationData {
    /**
     * List of environments, configured by the service operator.
     */
    readonly environments: Environment[];
}
/**
 * Properties of `Configuration`.
 */
export interface ConfigurationProps {
    /**
     * Data of the configuration file.
     */
    readonly data: ConfigurationData;
}
/**
 * Service configuration construct.
 *
 * Configuration data will be written to a JSON file and stored in a dedicated s3 bucket.
 * Logical components that needs access should use the `grantRead` method and then
 * download the file whenever they need to.
 */
export declare class Configuration extends Construct {
    /**
     * S3 Object key of configuration file.
     */
    readonly key = "configuration.json";
    /**
     * S3 Bucket where the configuration file is stored.
     */
    readonly bucket: s3.Bucket;
    /**
     * Configuration data.
     */
    readonly data: ConfigurationData;
    constructor(scope: Construct, id: string, props: ConfigurationProps);
    /**
     * Allow the given identity to download the configuration file(s).
     */
    grantRead(identity: iam.IGrantable): void;
}
