import type { Environment } from './configuration';
/**
 * Error thrown when an environment is not found.
 */
export declare class EnvironmentNotFoundError extends Error {
    readonly account: string;
    readonly region: string;
    constructor(account: string, region: string);
}
/**
 * Options for `listEnvironments`.
 */
export interface ListEnvironmentsOptions {
    /**
     * Which pool should the environment belong to.
     *
     * @default - any pool
     */
    readonly pool?: string;
}
/**
 * Client for accessing the configuration file at runtime.
 */
export declare class ConfigurationClient {
    private readonly s3Location;
    private readonly s3Client;
    private _data;
    constructor(s3Location: {
        bucket: string;
        key: string;
    });
    /**
     * Retrieve environments belonging to a specific pool.
     */
    listEnvironments(opts?: ListEnvironmentsOptions): Promise<Environment[]>;
    /**
     * Retrieve a single environment based on account + region.
     */
    getEnvironment(account: string, region: string): Promise<Environment>;
    private get data();
    private download;
}
