"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuntimeClients = void 0;
const cleanup_client_1 = require("./cleanup/cleanup.client");
const configuration_client_1 = require("./config/configuration.client");
const envars = require("./envars");
const scheduler_client_1 = require("./scheduler/scheduler.client");
const allocations_client_1 = require("./storage/allocations.client");
const environments_client_1 = require("./storage/environments.client");
/**
 * Factory class to initialize clients using environment variables.
 * Allows for lazy initialization of clients to avoid loading environment variables
 * until they are needed.
 */
class RuntimeClients {
    static getOrCreate() {
        if (!this._instance) {
            this._instance = new RuntimeClients();
        }
        return this._instance;
    }
    get configuration() {
        if (!this._configuration) {
            const bucket = envars.Envars.required(envars.CONFIGURATION_BUCKET_ENV);
            const key = envars.Envars.required(envars.CONFIGURATION_KEY_ENV);
            this._configuration = new configuration_client_1.ConfigurationClient({ bucket, key });
        }
        return this._configuration;
    }
    get environments() {
        if (!this._environments) {
            const tableName = envars.Envars.required(envars.ENVIRONMENTS_TABLE_NAME_ENV);
            this._environments = new environments_client_1.EnvironmentsClient(tableName);
        }
        return this._environments;
    }
    get allocations() {
        if (!this._allocations) {
            const tableName = envars.Envars.required(envars.ALLOCATIONS_TABLE_NAME_ENV);
            this._allocations = new allocations_client_1.AllocationsClient(tableName);
        }
        return this._allocations;
    }
    get scheduler() {
        if (!this._scheduler) {
            const roleArn = envars.Envars.required(envars.SCHEDULER_ROLE_ARN_ENV);
            this._scheduler = new scheduler_client_1.SchedulerClient({ roleArn });
        }
        return this._scheduler;
    }
    get cleanup() {
        if (!this._cleanup) {
            const clusterArn = envars.Envars.required(envars.CLEANUP_CLUSTER_ARN_ENV);
            const taskDefinitionArn = envars.Envars.required(envars.CLEANUP_TASK_DEFINITION_ARN_ENV);
            const subnetId = envars.Envars.required(envars.CLEANUP_TASK_SUBNET_ID_ENV);
            const securityGroupId = envars.Envars.required(envars.CLEANUP_TASK_SECURITY_GROUP_ID_ENV);
            const containerName = envars.Envars.required(envars.CLEANUP_TASK_CONTAINER_NAME_ENV);
            this._cleanup = new cleanup_client_1.CleanupClient({ clusterArn, taskDefinitionArn, subnetId, securityGroupId, containerName });
        }
        return this._cleanup;
    }
}
exports.RuntimeClients = RuntimeClients;
//# sourceMappingURL=data:application/json;base64,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