import { CleanupClient } from './cleanup/cleanup.client';
import { ConfigurationClient } from './config/configuration.client';
import { SchedulerClient } from './scheduler/scheduler.client';
import { AllocationsClient } from './storage/allocations.client';
import { EnvironmentsClient } from './storage/environments.client';
/**
 * Factory class to initialize clients using environment variables.
 * Allows for lazy initialization of clients to avoid loading environment variables
 * until they are needed.
 */
export declare class RuntimeClients {
    static getOrCreate(): RuntimeClients;
    private static _instance;
    private _configuration;
    private _environments;
    private _allocations;
    private _scheduler;
    private _cleanup;
    get configuration(): ConfigurationClient;
    get environments(): EnvironmentsClient;
    get allocations(): AllocationsClient;
    get scheduler(): SchedulerClient;
    get cleanup(): CleanupClient;
}
