"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cleanup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const ec2 = require("aws-cdk-lib/aws-ec2");
const aws_ecr_assets_1 = require("aws-cdk-lib/aws-ecr-assets");
const ecs = require("aws-cdk-lib/aws-ecs");
const iam = require("aws-cdk-lib/aws-iam");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const envars = require("../envars");
/**
 * Provides a cleanup task.
 */
class Cleanup extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.containerName = 'main';
        const vpc = new ec2.Vpc(this, 'Vpc', {
            subnetConfiguration: [{
                    subnetType: ec2.SubnetType.PUBLIC,
                    name: 'Public',
                }],
        });
        const logGroup = new logs.LogGroup(this, 'LogGroup');
        const securityGroup = new ec2.SecurityGroup(this, 'SecurityGroup', { vpc, allowAllOutbound: true });
        this.cluster = new ecs.Cluster(this, 'Cluster', {
            enableFargateCapacityProviders: true,
            vpc,
        });
        const subnets = this.cluster.vpc.selectSubnets({ subnetType: ec2.SubnetType.PUBLIC });
        this.subnetId = subnets.subnetIds[0];
        this.securityGroupId = securityGroup.securityGroupId;
        this.task = new ecs.FargateTaskDefinition(this, 'TaskDefinition', {
            runtimePlatform: {
                cpuArchitecture: ecs.CpuArchitecture.ARM64,
                operatingSystemFamily: ecs.OperatingSystemFamily.LINUX,
            },
        });
        this.task.addContainer(this.containerName, {
            image: ecs.ContainerImage.fromAsset(path.join(__dirname, 'image'), { platform: aws_ecr_assets_1.Platform.LINUX_ARM64 }),
            logging: ecs.LogDriver.awsLogs({
                logGroup,
                streamPrefix: 'cleanup',
            }),
            environment: {
                [envars.ENVIRONMENTS_TABLE_NAME_ENV]: props.environments.table.tableName,
                [envars.ALLOCATIONS_TABLE_NAME_ENV]: props.allocations.table.tableName,
                [envars.CONFIGURATION_BUCKET_ENV]: props.configuration.bucket.bucketName,
                [envars.CONFIGURATION_KEY_ENV]: props.configuration.key,
            },
        });
        // cleanup must be able to assume admin roles for all its environments
        // because it performs operations in those environments.
        for (const env of props.configuration.data.environments) {
            const adminRole = iam.Role.fromRoleArn(this, `AdminRole${env.account}${env.region}`, env.adminRoleArn);
            adminRole.grantAssumeRole(this.task.taskRole);
        }
        props.configuration.grantRead(this.task.taskRole);
        props.allocations.grantReadWrite(this.task.taskRole);
        props.environments.grantReadWrite(this.task.taskRole);
    }
    grantRun(grantee) {
        this.task.grantRun(grantee);
    }
}
exports.Cleanup = Cleanup;
_a = JSII_RTTI_SYMBOL_1;
Cleanup[_a] = { fqn: "@cdklabs/cdk-atmosphere-service.Cleanup", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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