import * as ecs from 'aws-cdk-lib/aws-ecs';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { Configuration } from '../config';
import { Allocations, Environments } from '../storage';
/**
 * Properties for `Cleanup`.
 */
export interface CleanupProps {
    /**
     * Service configuration.
     */
    readonly configuration: Configuration;
    /**
     * Environments storage.
     */
    readonly environments: Environments;
    /**
     * Allocations storage.
     */
    readonly allocations: Allocations;
}
/**
 * Provides a cleanup task.
 */
export declare class Cleanup extends Construct {
    readonly cluster: ecs.Cluster;
    readonly task: ecs.FargateTaskDefinition;
    readonly subnetId: string;
    readonly securityGroupId: string;
    readonly containerName: string;
    constructor(scope: Construct, id: string, props: CleanupProps);
    grantRun(grantee: iam.IGrantable): void;
}
