"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CleanupClient = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const client_ecs_1 = require("@aws-sdk/client-ecs");
const envars = require("../envars");
/**
 * Client for interfacting with the cleanup task.
 */
class CleanupClient {
    constructor(props) {
        this.props = props;
        this.ecs = new client_ecs_1.ECS();
    }
    async start(opts) {
        const response = await this.ecs.runTask({
            cluster: this.props.clusterArn,
            taskDefinition: this.props.taskDefinitionArn,
            launchType: 'FARGATE',
            // for troubleshooting. this allows task filtering
            // on the aws console.
            startedBy: opts.allocation.id,
            group: `aws://${opts.allocation.account}/${opts.allocation.region}`,
            networkConfiguration: {
                awsvpcConfiguration: {
                    subnets: [this.props.subnetId],
                    securityGroups: [this.props.securityGroupId],
                    assignPublicIp: 'ENABLED',
                },
            },
            overrides: {
                containerOverrides: [
                    {
                        name: this.props.containerName,
                        environment: [
                            { name: envars.CLEANUP_TASK_ALLOCATION_ID, value: opts.allocation.id },
                            { name: envars.CLEANUP_TASK_TIMEOUT_SECONDS, value: `${opts.timeoutSeconds}` },
                        ],
                    },
                ],
            },
        });
        return response.tasks[0].taskArn;
    }
}
exports.CleanupClient = CleanupClient;
//# sourceMappingURL=data:application/json;base64,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