import type { Allocation } from '../storage/allocations.client';
/**
 * Options for `start`.
 */
export interface CleanupStartOptions {
    /**
     * The allocation to clean.
     */
    readonly allocation: Allocation;
    /**
     * Timeout in seconds afterwhich the environment is marked dirty.
     */
    readonly timeoutSeconds: number;
}
/**
 * Properties for `CleanupClient`.
 */
export interface CleanupClientProps {
    /**
     * Arn of the ECS cluster running the task.
     */
    readonly clusterArn: string;
    /**
     * Arn of the cleanup task definition.
     */
    readonly taskDefinitionArn: string;
    /**
     * Subnet where to run the task in.
     */
    readonly subnetId: string;
    /**
     * Security group to attach to the task.
     */
    readonly securityGroupId: string;
    /**
     * Cleanup task container name.
     */
    readonly containerName: string;
}
/**
 * Client for interfacting with the cleanup task.
 */
export declare class CleanupClient {
    private readonly props;
    private readonly ecs;
    constructor(props: CleanupClientProps);
    start(opts: CleanupStartOptions): Promise<string | undefined>;
}
