import type { Environment } from '../config';
import { Logger } from '../logging';
export interface DeleteStackResult {
    readonly name: string;
    readonly error?: Error;
}
/**
 * Error thrown when the cleanup process did not result in a clean environment.
 */
export declare class CleanerError extends Error {
    readonly failedStacks: DeleteStackResult[];
    constructor(failedStacks: DeleteStackResult[]);
}
export declare class Cleaner {
    private readonly environment;
    private readonly log;
    private readonly credentials;
    private readonly cfn;
    constructor(environment: Environment, log: Logger);
    clean(timeoutSeconds: number): Promise<void>;
    private listStacks;
    private deleteStack;
}
