import { Stack } from '@aws-sdk/client-cloudformation';
import { AwsCredentialIdentityProvider } from '@smithy/types';
import { Logger } from '../logging';
/**
 * Options for `clean`.
 */
export interface CleanOptions {
    /**
     * Timeout date after which the operation should fail.
     */
    readonly timeoutDate: Date;
}
export declare class BucketsCleaner {
    private readonly stack;
    private readonly log;
    private readonly cfn;
    private readonly s3;
    constructor(credentials: AwsCredentialIdentityProvider, region: string, stack: Stack, log: Logger);
    clean(opts: CleanOptions): Promise<void>;
    private listBuckets;
    private emptyBucket;
    private deleteBucket;
}
