import * as apigateway from 'aws-cdk-lib/aws-apigateway';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as r53 from 'aws-cdk-lib/aws-route53';
import { Construct } from 'constructs';
import { Allocate } from '../allocate';
import { Deallocate } from '../deallocate';
/**
 * Options for `Endpoint`.
 */
export interface EndpointOptions {
    /**
     * List of principals that are allowed to access the endpoint.
     *
     * @default - endpoint is not accessible by anyone.
     */
    readonly allowedPrincipals?: iam.IPrincipal[];
    /**
     * Providing a hosted zone will create a custom domain for the API endpoint.
     * The FQDN will be the same as the domain name of the hosted zone.
     *
     * Sub domains are not currently supported.
     *
     * @default - no custom domain is created.
     */
    readonly hostedZone?: r53.IHostedZone;
}
/**
 * Properties `Endpoint`.
 */
export interface EndpointProps extends EndpointOptions {
    /**
     * Allocate function.
     */
    readonly allocate: Allocate;
    /**
     * Deallocate function.
     */
    readonly deallocate: Deallocate;
}
export declare class Endpoint extends Construct {
    /**
     * Api Gateway rest api.
     */
    readonly api: apigateway.RestApi;
    /**
     * Allocations sub resource.
     */
    readonly allocationsResource: apigateway.Resource;
    /**
     * Allocation sub resource.
     */
    readonly allocationResource: apigateway.Resource;
    constructor(scope: Construct, id: string, props: EndpointProps);
}
