"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Allocate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const allocate_function_1 = require("./allocate-function");
const envars = require("../envars");
/**
 * Allocate function.
 */
class Allocate extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.function = new allocate_function_1.AllocateFunction(this, 'Function', {
            timeout: aws_cdk_lib_1.Duration.minutes(1),
        });
        props.configuration.grantRead(this.function);
        props.environments.grantReadWrite(this.function);
        props.allocations.grantReadWrite(this.function);
        props.scheduler.grantSchedule(this.function);
        // creating the allocation timeout event requires passing the events role
        props.scheduler.role.grantPassRole(this.function.grantPrincipal);
        this.function.addEnvironment(envars.CONFIGURATION_BUCKET_ENV, props.configuration.bucket.bucketName);
        this.function.addEnvironment(envars.CONFIGURATION_KEY_ENV, props.configuration.key);
        this.function.addEnvironment(envars.ENVIRONMENTS_TABLE_NAME_ENV, props.environments.table.tableName);
        this.function.addEnvironment(envars.ALLOCATIONS_TABLE_NAME_ENV, props.allocations.table.tableName);
        this.function.addEnvironment(envars.ALLOCATION_TIMEOUT_DLQ_ARN_ENV, props.scheduler.allocationTimeout.dlq.queueArn);
        this.function.addEnvironment(envars.SCHEDULER_ROLE_ARN_ENV, props.scheduler.role.roleArn);
        this.function.addEnvironment(envars.ALLOCATION_TIMEOUT_FUNCTION_ARN_ENV, props.scheduler.allocationTimeout.function.functionArn);
        this.function.addEnvironment(envars.CLEANUP_TIMEOUT_FUNCTION_ARN_ENV, props.scheduler.cleanupTimeout.function.functionArn);
        // allocation must be able to assume admin roles for all its environments
        // because it passes credentials to clients.
        for (const env of props.configuration.data.environments) {
            const adminRole = iam.Role.fromRoleArn(this, `AdminRole${env.account}${env.region}`, env.adminRoleArn);
            adminRole.grantAssumeRole(this.function.grantPrincipal);
        }
    }
}
exports.Allocate = Allocate;
_a = JSII_RTTI_SYMBOL_1;
Allocate[_a] = { fqn: "@cdklabs/cdk-atmosphere-service.Allocate", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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