import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { Configuration } from '../config';
import { Scheduler } from '../scheduler';
import { Allocations, Environments } from '../storage';
/**
 * Properties for `Allocate`.
 */
export interface AllocateProps {
    /**
     * Service configuration.
     */
    readonly configuration: Configuration;
    /**
     * Allocations storage.
     */
    readonly allocations: Allocations;
    /**
     * Environments storage.
     */
    readonly environments: Environments;
    /**
     * Scheduler.
     */
    readonly scheduler: Scheduler;
}
/**
 * Allocate function.
 */
export declare class Allocate extends Construct {
    readonly function: lambda.Function;
    constructor(scope: Construct, id: string, props: AllocateProps);
}
