__name__ = "infomap"
__version__ = "1.0.7"
__description__ = "Infomap network clustering algorithm"
__author__ = "mapequation"
__email__ = "mapequation@gmail.com"
__license__ = "AGPL-3.0-or-later"
__homepage__ = "https://www.mapequation.org/infomap"
__url__ = "https://mapequation.github.io/infomap/"
__repo__ = "https://github.com/mapequation/infomap.git"
__issues__ = "https://github.com/mapequation/infomap/issues"
__keywords__ = "map-equation network-analysis community-detection clustering-algorithm"
__classifiers__ = ['Development Status :: 5 - Production/Stable', 'Intended Audience :: Science/Research', 'Topic :: Scientific/Engineering :: Information Analysis', 'License :: OSI Approved :: GNU Affero General Public License v3 or later (AGPLv3+)', 'Programming Language :: Python :: 3']
# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.0
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError('Python 2.7 or later required')

# Import the low-level C/C++ module
if __package__ or '.' in __name__:
    from . import _infomap
else:
    import _infomap

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if name == "thisown":
        return self.this.own(value)
    if name == "this":
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if not static:
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if name == "thisown":
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class FlowModel(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        _infomap.FlowModel_swiginit(self, _infomap.new_FlowModel())
    __swig_destroy__ = _infomap.delete_FlowModel

# Register FlowModel in _infomap:
_infomap.FlowModel_swigregister(FlowModel)
cvar = _infomap.cvar
FlowModel.undirected = _infomap.cvar.FlowModel_undirected
FlowModel.directed = _infomap.cvar.FlowModel_directed
FlowModel.undirdir = _infomap.cvar.FlowModel_undirdir
FlowModel.outdirdir = _infomap.cvar.FlowModel_outdirdir
FlowModel.rawdir = _infomap.cvar.FlowModel_rawdir

class Config(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    isCLI = property(_infomap.Config_isCLI_get, _infomap.Config_isCLI_set)
    networkFile = property(_infomap.Config_networkFile_get, _infomap.Config_networkFile_set)
    additionalInput = property(_infomap.Config_additionalInput_get, _infomap.Config_additionalInput_set)
    inputFormat = property(_infomap.Config_inputFormat_get, _infomap.Config_inputFormat_set)
    memoryInput = property(_infomap.Config_memoryInput_get, _infomap.Config_memoryInput_set)
    multilayerInput = property(_infomap.Config_multilayerInput_get, _infomap.Config_multilayerInput_set)
    withMemory = property(_infomap.Config_withMemory_get, _infomap.Config_withMemory_set)
    weightThreshold = property(_infomap.Config_weightThreshold_get, _infomap.Config_weightThreshold_set)
    unweightedPaths = property(_infomap.Config_unweightedPaths_get, _infomap.Config_unweightedPaths_set)
    pathMarkovOrder = property(_infomap.Config_pathMarkovOrder_get, _infomap.Config_pathMarkovOrder_set)
    bipartite = property(_infomap.Config_bipartite_get, _infomap.Config_bipartite_set)
    skipAdjustBipartiteFlow = property(_infomap.Config_skipAdjustBipartiteFlow_get, _infomap.Config_skipAdjustBipartiteFlow_set)
    hardPartitions = property(_infomap.Config_hardPartitions_get, _infomap.Config_hardPartitions_set)
    nonBacktracking = property(_infomap.Config_nonBacktracking_get, _infomap.Config_nonBacktracking_set)
    parseWithoutIOStreams = property(_infomap.Config_parseWithoutIOStreams_get, _infomap.Config_parseWithoutIOStreams_set)
    zeroBasedNodeNumbers = property(_infomap.Config_zeroBasedNodeNumbers_get, _infomap.Config_zeroBasedNodeNumbers_set)
    includeSelfLinks = property(_infomap.Config_includeSelfLinks_get, _infomap.Config_includeSelfLinks_set)
    ignoreEdgeWeights = property(_infomap.Config_ignoreEdgeWeights_get, _infomap.Config_ignoreEdgeWeights_set)
    nodeLimit = property(_infomap.Config_nodeLimit_get, _infomap.Config_nodeLimit_set)
    preClusterMultilayer = property(_infomap.Config_preClusterMultilayer_get, _infomap.Config_preClusterMultilayer_set)
    clusterDataFile = property(_infomap.Config_clusterDataFile_get, _infomap.Config_clusterDataFile_set)
    metaDataFile = property(_infomap.Config_metaDataFile_get, _infomap.Config_metaDataFile_set)
    metaDataRate = property(_infomap.Config_metaDataRate_get, _infomap.Config_metaDataRate_set)
    unweightedMetaData = property(_infomap.Config_unweightedMetaData_get, _infomap.Config_unweightedMetaData_set)
    numMetaDataDimensions = property(_infomap.Config_numMetaDataDimensions_get, _infomap.Config_numMetaDataDimensions_set)
    clusterDataIsHard = property(_infomap.Config_clusterDataIsHard_get, _infomap.Config_clusterDataIsHard_set)
    assignToNeighbouringModule = property(_infomap.Config_assignToNeighbouringModule_get, _infomap.Config_assignToNeighbouringModule_set)
    noInfomap = property(_infomap.Config_noInfomap_get, _infomap.Config_noInfomap_set)
    flowModel = property(_infomap.Config_flowModel_get, _infomap.Config_flowModel_set)
    directed = property(_infomap.Config_directed_get, _infomap.Config_directed_set)
    undirdir = property(_infomap.Config_undirdir_get, _infomap.Config_undirdir_set)
    outdirdir = property(_infomap.Config_outdirdir_get, _infomap.Config_outdirdir_set)
    rawdir = property(_infomap.Config_rawdir_get, _infomap.Config_rawdir_set)
    teleportToNodes = property(_infomap.Config_teleportToNodes_get, _infomap.Config_teleportToNodes_set)
    selfTeleportationProbability = property(_infomap.Config_selfTeleportationProbability_get, _infomap.Config_selfTeleportationProbability_set)
    markovTime = property(_infomap.Config_markovTime_get, _infomap.Config_markovTime_set)
    multilayerRelaxRate = property(_infomap.Config_multilayerRelaxRate_get, _infomap.Config_multilayerRelaxRate_set)
    multilayerRelaxLimit = property(_infomap.Config_multilayerRelaxLimit_get, _infomap.Config_multilayerRelaxLimit_set)
    multilayerRelaxLimitUp = property(_infomap.Config_multilayerRelaxLimitUp_get, _infomap.Config_multilayerRelaxLimitUp_set)
    multilayerRelaxLimitDown = property(_infomap.Config_multilayerRelaxLimitDown_get, _infomap.Config_multilayerRelaxLimitDown_set)
    multilayerJSRelaxRate = property(_infomap.Config_multilayerJSRelaxRate_get, _infomap.Config_multilayerJSRelaxRate_set)
    multilayerJSRelaxLimit = property(_infomap.Config_multilayerJSRelaxLimit_get, _infomap.Config_multilayerJSRelaxLimit_set)
    twoLevel = property(_infomap.Config_twoLevel_get, _infomap.Config_twoLevel_set)
    noCoarseTune = property(_infomap.Config_noCoarseTune_get, _infomap.Config_noCoarseTune_set)
    directedEdges = property(_infomap.Config_directedEdges_get, _infomap.Config_directedEdges_set)
    recordedTeleportation = property(_infomap.Config_recordedTeleportation_get, _infomap.Config_recordedTeleportation_set)
    teleportationProbability = property(_infomap.Config_teleportationProbability_get, _infomap.Config_teleportationProbability_set)
    preferredNumberOfModules = property(_infomap.Config_preferredNumberOfModules_get, _infomap.Config_preferredNumberOfModules_set)
    seedToRandomNumberGenerator = property(_infomap.Config_seedToRandomNumberGenerator_get, _infomap.Config_seedToRandomNumberGenerator_set)
    numTrials = property(_infomap.Config_numTrials_get, _infomap.Config_numTrials_set)
    minimumCodelengthImprovement = property(_infomap.Config_minimumCodelengthImprovement_get, _infomap.Config_minimumCodelengthImprovement_set)
    minimumSingleNodeCodelengthImprovement = property(_infomap.Config_minimumSingleNodeCodelengthImprovement_get, _infomap.Config_minimumSingleNodeCodelengthImprovement_set)
    randomizeCoreLoopLimit = property(_infomap.Config_randomizeCoreLoopLimit_get, _infomap.Config_randomizeCoreLoopLimit_set)
    coreLoopLimit = property(_infomap.Config_coreLoopLimit_get, _infomap.Config_coreLoopLimit_set)
    levelAggregationLimit = property(_infomap.Config_levelAggregationLimit_get, _infomap.Config_levelAggregationLimit_set)
    tuneIterationLimit = property(_infomap.Config_tuneIterationLimit_get, _infomap.Config_tuneIterationLimit_set)
    minimumRelativeTuneIterationImprovement = property(_infomap.Config_minimumRelativeTuneIterationImprovement_get, _infomap.Config_minimumRelativeTuneIterationImprovement_set)
    fastCoarseTunePartition = property(_infomap.Config_fastCoarseTunePartition_get, _infomap.Config_fastCoarseTunePartition_set)
    alternateCoarseTuneLevel = property(_infomap.Config_alternateCoarseTuneLevel_get, _infomap.Config_alternateCoarseTuneLevel_set)
    coarseTuneLevel = property(_infomap.Config_coarseTuneLevel_get, _infomap.Config_coarseTuneLevel_set)
    superLevelLimit = property(_infomap.Config_superLevelLimit_get, _infomap.Config_superLevelLimit_set)
    onlySuperModules = property(_infomap.Config_onlySuperModules_get, _infomap.Config_onlySuperModules_set)
    fastHierarchicalSolution = property(_infomap.Config_fastHierarchicalSolution_get, _infomap.Config_fastHierarchicalSolution_set)
    fastFirstIteration = property(_infomap.Config_fastFirstIteration_get, _infomap.Config_fastFirstIteration_set)
    preferModularSolution = property(_infomap.Config_preferModularSolution_get, _infomap.Config_preferModularSolution_set)
    innerParallelization = property(_infomap.Config_innerParallelization_get, _infomap.Config_innerParallelization_set)
    outDirectory = property(_infomap.Config_outDirectory_get, _infomap.Config_outDirectory_set)
    outName = property(_infomap.Config_outName_get, _infomap.Config_outName_set)
    outputFormats = property(_infomap.Config_outputFormats_get, _infomap.Config_outputFormats_set)
    originallyUndirected = property(_infomap.Config_originallyUndirected_get, _infomap.Config_originallyUndirected_set)
    printTree = property(_infomap.Config_printTree_get, _infomap.Config_printTree_set)
    printFlowTree = property(_infomap.Config_printFlowTree_get, _infomap.Config_printFlowTree_set)
    printMap = property(_infomap.Config_printMap_get, _infomap.Config_printMap_set)
    printClu = property(_infomap.Config_printClu_get, _infomap.Config_printClu_set)
    cluLevel = property(_infomap.Config_cluLevel_get, _infomap.Config_cluLevel_set)
    printNodeRanks = property(_infomap.Config_printNodeRanks_get, _infomap.Config_printNodeRanks_set)
    printFlowNetwork = property(_infomap.Config_printFlowNetwork_get, _infomap.Config_printFlowNetwork_set)
    printPajekNetwork = property(_infomap.Config_printPajekNetwork_get, _infomap.Config_printPajekNetwork_set)
    printStateNetwork = property(_infomap.Config_printStateNetwork_get, _infomap.Config_printStateNetwork_set)
    printBinaryTree = property(_infomap.Config_printBinaryTree_get, _infomap.Config_printBinaryTree_set)
    printBinaryFlowTree = property(_infomap.Config_printBinaryFlowTree_get, _infomap.Config_printBinaryFlowTree_set)
    noFileOutput = property(_infomap.Config_noFileOutput_get, _infomap.Config_noFileOutput_set)
    verbosity = property(_infomap.Config_verbosity_get, _infomap.Config_verbosity_set)
    verboseNumberPrecision = property(_infomap.Config_verboseNumberPrecision_get, _infomap.Config_verboseNumberPrecision_set)
    silent = property(_infomap.Config_silent_get, _infomap.Config_silent_set)
    benchmark = property(_infomap.Config_benchmark_get, _infomap.Config_benchmark_set)
    maxNodeIndexVisible = property(_infomap.Config_maxNodeIndexVisible_get, _infomap.Config_maxNodeIndexVisible_set)
    showBiNodes = property(_infomap.Config_showBiNodes_get, _infomap.Config_showBiNodes_set)
    minBipartiteNodeIndex = property(_infomap.Config_minBipartiteNodeIndex_get, _infomap.Config_minBipartiteNodeIndex_set)
    startDate = property(_infomap.Config_startDate_get, _infomap.Config_startDate_set)
    version = property(_infomap.Config_version_get, _infomap.Config_version_set)
    parsedString = property(_infomap.Config_parsedString_get, _infomap.Config_parsedString_set)
    parsedOptions = property(_infomap.Config_parsedOptions_get, _infomap.Config_parsedOptions_set)
    error = property(_infomap.Config_error_get, _infomap.Config_error_set)

    def __init__(self, *args):
        _infomap.Config_swiginit(self, _infomap.new_Config(*args))

    def cloneAsNonMain(self, other):
        return _infomap.Config_cloneAsNonMain(self, other)

    def setOptimizationLevel(self, level):
        return _infomap.Config_setOptimizationLevel(self, level)

    def adaptDefaults(self):
        return _infomap.Config_adaptDefaults(self)

    def setDirectedInput(self):
        return _infomap.Config_setDirectedInput(self)

    def setMemoryInput(self):
        return _infomap.Config_setMemoryInput(self)

    def setMultilayerInput(self):
        return _infomap.Config_setMultilayerInput(self)

    def isUndirectedClustering(self):
        return _infomap.Config_isUndirectedClustering(self)

    def isUndirectedFlow(self):
        return _infomap.Config_isUndirectedFlow(self)

    def printAsUndirected(self):
        return _infomap.Config_printAsUndirected(self)

    def is3gram(self):
        return _infomap.Config_is3gram(self)

    def isPath(self):
        return _infomap.Config_isPath(self)

    def isMultilayerNetwork(self):
        return _infomap.Config_isMultilayerNetwork(self)

    def isStateNetwork(self):
        return _infomap.Config_isStateNetwork(self)

    def isBipartite(self):
        return _infomap.Config_isBipartite(self)

    def isMemoryNetwork(self):
        return _infomap.Config_isMemoryNetwork(self)

    def haveMetaData(self):
        return _infomap.Config_haveMetaData(self)

    def haveOutput(self):
        return _infomap.Config_haveOutput(self)

    def haveModularResultOutput(self):
        return _infomap.Config_haveModularResultOutput(self)

    def elapsedTime(self):
        return _infomap.Config_elapsedTime(self)

    def setError(self, err):
        return _infomap.Config_setError(self, err)

    def haveError(self):
        return _infomap.Config_haveError(self)

    @staticmethod
    def fromString(flags, isCLI=False):
        return _infomap.Config_fromString(flags, isCLI)
    __swig_destroy__ = _infomap.delete_Config

# Register Config in _infomap:
_infomap.Config_swigregister(Config)

def Config_fromString(flags, isCLI=False):
    return _infomap.Config_fromString(flags, isCLI)

class FlowData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.FlowData_swiginit(self, _infomap.new_FlowData(*args))
    flow = property(_infomap.FlowData_flow_get, _infomap.FlowData_flow_set)
    enterFlow = property(_infomap.FlowData_enterFlow_get, _infomap.FlowData_enterFlow_set)
    exitFlow = property(_infomap.FlowData_exitFlow_get, _infomap.FlowData_exitFlow_set)

    def __iadd__(self, other):
        return _infomap.FlowData___iadd__(self, other)

    def __isub__(self, other):
        return _infomap.FlowData___isub__(self, other)


    @property
    def enter_flow(self):
    	"""Get the flow entering the node."""
    	return self.enterFlow

    @property
    def exit_flow(self):
    	"""Get the flow exiting the node."""
    	return self.exitFlow


    __swig_destroy__ = _infomap.delete_FlowData

# Register FlowData in _infomap:
_infomap.FlowData_swigregister(FlowData)

class DeltaFlow(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    module = property(_infomap.DeltaFlow_module_get, _infomap.DeltaFlow_module_set)
    deltaExit = property(_infomap.DeltaFlow_deltaExit_get, _infomap.DeltaFlow_deltaExit_set)
    deltaEnter = property(_infomap.DeltaFlow_deltaEnter_get, _infomap.DeltaFlow_deltaEnter_set)
    count = property(_infomap.DeltaFlow_count_get, _infomap.DeltaFlow_count_set)
    __swig_destroy__ = _infomap.delete_DeltaFlow

    def __init__(self, *args):
        _infomap.DeltaFlow_swiginit(self, _infomap.new_DeltaFlow(*args))

    def __iadd__(self, other):
        return _infomap.DeltaFlow___iadd__(self, other)

    def reset(self):
        return _infomap.DeltaFlow_reset(self)

# Register DeltaFlow in _infomap:
_infomap.DeltaFlow_swigregister(DeltaFlow)

class MemDeltaFlow(DeltaFlow):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    sumDeltaPlogpPhysFlow = property(_infomap.MemDeltaFlow_sumDeltaPlogpPhysFlow_get, _infomap.MemDeltaFlow_sumDeltaPlogpPhysFlow_set)
    sumPlogpPhysFlow = property(_infomap.MemDeltaFlow_sumPlogpPhysFlow_get, _infomap.MemDeltaFlow_sumPlogpPhysFlow_set)

    def __init__(self, *args):
        _infomap.MemDeltaFlow_swiginit(self, _infomap.new_MemDeltaFlow(*args))

    def __iadd__(self, other):
        return _infomap.MemDeltaFlow___iadd__(self, other)

    def reset(self):
        return _infomap.MemDeltaFlow_reset(self)
    __swig_destroy__ = _infomap.delete_MemDeltaFlow

# Register MemDeltaFlow in _infomap:
_infomap.MemDeltaFlow_swigregister(MemDeltaFlow)

class PhysData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.PhysData_swiginit(self, _infomap.new_PhysData(*args))
    physNodeIndex = property(_infomap.PhysData_physNodeIndex_get, _infomap.PhysData_physNodeIndex_set)
    sumFlowFromM2Node = property(_infomap.PhysData_sumFlowFromM2Node_get, _infomap.PhysData_sumFlowFromM2Node_set)
    __swig_destroy__ = _infomap.delete_PhysData

# Register PhysData in _infomap:
_infomap.PhysData_swigregister(PhysData)

class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _infomap.delete_SwigPyIterator

    def value(self):
        return _infomap.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _infomap.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _infomap.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _infomap.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _infomap.SwigPyIterator_equal(self, x)

    def copy(self):
        return _infomap.SwigPyIterator_copy(self)

    def next(self):
        return _infomap.SwigPyIterator_next(self)

    def __next__(self):
        return _infomap.SwigPyIterator___next__(self)

    def previous(self):
        return _infomap.SwigPyIterator_previous(self)

    def advance(self, n):
        return _infomap.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _infomap.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _infomap.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _infomap.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _infomap.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _infomap.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _infomap.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _infomap:
_infomap.SwigPyIterator_swigregister(SwigPyIterator)

class vector_uint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _infomap.vector_uint_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _infomap.vector_uint___nonzero__(self)

    def __bool__(self):
        return _infomap.vector_uint___bool__(self)

    def __len__(self):
        return _infomap.vector_uint___len__(self)

    def __getslice__(self, i, j):
        return _infomap.vector_uint___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _infomap.vector_uint___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _infomap.vector_uint___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _infomap.vector_uint___delitem__(self, *args)

    def __getitem__(self, *args):
        return _infomap.vector_uint___getitem__(self, *args)

    def __setitem__(self, *args):
        return _infomap.vector_uint___setitem__(self, *args)

    def pop(self):
        return _infomap.vector_uint_pop(self)

    def append(self, x):
        return _infomap.vector_uint_append(self, x)

    def empty(self):
        return _infomap.vector_uint_empty(self)

    def size(self):
        return _infomap.vector_uint_size(self)

    def swap(self, v):
        return _infomap.vector_uint_swap(self, v)

    def begin(self):
        return _infomap.vector_uint_begin(self)

    def end(self):
        return _infomap.vector_uint_end(self)

    def rbegin(self):
        return _infomap.vector_uint_rbegin(self)

    def rend(self):
        return _infomap.vector_uint_rend(self)

    def clear(self):
        return _infomap.vector_uint_clear(self)

    def get_allocator(self):
        return _infomap.vector_uint_get_allocator(self)

    def pop_back(self):
        return _infomap.vector_uint_pop_back(self)

    def erase(self, *args):
        return _infomap.vector_uint_erase(self, *args)

    def __init__(self, *args):
        _infomap.vector_uint_swiginit(self, _infomap.new_vector_uint(*args))

    def push_back(self, x):
        return _infomap.vector_uint_push_back(self, x)

    def front(self):
        return _infomap.vector_uint_front(self)

    def back(self):
        return _infomap.vector_uint_back(self)

    def assign(self, n, x):
        return _infomap.vector_uint_assign(self, n, x)

    def resize(self, *args):
        return _infomap.vector_uint_resize(self, *args)

    def insert(self, *args):
        return _infomap.vector_uint_insert(self, *args)

    def reserve(self, n):
        return _infomap.vector_uint_reserve(self, n)

    def capacity(self):
        return _infomap.vector_uint_capacity(self)
    __swig_destroy__ = _infomap.delete_vector_uint

# Register vector_uint in _infomap:
_infomap.vector_uint_swigregister(vector_uint)

class InfoNode(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    data = property(_infomap.InfoNode_data_get, _infomap.InfoNode_data_set)
    index = property(_infomap.InfoNode_index_get, _infomap.InfoNode_index_set)
    stateId = property(_infomap.InfoNode_stateId_get, _infomap.InfoNode_stateId_set)
    physicalId = property(_infomap.InfoNode_physicalId_get, _infomap.InfoNode_physicalId_set)
    layerId = property(_infomap.InfoNode_layerId_get, _infomap.InfoNode_layerId_set)
    metaData = property(_infomap.InfoNode_metaData_get, _infomap.InfoNode_metaData_set)
    owner = property(_infomap.InfoNode_owner_get, _infomap.InfoNode_owner_set)
    parent = property(_infomap.InfoNode_parent_get, _infomap.InfoNode_parent_set)
    previous = property(_infomap.InfoNode_previous_get, _infomap.InfoNode_previous_set)
    next = property(_infomap.InfoNode_next_get, _infomap.InfoNode_next_set)
    firstChild = property(_infomap.InfoNode_firstChild_get, _infomap.InfoNode_firstChild_set)
    lastChild = property(_infomap.InfoNode_lastChild_get, _infomap.InfoNode_lastChild_set)
    collapsedFirstChild = property(_infomap.InfoNode_collapsedFirstChild_get, _infomap.InfoNode_collapsedFirstChild_set)
    collapsedLastChild = property(_infomap.InfoNode_collapsedLastChild_get, _infomap.InfoNode_collapsedLastChild_set)
    codelength = property(_infomap.InfoNode_codelength_get, _infomap.InfoNode_codelength_set)
    dirty = property(_infomap.InfoNode_dirty_get, _infomap.InfoNode_dirty_set)
    physicalNodes = property(_infomap.InfoNode_physicalNodes_get, _infomap.InfoNode_physicalNodes_set)
    metaCollection = property(_infomap.InfoNode_metaCollection_get, _infomap.InfoNode_metaCollection_set)
    stateNodes = property(_infomap.InfoNode_stateNodes_get, _infomap.InfoNode_stateNodes_set)

    def __init__(self, *args):
        _infomap.InfoNode_swiginit(self, _infomap.new_InfoNode(*args))
    __swig_destroy__ = _infomap.delete_InfoNode

    def getMetaData(self, dimension=0):
        return _infomap.InfoNode_getMetaData(self, dimension)

    def getInfomap(self):
        return _infomap.InfoNode_getInfomap(self)

    def setInfomap(self, arg2):
        return _infomap.InfoNode_setInfomap(self, arg2)

    def getInfomapRoot(self, *args):
        return _infomap.InfoNode_getInfomapRoot(self, *args)

    def disposeInfomap(self):
        return _infomap.InfoNode_disposeInfomap(self)

    def numPhysicalNodes(self):
        return _infomap.InfoNode_numPhysicalNodes(self)

    def begin(self, *args):
        return _infomap.InfoNode_begin(self, *args)

    def end(self, *args):
        return _infomap.InfoNode_end(self, *args)

    def begin_child(self, *args):
        return _infomap.InfoNode_begin_child(self, *args)

    def end_child(self, *args):
        return _infomap.InfoNode_end_child(self, *args)

    def children(self, *args):
        return _infomap.InfoNode_children(self, *args)

    def infomap_children(self, *args):
        return _infomap.InfoNode_infomap_children(self, *args)

    def begin_post_depth_first(self):
        return _infomap.InfoNode_begin_post_depth_first(self)

    def begin_tree(self, *args):
        return _infomap.InfoNode_begin_tree(self, *args)

    def end_tree(self, *args):
        return _infomap.InfoNode_end_tree(self, *args)

    def infomapTree(self, *args):
        return _infomap.InfoNode_infomapTree(self, *args)

    def begin_outEdge(self):
        return _infomap.InfoNode_begin_outEdge(self)

    def end_outEdge(self):
        return _infomap.InfoNode_end_outEdge(self)

    def begin_inEdge(self):
        return _infomap.InfoNode_begin_inEdge(self)

    def end_inEdge(self):
        return _infomap.InfoNode_end_inEdge(self)

    def outEdges(self):
        return _infomap.InfoNode_outEdges(self)

    def inEdges(self):
        return _infomap.InfoNode_inEdges(self)

    def childDegree(self):
        return _infomap.InfoNode_childDegree(self)

    def isLeaf(self):
        return _infomap.InfoNode_isLeaf(self)

    def isLeafModule(self):
        return _infomap.InfoNode_isLeafModule(self)

    def isRoot(self):
        return _infomap.InfoNode_isRoot(self)

    def depth(self):
        return _infomap.InfoNode_depth(self)

    def firstDepthBelow(self):
        return _infomap.InfoNode_firstDepthBelow(self)

    def numLeafMembers(self):
        return _infomap.InfoNode_numLeafMembers(self)

    def isDangling(self):
        return _infomap.InfoNode_isDangling(self)

    def outDegree(self):
        return _infomap.InfoNode_outDegree(self)

    def inDegree(self):
        return _infomap.InfoNode_inDegree(self)

    def degree(self):
        return _infomap.InfoNode_degree(self)

    def isFirst(self):
        return _infomap.InfoNode_isFirst(self)

    def isLast(self):
        return _infomap.InfoNode_isLast(self)

    def childIndex(self):
        return _infomap.InfoNode_childIndex(self)

    def calculatePath(self):
        return _infomap.InfoNode_calculatePath(self)

    def infomapChildDegree(self):
        return _infomap.InfoNode_infomapChildDegree(self)

    def id(self):
        return _infomap.InfoNode_id(self)

    def __eq__(self, rhs):
        return _infomap.InfoNode___eq__(self, rhs)

    def __ne__(self, rhs):
        return _infomap.InfoNode___ne__(self, rhs)

    def initClean(self):
        return _infomap.InfoNode_initClean(self)

    def sortChildrenOnFlow(self, recurse=True):
        return _infomap.InfoNode_sortChildrenOnFlow(self, recurse)

    def collapseChildren(self):
        return _infomap.InfoNode_collapseChildren(self)

    def expandChildren(self):
        return _infomap.InfoNode_expandChildren(self)

    def setChildDegree(self, value):
        return _infomap.InfoNode_setChildDegree(self, value)

    def setNumLeafNodes(self, value):
        return _infomap.InfoNode_setNumLeafNodes(self, value)

    def addChild(self, child):
        return _infomap.InfoNode_addChild(self, child)

    def releaseChildren(self):
        return _infomap.InfoNode_releaseChildren(self)

    def replaceChildrenWithOneNode(self):
        return _infomap.InfoNode_replaceChildrenWithOneNode(self)

    def replaceWithChildren(self):
        return _infomap.InfoNode_replaceWithChildren(self)

    def replaceWithChildrenDebug(self):
        return _infomap.InfoNode_replaceWithChildrenDebug(self)

    def replaceChildrenWithGrandChildren(self):
        return _infomap.InfoNode_replaceChildrenWithGrandChildren(self)

    def replaceChildrenWithGrandChildrenDebug(self):
        return _infomap.InfoNode_replaceChildrenWithGrandChildrenDebug(self)

    def remove(self, removeChildren):
        return _infomap.InfoNode_remove(self, removeChildren)

    def deleteChildren(self):
        return _infomap.InfoNode_deleteChildren(self)

    def addOutEdge(self, target, weight, flow=0.0):
        return _infomap.InfoNode_addOutEdge(self, target, weight, flow)


    @property
    def node_id(self):
    	"""Get the physical node id.

    	Returns
    	-------
    	int
    		The node id
    	"""
    	return self.physicalId

    @property
    def state_id(self):
    	"""Get the state id of the node.

    	Returns
    	-------
    	int
    		The state id
    	"""
    	return self.stateId

    @property
    def flow(self):
    	"""Get the flow of the node.

    	Returns
    	-------
    	float
    		The flow
    	"""
    	return self.data.flow

    @property
    def layer_id(self):
    	"""Get the layer id of a multilayer node.

    	Returns
    	-------
    	int
    		The layer id
    	"""
    	return self.layerId

    @property
    def child_degree(self):
    	"""The number of children.

    	Returns
    	-------
    	int
    		Number of children
    	"""
    	return self.childDegree()

    @property
    def is_leaf(self):
    	"""True if the node has no children.

    	Returns
    	-------
    	bool
    		Is leaf node
    	"""
    	return self.isLeaf()

    @property
    def is_leaf_module(self):
    	"""True if the node has children but no grandchildren.

    	Returns
    	-------
    	bool
    		Is leaf module
    	"""
    	return self.isLeafModule()

    @property
    def is_root(self):
    	"""True if the node has no parent.

    	Returns
    	-------
    	bool
    		Is root
    	"""
    	return self.isRoot()

    @property
    def meta_data(self):
    	"""Meta data (on first dimension if more).

    	Returns
    	-------
    	int
    		The meta data
    	"""
    	return self.getMetaData()

    def get_meta_data(self, dimension = 0):
    	"""Get meta data on a specific dimension.

    	Parameters
    	----------
    	dimension : int
    		The dimension (default 0)

    	Returns
    	-------
    	int
    		The meta data
    	"""
    	return self.getMetaData(dimension)


# Register InfoNode in _infomap:
_infomap.InfoNode_swigregister(InfoNode)

class deque_uint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _infomap.deque_uint_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _infomap.deque_uint___nonzero__(self)

    def __bool__(self):
        return _infomap.deque_uint___bool__(self)

    def __len__(self):
        return _infomap.deque_uint___len__(self)

    def __getslice__(self, i, j):
        return _infomap.deque_uint___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _infomap.deque_uint___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _infomap.deque_uint___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _infomap.deque_uint___delitem__(self, *args)

    def __getitem__(self, *args):
        return _infomap.deque_uint___getitem__(self, *args)

    def __setitem__(self, *args):
        return _infomap.deque_uint___setitem__(self, *args)

    def pop(self):
        return _infomap.deque_uint_pop(self)

    def append(self, x):
        return _infomap.deque_uint_append(self, x)

    def empty(self):
        return _infomap.deque_uint_empty(self)

    def size(self):
        return _infomap.deque_uint_size(self)

    def swap(self, v):
        return _infomap.deque_uint_swap(self, v)

    def begin(self):
        return _infomap.deque_uint_begin(self)

    def end(self):
        return _infomap.deque_uint_end(self)

    def rbegin(self):
        return _infomap.deque_uint_rbegin(self)

    def rend(self):
        return _infomap.deque_uint_rend(self)

    def clear(self):
        return _infomap.deque_uint_clear(self)

    def get_allocator(self):
        return _infomap.deque_uint_get_allocator(self)

    def pop_back(self):
        return _infomap.deque_uint_pop_back(self)

    def erase(self, *args):
        return _infomap.deque_uint_erase(self, *args)

    def __init__(self, *args):
        _infomap.deque_uint_swiginit(self, _infomap.new_deque_uint(*args))

    def push_back(self, x):
        return _infomap.deque_uint_push_back(self, x)

    def front(self):
        return _infomap.deque_uint_front(self)

    def back(self):
        return _infomap.deque_uint_back(self)

    def assign(self, n, x):
        return _infomap.deque_uint_assign(self, n, x)

    def resize(self, *args):
        return _infomap.deque_uint_resize(self, *args)

    def insert(self, *args):
        return _infomap.deque_uint_insert(self, *args)

    def pop_front(self):
        return _infomap.deque_uint_pop_front(self)

    def push_front(self, x):
        return _infomap.deque_uint_push_front(self, x)
    __swig_destroy__ = _infomap.delete_deque_uint

# Register deque_uint in _infomap:
_infomap.deque_uint_swigregister(deque_uint)

class InfomapIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapIterator_swiginit(self, _infomap.new_InfomapIterator(*args))
    __swig_destroy__ = _infomap.delete_InfomapIterator

    def current(self, *args):
        return _infomap.InfomapIterator_current(self, *args)

    def __ref__(self, *args):
        return _infomap.InfomapIterator___ref__(self, *args)

    def __deref__(self, *args):
        return _infomap.InfomapIterator___deref__(self, *args)

    def __eq__(self, other):
        return _infomap.InfomapIterator___eq__(self, other)

    def __ne__(self, other):
        return _infomap.InfomapIterator___ne__(self, other)

    def stepForward(self):
        return _infomap.InfomapIterator_stepForward(self)

    def path(self):
        return _infomap.InfomapIterator_path(self)

    def moduleIndex(self):
        return _infomap.InfomapIterator_moduleIndex(self)

    def moduleId(self):
        return _infomap.InfomapIterator_moduleId(self)

    def childIndex(self):
        return _infomap.InfomapIterator_childIndex(self)

    def depth(self):
        return _infomap.InfomapIterator_depth(self)

    def isEnd(self):
        return _infomap.InfomapIterator_isEnd(self)

    def __iter__(self):
    	self._firstYielded = False
    	return self

    def __next__(self):
    	if not self._firstYielded:
    		self._firstYielded = True
    	else:
    		self.stepForward()

    	if self.isEnd():
    		raise StopIteration

    	return self


    @property
    def module_id(self):
    	"""Get the module id of the node.

    	Returns
    	-------
    	int
    		The module id
    	"""
    	return self.moduleId()

    _path = path
    @property
    def path(self):
    	"""Get the path to the node in the tree.

    	Returns
    	-------
    	tuple of ints
    		The path
    	"""
    	return self._path()

    _depth = depth
    @property
    def depth(self):
    	"""Get the depth.

    	Returns
    	-------
    	int
    		The depth
    	"""
    	return self._depth()

    @property
    def child_index(self):
    	"""Get the child index.

    	Returns
    	-------
    	int
    		The child index
    	"""
    	return self.childIndex()

    # Forward to the node it currently points to
    def __getattr__(self, name):
    	return getattr(self.current(), name)


    data = property(_infomap.InfomapIterator_data_get, _infomap.InfomapIterator_data_set)
    index = property(_infomap.InfomapIterator_index_get, _infomap.InfomapIterator_index_set)
    stateId = property(_infomap.InfomapIterator_stateId_get, _infomap.InfomapIterator_stateId_set)
    physicalId = property(_infomap.InfomapIterator_physicalId_get, _infomap.InfomapIterator_physicalId_set)
    layerId = property(_infomap.InfomapIterator_layerId_get, _infomap.InfomapIterator_layerId_set)
    metaData = property(_infomap.InfomapIterator_metaData_get, _infomap.InfomapIterator_metaData_set)
    owner = property(_infomap.InfomapIterator_owner_get, _infomap.InfomapIterator_owner_set)
    parent = property(_infomap.InfomapIterator_parent_get, _infomap.InfomapIterator_parent_set)
    previous = property(_infomap.InfomapIterator_previous_get, _infomap.InfomapIterator_previous_set)
    next = property(_infomap.InfomapIterator_next_get, _infomap.InfomapIterator_next_set)
    firstChild = property(_infomap.InfomapIterator_firstChild_get, _infomap.InfomapIterator_firstChild_set)
    lastChild = property(_infomap.InfomapIterator_lastChild_get, _infomap.InfomapIterator_lastChild_set)
    collapsedFirstChild = property(_infomap.InfomapIterator_collapsedFirstChild_get, _infomap.InfomapIterator_collapsedFirstChild_set)
    collapsedLastChild = property(_infomap.InfomapIterator_collapsedLastChild_get, _infomap.InfomapIterator_collapsedLastChild_set)
    codelength = property(_infomap.InfomapIterator_codelength_get, _infomap.InfomapIterator_codelength_set)
    dirty = property(_infomap.InfomapIterator_dirty_get, _infomap.InfomapIterator_dirty_set)
    physicalNodes = property(_infomap.InfomapIterator_physicalNodes_get, _infomap.InfomapIterator_physicalNodes_set)
    metaCollection = property(_infomap.InfomapIterator_metaCollection_get, _infomap.InfomapIterator_metaCollection_set)
    stateNodes = property(_infomap.InfomapIterator_stateNodes_get, _infomap.InfomapIterator_stateNodes_set)

    def getMetaData(self, dimension=0):
        return _infomap.InfomapIterator_getMetaData(self, dimension)

    def getInfomap(self):
        return _infomap.InfomapIterator_getInfomap(self)

    def setInfomap(self, arg2):
        return _infomap.InfomapIterator_setInfomap(self, arg2)

    def getInfomapRoot(self, *args):
        return _infomap.InfomapIterator_getInfomapRoot(self, *args)

    def disposeInfomap(self):
        return _infomap.InfomapIterator_disposeInfomap(self)

    def numPhysicalNodes(self):
        return _infomap.InfomapIterator_numPhysicalNodes(self)

    def begin(self, *args):
        return _infomap.InfomapIterator_begin(self, *args)

    def end(self, *args):
        return _infomap.InfomapIterator_end(self, *args)

    def begin_child(self, *args):
        return _infomap.InfomapIterator_begin_child(self, *args)

    def end_child(self, *args):
        return _infomap.InfomapIterator_end_child(self, *args)

    def children(self, *args):
        return _infomap.InfomapIterator_children(self, *args)

    def infomap_children(self, *args):
        return _infomap.InfomapIterator_infomap_children(self, *args)

    def begin_post_depth_first(self):
        return _infomap.InfomapIterator_begin_post_depth_first(self)

    def begin_tree(self, *args):
        return _infomap.InfomapIterator_begin_tree(self, *args)

    def end_tree(self, *args):
        return _infomap.InfomapIterator_end_tree(self, *args)

    def infomapTree(self, *args):
        return _infomap.InfomapIterator_infomapTree(self, *args)

    def begin_outEdge(self):
        return _infomap.InfomapIterator_begin_outEdge(self)

    def end_outEdge(self):
        return _infomap.InfomapIterator_end_outEdge(self)

    def begin_inEdge(self):
        return _infomap.InfomapIterator_begin_inEdge(self)

    def end_inEdge(self):
        return _infomap.InfomapIterator_end_inEdge(self)

    def outEdges(self):
        return _infomap.InfomapIterator_outEdges(self)

    def inEdges(self):
        return _infomap.InfomapIterator_inEdges(self)

    def childDegree(self):
        return _infomap.InfomapIterator_childDegree(self)

    def isLeaf(self):
        return _infomap.InfomapIterator_isLeaf(self)

    def isLeafModule(self):
        return _infomap.InfomapIterator_isLeafModule(self)

    def isRoot(self):
        return _infomap.InfomapIterator_isRoot(self)

    def firstDepthBelow(self):
        return _infomap.InfomapIterator_firstDepthBelow(self)

    def numLeafMembers(self):
        return _infomap.InfomapIterator_numLeafMembers(self)

    def isDangling(self):
        return _infomap.InfomapIterator_isDangling(self)

    def outDegree(self):
        return _infomap.InfomapIterator_outDegree(self)

    def inDegree(self):
        return _infomap.InfomapIterator_inDegree(self)

    def degree(self):
        return _infomap.InfomapIterator_degree(self)

    def isFirst(self):
        return _infomap.InfomapIterator_isFirst(self)

    def isLast(self):
        return _infomap.InfomapIterator_isLast(self)

    def calculatePath(self):
        return _infomap.InfomapIterator_calculatePath(self)

    def infomapChildDegree(self):
        return _infomap.InfomapIterator_infomapChildDegree(self)

    def id(self):
        return _infomap.InfomapIterator_id(self)

    def initClean(self):
        return _infomap.InfomapIterator_initClean(self)

    def sortChildrenOnFlow(self, recurse=True):
        return _infomap.InfomapIterator_sortChildrenOnFlow(self, recurse)

    def collapseChildren(self):
        return _infomap.InfomapIterator_collapseChildren(self)

    def expandChildren(self):
        return _infomap.InfomapIterator_expandChildren(self)

    def setChildDegree(self, value):
        return _infomap.InfomapIterator_setChildDegree(self, value)

    def setNumLeafNodes(self, value):
        return _infomap.InfomapIterator_setNumLeafNodes(self, value)

    def addChild(self, child):
        return _infomap.InfomapIterator_addChild(self, child)

    def releaseChildren(self):
        return _infomap.InfomapIterator_releaseChildren(self)

    def replaceChildrenWithOneNode(self):
        return _infomap.InfomapIterator_replaceChildrenWithOneNode(self)

    def replaceWithChildren(self):
        return _infomap.InfomapIterator_replaceWithChildren(self)

    def replaceWithChildrenDebug(self):
        return _infomap.InfomapIterator_replaceWithChildrenDebug(self)

    def replaceChildrenWithGrandChildren(self):
        return _infomap.InfomapIterator_replaceChildrenWithGrandChildren(self)

    def replaceChildrenWithGrandChildrenDebug(self):
        return _infomap.InfomapIterator_replaceChildrenWithGrandChildrenDebug(self)

    def remove(self, removeChildren):
        return _infomap.InfomapIterator_remove(self, removeChildren)

    def deleteChildren(self):
        return _infomap.InfomapIterator_deleteChildren(self)

    def addOutEdge(self, target, weight, flow=0.0):
        return _infomap.InfomapIterator_addOutEdge(self, target, weight, flow)

# Register InfomapIterator in _infomap:
_infomap.InfomapIterator_swigregister(InfomapIterator)

class InfomapModuleIterator(InfomapIterator):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapModuleIterator_swiginit(self, _infomap.new_InfomapModuleIterator(*args))

    def current(self, *args):
        return _infomap.InfomapModuleIterator_current(self, *args)

    def path(self):
        return _infomap.InfomapModuleIterator_path(self)

    def childIndex(self):
        return _infomap.InfomapModuleIterator_childIndex(self)

    def depth(self):
        return _infomap.InfomapModuleIterator_depth(self)
    __swig_destroy__ = _infomap.delete_InfomapModuleIterator

# Register InfomapModuleIterator in _infomap:
_infomap.InfomapModuleIterator_swigregister(InfomapModuleIterator)

class InfomapLeafModuleIterator(InfomapIterator):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapLeafModuleIterator_swiginit(self, _infomap.new_InfomapLeafModuleIterator(*args))

    def init(self):
        return _infomap.InfomapLeafModuleIterator_init(self)

    def current(self, *args):
        return _infomap.InfomapLeafModuleIterator_current(self, *args)

    def path(self):
        return _infomap.InfomapLeafModuleIterator_path(self)

    def childIndex(self):
        return _infomap.InfomapLeafModuleIterator_childIndex(self)

    def depth(self):
        return _infomap.InfomapLeafModuleIterator_depth(self)

    def __iter__(self):
    	self._firstYielded = False
    	return self

    def __next__(self):
    	if not self._firstYielded:
    		self._firstYielded = True
    	else:
    		self.stepForward()

    	if self.isEnd():
    		raise StopIteration

    	return self

    @property
    def module_id(self):
    	"""Get the module id of the node.

    	Returns
    	-------
    	int
    		The module id
    	"""
    	return self.moduleId()

    _path = path
    @property
    def path(self):
    	"""Get the path to the node in the tree.

    	Returns
    	-------
    	tuple of ints
    		The path
    	"""
    	return self._path()

    _depth = depth
    @property
    def depth(self):
    	"""Get the depth.

    	Returns
    	-------
    	int
    		The depth
    	"""
    	return self._depth()

    @property
    def child_index(self):
    	"""Get the child index.

    	Returns
    	-------
    	int
    		The child index
    	"""
    	return self.childIndex()

    # Forward to the node it currently points to
    def __getattr__(self, name):
    	return getattr(self.current(), name)


    __swig_destroy__ = _infomap.delete_InfomapLeafModuleIterator

# Register InfomapLeafModuleIterator in _infomap:
_infomap.InfomapLeafModuleIterator_swigregister(InfomapLeafModuleIterator)

class InfomapLeafIterator(InfomapIterator):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapLeafIterator_swiginit(self, _infomap.new_InfomapLeafIterator(*args))

    def init(self):
        return _infomap.InfomapLeafIterator_init(self)

    def current(self, *args):
        return _infomap.InfomapLeafIterator_current(self, *args)

    def path(self):
        return _infomap.InfomapLeafIterator_path(self)

    def childIndex(self):
        return _infomap.InfomapLeafIterator_childIndex(self)

    def depth(self):
        return _infomap.InfomapLeafIterator_depth(self)

    def __iter__(self):
    	self._firstYielded = False
    	return self

    def __next__(self):
    	if not self._firstYielded:
    		self._firstYielded = True
    	else:
    		self.stepForward()

    	if self.isEnd():
    		raise StopIteration

    	return self


    @property
    def module_id(self):
    	"""Get the module id of the node.

    	Returns
    	-------
    	int
    		The module id
    	"""
    	return self.moduleId()

    _path = path
    @property
    def path(self):
    	"""Get the path to the node in the tree.

    	Returns
    	-------
    	tuple of ints
    		The path
    	"""
    	return self._path()

    _depth = depth
    @property
    def depth(self):
    	"""Get the depth.

    	Returns
    	-------
    	int
    		The depth
    	"""
    	return self._depth()

    @property
    def child_index(self):
    	"""Get the child index.

    	Returns
    	-------
    	int
    		The child index
    	"""
    	return self.childIndex()

    # Forward to the node it currently points to
    def __getattr__(self, name):
    	return getattr(self.current(), name)


    __swig_destroy__ = _infomap.delete_InfomapLeafIterator

# Register InfomapLeafIterator in _infomap:
_infomap.InfomapLeafIterator_swigregister(InfomapLeafIterator)

class InfomapIteratorPhysical(InfomapIterator):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapIteratorPhysical_swiginit(self, _infomap.new_InfomapIteratorPhysical(*args))

    def current(self, *args):
        return _infomap.InfomapIteratorPhysical_current(self, *args)

    def path(self):
        return _infomap.InfomapIteratorPhysical_path(self)

    def childIndex(self):
        return _infomap.InfomapIteratorPhysical_childIndex(self)

    def depth(self):
        return _infomap.InfomapIteratorPhysical_depth(self)

    def __iter__(self):
    	self._firstYielded = False
    	return self

    def __next__(self):
    	if not self._firstYielded:
    		self._firstYielded = True
    	else:
    		self.stepForward()

    	if self.isEnd():
    		raise StopIteration

    	return self


    @property
    def module_id(self):
    	"""Get the module id of the node.

    	Returns
    	-------
    	int
    		The module id
    	"""
    	return self.moduleId()

    _path = path
    @property
    def path(self):
    	"""Get the path to the node in the tree.

    	Returns
    	-------
    	tuple of ints
    		The path
    	"""
    	return self._path()

    _depth = depth
    @property
    def depth(self):
    	"""Get the depth.

    	Returns
    	-------
    	int
    		The depth
    	"""
    	return self._depth()

    @property
    def child_index(self):
    	"""Get the child index.

    	Returns
    	-------
    	int
    		The child index
    	"""
    	return self.childIndex()

    # Forward to the node it currently points to
    def __getattr__(self, name):
    	return getattr(self.current(), name)


    __swig_destroy__ = _infomap.delete_InfomapIteratorPhysical

# Register InfomapIteratorPhysical in _infomap:
_infomap.InfomapIteratorPhysical_swigregister(InfomapIteratorPhysical)

class InfomapLeafIteratorPhysical(InfomapIteratorPhysical):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapLeafIteratorPhysical_swiginit(self, _infomap.new_InfomapLeafIteratorPhysical(*args))

    def init(self):
        return _infomap.InfomapLeafIteratorPhysical_init(self)

    def current(self, *args):
        return _infomap.InfomapLeafIteratorPhysical_current(self, *args)

    def path(self):
        return _infomap.InfomapLeafIteratorPhysical_path(self)

    def childIndex(self):
        return _infomap.InfomapLeafIteratorPhysical_childIndex(self)

    def depth(self):
        return _infomap.InfomapLeafIteratorPhysical_depth(self)

    def __iter__(self):
    	self._firstYielded = False
    	return self

    def __next__(self):
    	if not self._firstYielded:
    		self._firstYielded = True
    	else:
    		self.stepForward()

    	if self.isEnd():
    		raise StopIteration

    	return self


    @property
    def module_id(self):
    	"""Get the module id of the node.

    	Returns
    	-------
    	int
    		The module id
    	"""
    	return self.moduleId()

    _path = path
    @property
    def path(self):
    	"""Get the path to the node in the tree.

    	Returns
    	-------
    	tuple of ints
    		The path
    	"""
    	return self._path()

    _depth = depth
    @property
    def depth(self):
    	"""Get the depth.

    	Returns
    	-------
    	int
    		The depth
    	"""
    	return self._depth()

    @property
    def child_index(self):
    	"""Get the child index.

    	Returns
    	-------
    	int
    		The child index
    	"""
    	return self.childIndex()

    # Forward to the node it currently points to
    def __getattr__(self, name):
    	return getattr(self.current(), name)


    __swig_destroy__ = _infomap.delete_InfomapLeafIteratorPhysical

# Register InfomapLeafIteratorPhysical in _infomap:
_infomap.InfomapLeafIteratorPhysical_swigregister(InfomapLeafIteratorPhysical)

class InfomapParentIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapParentIterator_swiginit(self, _infomap.new_InfomapParentIterator(*args))
    __swig_destroy__ = _infomap.delete_InfomapParentIterator

    def current(self, *args):
        return _infomap.InfomapParentIterator_current(self, *args)

    def __ref__(self, *args):
        return _infomap.InfomapParentIterator___ref__(self, *args)

    def __deref__(self, *args):
        return _infomap.InfomapParentIterator___deref__(self, *args)

    def __eq__(self, other):
        return _infomap.InfomapParentIterator___eq__(self, other)

    def __ne__(self, other):
        return _infomap.InfomapParentIterator___ne__(self, other)

    def stepForward(self):
        return _infomap.InfomapParentIterator_stepForward(self)

    def isEnd(self):
        return _infomap.InfomapParentIterator_isEnd(self)
    data = property(_infomap.InfomapParentIterator_data_get, _infomap.InfomapParentIterator_data_set)
    index = property(_infomap.InfomapParentIterator_index_get, _infomap.InfomapParentIterator_index_set)
    stateId = property(_infomap.InfomapParentIterator_stateId_get, _infomap.InfomapParentIterator_stateId_set)
    physicalId = property(_infomap.InfomapParentIterator_physicalId_get, _infomap.InfomapParentIterator_physicalId_set)
    layerId = property(_infomap.InfomapParentIterator_layerId_get, _infomap.InfomapParentIterator_layerId_set)
    metaData = property(_infomap.InfomapParentIterator_metaData_get, _infomap.InfomapParentIterator_metaData_set)
    owner = property(_infomap.InfomapParentIterator_owner_get, _infomap.InfomapParentIterator_owner_set)
    parent = property(_infomap.InfomapParentIterator_parent_get, _infomap.InfomapParentIterator_parent_set)
    previous = property(_infomap.InfomapParentIterator_previous_get, _infomap.InfomapParentIterator_previous_set)
    next = property(_infomap.InfomapParentIterator_next_get, _infomap.InfomapParentIterator_next_set)
    firstChild = property(_infomap.InfomapParentIterator_firstChild_get, _infomap.InfomapParentIterator_firstChild_set)
    lastChild = property(_infomap.InfomapParentIterator_lastChild_get, _infomap.InfomapParentIterator_lastChild_set)
    collapsedFirstChild = property(_infomap.InfomapParentIterator_collapsedFirstChild_get, _infomap.InfomapParentIterator_collapsedFirstChild_set)
    collapsedLastChild = property(_infomap.InfomapParentIterator_collapsedLastChild_get, _infomap.InfomapParentIterator_collapsedLastChild_set)
    codelength = property(_infomap.InfomapParentIterator_codelength_get, _infomap.InfomapParentIterator_codelength_set)
    dirty = property(_infomap.InfomapParentIterator_dirty_get, _infomap.InfomapParentIterator_dirty_set)
    physicalNodes = property(_infomap.InfomapParentIterator_physicalNodes_get, _infomap.InfomapParentIterator_physicalNodes_set)
    metaCollection = property(_infomap.InfomapParentIterator_metaCollection_get, _infomap.InfomapParentIterator_metaCollection_set)
    stateNodes = property(_infomap.InfomapParentIterator_stateNodes_get, _infomap.InfomapParentIterator_stateNodes_set)

    def getMetaData(self, dimension=0):
        return _infomap.InfomapParentIterator_getMetaData(self, dimension)

    def getInfomap(self):
        return _infomap.InfomapParentIterator_getInfomap(self)

    def setInfomap(self, arg2):
        return _infomap.InfomapParentIterator_setInfomap(self, arg2)

    def getInfomapRoot(self, *args):
        return _infomap.InfomapParentIterator_getInfomapRoot(self, *args)

    def disposeInfomap(self):
        return _infomap.InfomapParentIterator_disposeInfomap(self)

    def numPhysicalNodes(self):
        return _infomap.InfomapParentIterator_numPhysicalNodes(self)

    def begin(self, *args):
        return _infomap.InfomapParentIterator_begin(self, *args)

    def end(self, *args):
        return _infomap.InfomapParentIterator_end(self, *args)

    def begin_child(self, *args):
        return _infomap.InfomapParentIterator_begin_child(self, *args)

    def end_child(self, *args):
        return _infomap.InfomapParentIterator_end_child(self, *args)

    def children(self, *args):
        return _infomap.InfomapParentIterator_children(self, *args)

    def infomap_children(self, *args):
        return _infomap.InfomapParentIterator_infomap_children(self, *args)

    def begin_post_depth_first(self):
        return _infomap.InfomapParentIterator_begin_post_depth_first(self)

    def begin_tree(self, *args):
        return _infomap.InfomapParentIterator_begin_tree(self, *args)

    def end_tree(self, *args):
        return _infomap.InfomapParentIterator_end_tree(self, *args)

    def infomapTree(self, *args):
        return _infomap.InfomapParentIterator_infomapTree(self, *args)

    def begin_outEdge(self):
        return _infomap.InfomapParentIterator_begin_outEdge(self)

    def end_outEdge(self):
        return _infomap.InfomapParentIterator_end_outEdge(self)

    def begin_inEdge(self):
        return _infomap.InfomapParentIterator_begin_inEdge(self)

    def end_inEdge(self):
        return _infomap.InfomapParentIterator_end_inEdge(self)

    def outEdges(self):
        return _infomap.InfomapParentIterator_outEdges(self)

    def inEdges(self):
        return _infomap.InfomapParentIterator_inEdges(self)

    def childDegree(self):
        return _infomap.InfomapParentIterator_childDegree(self)

    def isLeaf(self):
        return _infomap.InfomapParentIterator_isLeaf(self)

    def isLeafModule(self):
        return _infomap.InfomapParentIterator_isLeafModule(self)

    def isRoot(self):
        return _infomap.InfomapParentIterator_isRoot(self)

    def depth(self):
        return _infomap.InfomapParentIterator_depth(self)

    def firstDepthBelow(self):
        return _infomap.InfomapParentIterator_firstDepthBelow(self)

    def numLeafMembers(self):
        return _infomap.InfomapParentIterator_numLeafMembers(self)

    def isDangling(self):
        return _infomap.InfomapParentIterator_isDangling(self)

    def outDegree(self):
        return _infomap.InfomapParentIterator_outDegree(self)

    def inDegree(self):
        return _infomap.InfomapParentIterator_inDegree(self)

    def degree(self):
        return _infomap.InfomapParentIterator_degree(self)

    def isFirst(self):
        return _infomap.InfomapParentIterator_isFirst(self)

    def isLast(self):
        return _infomap.InfomapParentIterator_isLast(self)

    def childIndex(self):
        return _infomap.InfomapParentIterator_childIndex(self)

    def calculatePath(self):
        return _infomap.InfomapParentIterator_calculatePath(self)

    def infomapChildDegree(self):
        return _infomap.InfomapParentIterator_infomapChildDegree(self)

    def id(self):
        return _infomap.InfomapParentIterator_id(self)

    def initClean(self):
        return _infomap.InfomapParentIterator_initClean(self)

    def sortChildrenOnFlow(self, recurse=True):
        return _infomap.InfomapParentIterator_sortChildrenOnFlow(self, recurse)

    def collapseChildren(self):
        return _infomap.InfomapParentIterator_collapseChildren(self)

    def expandChildren(self):
        return _infomap.InfomapParentIterator_expandChildren(self)

    def setChildDegree(self, value):
        return _infomap.InfomapParentIterator_setChildDegree(self, value)

    def setNumLeafNodes(self, value):
        return _infomap.InfomapParentIterator_setNumLeafNodes(self, value)

    def addChild(self, child):
        return _infomap.InfomapParentIterator_addChild(self, child)

    def releaseChildren(self):
        return _infomap.InfomapParentIterator_releaseChildren(self)

    def replaceChildrenWithOneNode(self):
        return _infomap.InfomapParentIterator_replaceChildrenWithOneNode(self)

    def replaceWithChildren(self):
        return _infomap.InfomapParentIterator_replaceWithChildren(self)

    def replaceWithChildrenDebug(self):
        return _infomap.InfomapParentIterator_replaceWithChildrenDebug(self)

    def replaceChildrenWithGrandChildren(self):
        return _infomap.InfomapParentIterator_replaceChildrenWithGrandChildren(self)

    def replaceChildrenWithGrandChildrenDebug(self):
        return _infomap.InfomapParentIterator_replaceChildrenWithGrandChildrenDebug(self)

    def remove(self, removeChildren):
        return _infomap.InfomapParentIterator_remove(self, removeChildren)

    def deleteChildren(self):
        return _infomap.InfomapParentIterator_deleteChildren(self)

    def addOutEdge(self, target, weight, flow=0.0):
        return _infomap.InfomapParentIterator_addOutEdge(self, target, weight, flow)

# Register InfomapParentIterator in _infomap:
_infomap.InfomapParentIterator_swigregister(InfomapParentIterator)

class StateNetwork(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.StateNetwork_swiginit(self, _infomap.new_StateNetwork(*args))
    __swig_destroy__ = _infomap.delete_StateNetwork

    def setConfig(self, config):
        return _infomap.StateNetwork_setConfig(self, config)

    def getConfig(self):
        return _infomap.StateNetwork_getConfig(self)

    def addStateNode(self, *args):
        return _infomap.StateNetwork_addStateNode(self, *args)

    def addNode(self, *args):
        return _infomap.StateNetwork_addNode(self, *args)

    def addPhysicalNode(self, *args):
        return _infomap.StateNetwork_addPhysicalNode(self, *args)

    def addName(self, id, arg3):
        return _infomap.StateNetwork_addName(self, id, arg3)

    def addLink(self, *args):
        return _infomap.StateNetwork_addLink(self, *args)

    def removeLink(self, sourceId, targetId):
        return _infomap.StateNetwork_removeLink(self, sourceId, targetId)

    def undirectedToDirected(self):
        return _infomap.StateNetwork_undirectedToDirected(self)

    def calculateFlow(self):
        return _infomap.StateNetwork_calculateFlow(self)

    def clear(self):
        return _infomap.StateNetwork_clear(self)

    def clearLinks(self):
        return _infomap.StateNetwork_clearLinks(self)

    def nodes(self):
        return _infomap.StateNetwork_nodes(self)

    def numNodes(self):
        return _infomap.StateNetwork_numNodes(self)

    def numPhysicalNodes(self):
        return _infomap.StateNetwork_numPhysicalNodes(self)

    def nodeLinkMap(self, *args):
        return _infomap.StateNetwork_nodeLinkMap(self, *args)

    def numLinks(self):
        return _infomap.StateNetwork_numLinks(self)

    def sumLinkWeight(self):
        return _infomap.StateNetwork_sumLinkWeight(self)

    def sumSelfLinkWeight(self):
        return _infomap.StateNetwork_sumSelfLinkWeight(self)

    def outWeights(self):
        return _infomap.StateNetwork_outWeights(self)

    def names(self, *args):
        return _infomap.StateNetwork_names(self, *args)

    def haveDirectedInput(self):
        return _infomap.StateNetwork_haveDirectedInput(self)

    def haveMemoryInput(self):
        return _infomap.StateNetwork_haveMemoryInput(self)

    def isBipartite(self):
        return _infomap.StateNetwork_isBipartite(self)

    def bipartiteStartId(self):
        return _infomap.StateNetwork_bipartiteStartId(self)

    def setBipartiteStartId(self, value):
        return _infomap.StateNetwork_setBipartiteStartId(self, value)

    def writeStateNetwork(self, filename):
        return _infomap.StateNetwork_writeStateNetwork(self, filename)

    def writePajekNetwork(self, filename):
        return _infomap.StateNetwork_writePajekNetwork(self, filename)

# Register StateNetwork in _infomap:
_infomap.StateNetwork_swigregister(StateNetwork)

class Network(StateNetwork):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.Network_swiginit(self, _infomap.new_Network(*args))
    __swig_destroy__ = _infomap.delete_Network

    def clear(self):
        return _infomap.Network_clear(self)

    def readInputData(self, *args):
        return _infomap.Network_readInputData(self, *args)

    def readMetaData(self, filename):
        return _infomap.Network_readMetaData(self, filename)

    def numMetaDataColumns(self):
        return _infomap.Network_numMetaDataColumns(self)

    def metaData(self):
        return _infomap.Network_metaData(self)

    def isMultilayerNetwork(self):
        return _infomap.Network_isMultilayerNetwork(self)

    def generateStateNetworkFromMultilayer(self):
        return _infomap.Network_generateStateNetworkFromMultilayer(self)

    def generateStateNetworkFromMultilayerWithInterLinks(self):
        return _infomap.Network_generateStateNetworkFromMultilayerWithInterLinks(self)

    def generateStateNetworkFromMultilayerWithSimulatedInterLinks(self):
        return _infomap.Network_generateStateNetworkFromMultilayerWithSimulatedInterLinks(self)

    def simulateInterLayerLinks(self):
        return _infomap.Network_simulateInterLayerLinks(self)

    def addMultilayerLink(self, layer1, n1, layer2, n2, weight):
        return _infomap.Network_addMultilayerLink(self, layer1, n1, layer2, n2, weight)

    def addMultilayerIntraLink(self, layer, n1, n2, weight):
        return _infomap.Network_addMultilayerIntraLink(self, layer, n1, n2, weight)

    def addMultilayerInterLink(self, layer1, n, layer2, interWeight):
        return _infomap.Network_addMultilayerInterLink(self, layer1, n, layer2, interWeight)

    def addMetaData(self, *args):
        return _infomap.Network_addMetaData(self, *args)

# Register Network in _infomap:
_infomap.Network_swigregister(Network)

class LayerNode(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    layer = property(_infomap.LayerNode_layer_get, _infomap.LayerNode_layer_set)
    node = property(_infomap.LayerNode_node_get, _infomap.LayerNode_node_set)

    def __init__(self, layer=0, node=0):
        _infomap.LayerNode_swiginit(self, _infomap.new_LayerNode(layer, node))

    def __lt__(self, other):
        return _infomap.LayerNode___lt__(self, other)
    __swig_destroy__ = _infomap.delete_LayerNode

# Register LayerNode in _infomap:
_infomap.LayerNode_swigregister(LayerNode)

class Bigram(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    first = property(_infomap.Bigram_first_get, _infomap.Bigram_first_set)
    second = property(_infomap.Bigram_second_get, _infomap.Bigram_second_set)

    def __init__(self, first=0, second=0):
        _infomap.Bigram_swiginit(self, _infomap.new_Bigram(first, second))

    def __lt__(self, other):
        return _infomap.Bigram___lt__(self, other)
    __swig_destroy__ = _infomap.delete_Bigram

# Register Bigram in _infomap:
_infomap.Bigram_swigregister(Bigram)

class BipartiteLink(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    featureNode = property(_infomap.BipartiteLink_featureNode_get, _infomap.BipartiteLink_featureNode_set)
    node = property(_infomap.BipartiteLink_node_get, _infomap.BipartiteLink_node_set)
    swapOrder = property(_infomap.BipartiteLink_swapOrder_get, _infomap.BipartiteLink_swapOrder_set)

    def __init__(self, featureNode=0, node=0, swapOrder=False):
        _infomap.BipartiteLink_swiginit(self, _infomap.new_BipartiteLink(featureNode, node, swapOrder))

    def __lt__(self, other):
        return _infomap.BipartiteLink___lt__(self, other)
    __swig_destroy__ = _infomap.delete_BipartiteLink

# Register BipartiteLink in _infomap:
_infomap.BipartiteLink_swigregister(BipartiteLink)

class Weight(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    weight = property(_infomap.Weight_weight_get, _infomap.Weight_weight_set)

    def __init__(self, weight=0):
        _infomap.Weight_swiginit(self, _infomap.new_Weight(weight))

    def __iadd__(self, w):
        return _infomap.Weight___iadd__(self, w)
    __swig_destroy__ = _infomap.delete_Weight

# Register Weight in _infomap:
_infomap.Weight_swigregister(Weight)

class Triple(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.Triple_swiginit(self, _infomap.new_Triple(*args))
    __swig_destroy__ = _infomap.delete_Triple

    def __lt__(self, other):
        return _infomap.Triple___lt__(self, other)

    def __eq__(self, other):
        return _infomap.Triple___eq__(self, other)
    n1 = property(_infomap.Triple_n1_get, _infomap.Triple_n1_set)
    n2 = property(_infomap.Triple_n2_get, _infomap.Triple_n2_set)
    n3 = property(_infomap.Triple_n3_get, _infomap.Triple_n3_set)

# Register Triple in _infomap:
_infomap.Triple_swigregister(Triple)

class map_uint_uint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _infomap.map_uint_uint_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _infomap.map_uint_uint___nonzero__(self)

    def __bool__(self):
        return _infomap.map_uint_uint___bool__(self)

    def __len__(self):
        return _infomap.map_uint_uint___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _infomap.map_uint_uint___getitem__(self, key)

    def __delitem__(self, key):
        return _infomap.map_uint_uint___delitem__(self, key)

    def has_key(self, key):
        return _infomap.map_uint_uint_has_key(self, key)

    def keys(self):
        return _infomap.map_uint_uint_keys(self)

    def values(self):
        return _infomap.map_uint_uint_values(self)

    def items(self):
        return _infomap.map_uint_uint_items(self)

    def __contains__(self, key):
        return _infomap.map_uint_uint___contains__(self, key)

    def key_iterator(self):
        return _infomap.map_uint_uint_key_iterator(self)

    def value_iterator(self):
        return _infomap.map_uint_uint_value_iterator(self)

    def __setitem__(self, *args):
        return _infomap.map_uint_uint___setitem__(self, *args)

    def asdict(self):
        return _infomap.map_uint_uint_asdict(self)

    def __init__(self, *args):
        _infomap.map_uint_uint_swiginit(self, _infomap.new_map_uint_uint(*args))

    def empty(self):
        return _infomap.map_uint_uint_empty(self)

    def size(self):
        return _infomap.map_uint_uint_size(self)

    def swap(self, v):
        return _infomap.map_uint_uint_swap(self, v)

    def begin(self):
        return _infomap.map_uint_uint_begin(self)

    def end(self):
        return _infomap.map_uint_uint_end(self)

    def rbegin(self):
        return _infomap.map_uint_uint_rbegin(self)

    def rend(self):
        return _infomap.map_uint_uint_rend(self)

    def clear(self):
        return _infomap.map_uint_uint_clear(self)

    def get_allocator(self):
        return _infomap.map_uint_uint_get_allocator(self)

    def count(self, x):
        return _infomap.map_uint_uint_count(self, x)

    def erase(self, *args):
        return _infomap.map_uint_uint_erase(self, *args)

    def find(self, x):
        return _infomap.map_uint_uint_find(self, x)

    def lower_bound(self, x):
        return _infomap.map_uint_uint_lower_bound(self, x)

    def upper_bound(self, x):
        return _infomap.map_uint_uint_upper_bound(self, x)
    __swig_destroy__ = _infomap.delete_map_uint_uint

# Register map_uint_uint in _infomap:
_infomap.map_uint_uint_swigregister(map_uint_uint)

class InfomapConfigInfomapBase(Config):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapConfigInfomapBase_swiginit(self, _infomap.new_InfomapConfigInfomapBase(*args))
    __swig_destroy__ = _infomap.delete_InfomapConfigInfomapBase

    def getConfig(self, *args):
        return _infomap.InfomapConfigInfomapBase_getConfig(self, *args)

    def setConfig(self, conf):
        return _infomap.InfomapConfigInfomapBase_setConfig(self, conf)

    def setNonMainConfig(self, conf):
        return _infomap.InfomapConfigInfomapBase_setNonMainConfig(self, conf)

    def setNumTrials(self, N):
        return _infomap.InfomapConfigInfomapBase_setNumTrials(self, N)

    def setVerbosity(self, level):
        return _infomap.InfomapConfigInfomapBase_setVerbosity(self, level)

    def setTwoLevel(self, value):
        return _infomap.InfomapConfigInfomapBase_setTwoLevel(self, value)

    def setTuneIterationLimit(self, value):
        return _infomap.InfomapConfigInfomapBase_setTuneIterationLimit(self, value)

    def setFastHierarchicalSolution(self, level):
        return _infomap.InfomapConfigInfomapBase_setFastHierarchicalSolution(self, level)

    def setOnlySuperModules(self, value):
        return _infomap.InfomapConfigInfomapBase_setOnlySuperModules(self, value)

    def setNoCoarseTune(self, value):
        return _infomap.InfomapConfigInfomapBase_setNoCoarseTune(self, value)

    def setNoInfomap(self, value=True):
        return _infomap.InfomapConfigInfomapBase_setNoInfomap(self, value)

    def setMarkovTime(self, codeRate):
        return _infomap.InfomapConfigInfomapBase_setMarkovTime(self, codeRate)

    def reseed(self, seed):
        return _infomap.InfomapConfigInfomapBase_reseed(self, seed)

# Register InfomapConfigInfomapBase in _infomap:
_infomap.InfomapConfigInfomapBase_swigregister(InfomapConfigInfomapBase)

class InfomapBase(InfomapConfigInfomapBase):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _infomap.delete_InfomapBase

    def network(self, *args):
        return _infomap.InfomapBase_network(self, *args)

    def root(self, *args):
        return _infomap.InfomapBase_root(self, *args)

    def iterTree(self, maxClusterLevel=1):
        return _infomap.InfomapBase_iterTree(self, maxClusterLevel)

    def iterTreePhysical(self, maxClusterLevel=1):
        return _infomap.InfomapBase_iterTreePhysical(self, maxClusterLevel)

    def iterModules(self, maxClusterLevel=1):
        return _infomap.InfomapBase_iterModules(self, maxClusterLevel)

    def iterLeafModules(self, maxClusterLevel=1):
        return _infomap.InfomapBase_iterLeafModules(self, maxClusterLevel)

    def iterLeafNodes(self, maxClusterLevel=1):
        return _infomap.InfomapBase_iterLeafNodes(self, maxClusterLevel)

    def iterLeafNodesPhysical(self, maxClusterLevel=1):
        return _infomap.InfomapBase_iterLeafNodesPhysical(self, maxClusterLevel)

    def begin(self, maxClusterLevel=1):
        return _infomap.InfomapBase_begin(self, maxClusterLevel)

    def end(self):
        return _infomap.InfomapBase_end(self)

    def numLeafNodes(self):
        return _infomap.InfomapBase_numLeafNodes(self)

    def leafNodes(self):
        return _infomap.InfomapBase_leafNodes(self)

    def numTopModules(self):
        return _infomap.InfomapBase_numTopModules(self)

    def numActiveModules(self):
        return _infomap.InfomapBase_numActiveModules(self)

    def numNonTrivialTopModules(self):
        return _infomap.InfomapBase_numNonTrivialTopModules(self)

    def haveModules(self):
        return _infomap.InfomapBase_haveModules(self)

    def haveNonTrivialModules(self):
        return _infomap.InfomapBase_haveNonTrivialModules(self)

    def numLevels(self):
        return _infomap.InfomapBase_numLevels(self)

    def maxTreeDepth(self):
        return _infomap.InfomapBase_maxTreeDepth(self)

    def getCodelength(self):
        return _infomap.InfomapBase_getCodelength(self)

    def getMetaCodelength(self, unweighted=False):
        return _infomap.InfomapBase_getMetaCodelength(self, unweighted)

    def codelength(self):
        return _infomap.InfomapBase_codelength(self)

    def getIndexCodelength(self):
        return _infomap.InfomapBase_getIndexCodelength(self)

    def getModuleCodelength(self):
        return _infomap.InfomapBase_getModuleCodelength(self)

    def getHierarchicalCodelength(self):
        return _infomap.InfomapBase_getHierarchicalCodelength(self)

    def getOneLevelCodelength(self):
        return _infomap.InfomapBase_getOneLevelCodelength(self)

    def getRelativeCodelengthSavings(self):
        return _infomap.InfomapBase_getRelativeCodelengthSavings(self)

    def isFullNetwork(self):
        return _infomap.InfomapBase_isFullNetwork(self)

    def isFirstLoop(self):
        return _infomap.InfomapBase_isFirstLoop(self)

    def getNewInfomapInstance(self):
        return _infomap.InfomapBase_getNewInfomapInstance(self)

    def getNewInfomapInstanceWithoutMemory(self):
        return _infomap.InfomapBase_getNewInfomapInstanceWithoutMemory(self)

    def getSubInfomap(self, node):
        return _infomap.InfomapBase_getSubInfomap(self, node)

    def getSuperInfomap(self, node):
        return _infomap.InfomapBase_getSuperInfomap(self, node)

    def setIsMain(self, isMain):
        return _infomap.InfomapBase_setIsMain(self, isMain)

    def setSubLevel(self, level):
        return _infomap.InfomapBase_setSubLevel(self, level)

    def isTopLevel(self):
        return _infomap.InfomapBase_isTopLevel(self)

    def isSuperLevelOnTopLevel(self):
        return _infomap.InfomapBase_isSuperLevelOnTopLevel(self)

    def isMainInfomap(self):
        return _infomap.InfomapBase_isMainInfomap(self)

    def haveMemory(self):
        return _infomap.InfomapBase_haveMemory(self)

    def haveHardPartition(self):
        return _infomap.InfomapBase_haveHardPartition(self)

    def activeNetwork(self):
        return _infomap.InfomapBase_activeNetwork(self)

    def toString(self, out):
        return _infomap.InfomapBase_toString(self, out)

    def getInitialPartition(self):
        return _infomap.InfomapBase_getInitialPartition(self)

    def calcEntropyRate(self):
        return _infomap.InfomapBase_calcEntropyRate(self)

    def setInitialPartition(self, moduleIds):
        return _infomap.InfomapBase_setInitialPartition(self, moduleIds)

    def run(self, *args):
        return _infomap.InfomapBase_run(self, *args)

    def generateSubNetwork(self, *args):
        return _infomap.InfomapBase_generateSubNetwork(self, *args)

    def initMetaData(self, metaDataFile):
        return _infomap.InfomapBase_initMetaData(self, metaDataFile)

    def initTree(self, tree):
        return _infomap.InfomapBase_initTree(self, tree)

    def init(self):
        return _infomap.InfomapBase_init(self)

    def runPartition(self):
        return _infomap.InfomapBase_runPartition(self)

    def restoreHardPartition(self):
        return _infomap.InfomapBase_restoreHardPartition(self)

    def sortTreeOnFlow(self):
        return _infomap.InfomapBase_sortTreeOnFlow(self)

    def writeResult(self):
        return _infomap.InfomapBase_writeResult(self)

    def hierarchicalPartition(self):
        return _infomap.InfomapBase_hierarchicalPartition(self)

    def partition(self):
        return _infomap.InfomapBase_partition(self)

    def initEnterExitFlow(self):
        return _infomap.InfomapBase_initEnterExitFlow(self)

    def aggregateFlowValuesFromLeafToRoot(self):
        return _infomap.InfomapBase_aggregateFlowValuesFromLeafToRoot(self)

    def initNetwork(self, *args):
        return _infomap.InfomapBase_initNetwork(self, *args)

    def initSuperNetwork(self):
        return _infomap.InfomapBase_initSuperNetwork(self)

    def calcCodelength(self, parent):
        return _infomap.InfomapBase_calcCodelength(self, parent)

    def calcCodelengthOnTree(self, includeRoot=True):
        return _infomap.InfomapBase_calcCodelengthOnTree(self, includeRoot)

    def setActiveNetworkFromLeafs(self):
        return _infomap.InfomapBase_setActiveNetworkFromLeafs(self)

    def setActiveNetworkFromChildrenOfRoot(self):
        return _infomap.InfomapBase_setActiveNetworkFromChildrenOfRoot(self)

    def initPartition(self, *args):
        return _infomap.InfomapBase_initPartition(self, *args)

    def findTopModulesRepeatedly(self, maxLevels):
        return _infomap.InfomapBase_findTopModulesRepeatedly(self, maxLevels)

    def fineTune(self):
        return _infomap.InfomapBase_fineTune(self)

    def coarseTune(self):
        return _infomap.InfomapBase_coarseTune(self)

    def optimizeActiveNetwork(self):
        return _infomap.InfomapBase_optimizeActiveNetwork(self)

    def moveActiveNodesToPredifinedModules(self, modules):
        return _infomap.InfomapBase_moveActiveNodesToPredifinedModules(self, modules)

    def consolidateModules(self, replaceExistingModules=True):
        return _infomap.InfomapBase_consolidateModules(self, replaceExistingModules)

    def calculateNumNonTrivialTopModules(self):
        return _infomap.InfomapBase_calculateNumNonTrivialTopModules(self)

    def calculateMaxDepth(self):
        return _infomap.InfomapBase_calculateMaxDepth(self)

    def restoreConsolidatedOptimizationPointIfNoImprovement(self, forceRestore=False):
        return _infomap.InfomapBase_restoreConsolidatedOptimizationPointIfNoImprovement(self, forceRestore)

    def findHierarchicalSuperModules(self, *args):
        return _infomap.InfomapBase_findHierarchicalSuperModules(self, *args)

    def findHierarchicalSuperModulesFast(self, *args):
        return _infomap.InfomapBase_findHierarchicalSuperModulesFast(self, *args)

    def transformNodeFlowToEnterFlow(self, parent):
        return _infomap.InfomapBase_transformNodeFlowToEnterFlow(self, parent)

    def resetFlowOnModules(self):
        return _infomap.InfomapBase_resetFlowOnModules(self)

    def removeModules(self):
        return _infomap.InfomapBase_removeModules(self)

    def removeSubModules(self, recalculateCodelengthOnTree):
        return _infomap.InfomapBase_removeSubModules(self, recalculateCodelengthOnTree)

    def recursivePartition(self):
        return _infomap.InfomapBase_recursivePartition(self)

    def queueTopModules(self, partitionQueue):
        return _infomap.InfomapBase_queueTopModules(self, partitionQueue)

    def queueLeafModules(self, partitionQueue):
        return _infomap.InfomapBase_queueLeafModules(self, partitionQueue)

    def processPartitionQueue(self, queue, nextLevel):
        return _infomap.InfomapBase_processPartitionQueue(self, queue, nextLevel)

    def getOutputFileHeader(self):
        return _infomap.InfomapBase_getOutputFileHeader(self)

    def writeTree(self, *args):
        return _infomap.InfomapBase_writeTree(self, *args)

    def writeFlowTree(self, *args):
        return _infomap.InfomapBase_writeFlowTree(self, *args)

    def writeClu(self, *args):
        return _infomap.InfomapBase_writeClu(self, *args)

    def writeMap(self, *args):
        return _infomap.InfomapBase_writeMap(self, *args)

    def printPerLevelCodelength(self, out):
        return _infomap.InfomapBase_printPerLevelCodelength(self, out)

    def aggregatePerLevelCodelength(self, *args):
        return _infomap.InfomapBase_aggregatePerLevelCodelength(self, *args)

    def printDebug(self):
        return _infomap.InfomapBase_printDebug(self)

    def printRSS(self, minVerboseLevel=0):
        return _infomap.InfomapBase_printRSS(self, minVerboseLevel)

# Register InfomapBase in _infomap:
_infomap.InfomapBase_swigregister(InfomapBase)

class PerLevelStat(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        _infomap.PerLevelStat_swiginit(self, _infomap.new_PerLevelStat())

    def codelength(self):
        return _infomap.PerLevelStat_codelength(self)

    def numNodes(self):
        return _infomap.PerLevelStat_numNodes(self)
    numModules = property(_infomap.PerLevelStat_numModules_get, _infomap.PerLevelStat_numModules_set)
    numLeafNodes = property(_infomap.PerLevelStat_numLeafNodes_get, _infomap.PerLevelStat_numLeafNodes_set)
    indexLength = property(_infomap.PerLevelStat_indexLength_get, _infomap.PerLevelStat_indexLength_set)
    leafLength = property(_infomap.PerLevelStat_leafLength_get, _infomap.PerLevelStat_leafLength_set)
    __swig_destroy__ = _infomap.delete_PerLevelStat

# Register PerLevelStat in _infomap:
_infomap.PerLevelStat_swigregister(PerLevelStat)

class PerIterationStats(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self):
        _infomap.PerIterationStats_swiginit(self, _infomap.new_PerIterationStats())
    iterationIndex = property(_infomap.PerIterationStats_iterationIndex_get, _infomap.PerIterationStats_iterationIndex_set)
    numTopModules = property(_infomap.PerIterationStats_numTopModules_get, _infomap.PerIterationStats_numTopModules_set)
    numBottomModules = property(_infomap.PerIterationStats_numBottomModules_get, _infomap.PerIterationStats_numBottomModules_set)
    topPerplexity = property(_infomap.PerIterationStats_topPerplexity_get, _infomap.PerIterationStats_topPerplexity_set)
    bottomPerplexity = property(_infomap.PerIterationStats_bottomPerplexity_get, _infomap.PerIterationStats_bottomPerplexity_set)
    topOverlap = property(_infomap.PerIterationStats_topOverlap_get, _infomap.PerIterationStats_topOverlap_set)
    bottomOverlap = property(_infomap.PerIterationStats_bottomOverlap_get, _infomap.PerIterationStats_bottomOverlap_set)
    codelength = property(_infomap.PerIterationStats_codelength_get, _infomap.PerIterationStats_codelength_set)
    maxDepth = property(_infomap.PerIterationStats_maxDepth_get, _infomap.PerIterationStats_maxDepth_set)
    weightedDepth = property(_infomap.PerIterationStats_weightedDepth_get, _infomap.PerIterationStats_weightedDepth_set)
    seconds = property(_infomap.PerIterationStats_seconds_get, _infomap.PerIterationStats_seconds_set)
    isMinimum = property(_infomap.PerIterationStats_isMinimum_get, _infomap.PerIterationStats_isMinimum_set)
    __swig_destroy__ = _infomap.delete_PerIterationStats

# Register PerIterationStats in _infomap:
_infomap.PerIterationStats_swigregister(PerIterationStats)

class MapEquation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.MapEquation_swiginit(self, _infomap.new_MapEquation(*args))
    __swig_destroy__ = _infomap.delete_MapEquation

    @staticmethod
    def haveMemory():
        return _infomap.MapEquation_haveMemory()

    def getIndexCodelength(self):
        return _infomap.MapEquation_getIndexCodelength(self)

    def getModuleCodelength(self):
        return _infomap.MapEquation_getModuleCodelength(self)

    def getCodelength(self):
        return _infomap.MapEquation_getCodelength(self)

    def _print(self, arg2):
        return _infomap.MapEquation__print(self, arg2)

    def init(self, config):
        return _infomap.MapEquation_init(self, config)

    def initNetwork(self, root):
        return _infomap.MapEquation_initNetwork(self, root)

    def initSuperNetwork(self, root):
        return _infomap.MapEquation_initSuperNetwork(self, root)

    def initSubNetwork(self, root):
        return _infomap.MapEquation_initSubNetwork(self, root)

    def initPartition(self, nodes):
        return _infomap.MapEquation_initPartition(self, nodes)

    def calcCodelength(self, parent):
        return _infomap.MapEquation_calcCodelength(self, parent)

    def addMemoryContributions(self, *args):
        return _infomap.MapEquation_addMemoryContributions(self, *args)

    def getDeltaCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers):
        return _infomap.MapEquation_getDeltaCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers)

    def updateCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers):
        return _infomap.MapEquation_updateCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers)

    def consolidateModules(self, modules):
        return _infomap.MapEquation_consolidateModules(self, modules)

    def printDebug(self):
        return _infomap.MapEquation_printDebug(self)
    codelength = property(_infomap.MapEquation_codelength_get, _infomap.MapEquation_codelength_set)
    indexCodelength = property(_infomap.MapEquation_indexCodelength_get, _infomap.MapEquation_indexCodelength_set)
    moduleCodelength = property(_infomap.MapEquation_moduleCodelength_get, _infomap.MapEquation_moduleCodelength_set)

# Register MapEquation in _infomap:
_infomap.MapEquation_swigregister(MapEquation)

def MapEquation_haveMemory():
    return _infomap.MapEquation_haveMemory()

class MemMapEquation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.MemMapEquation_swiginit(self, _infomap.new_MemMapEquation(*args))
    __swig_destroy__ = _infomap.delete_MemMapEquation

    @staticmethod
    def haveMemory():
        return _infomap.MemMapEquation_haveMemory()

    def getIndexCodelength(self):
        return _infomap.MemMapEquation_getIndexCodelength(self)

    def getModuleCodelength(self):
        return _infomap.MemMapEquation_getModuleCodelength(self)

    def getCodelength(self):
        return _infomap.MemMapEquation_getCodelength(self)

    def _print(self, out):
        return _infomap.MemMapEquation__print(self, out)

    def init(self, config):
        return _infomap.MemMapEquation_init(self, config)

    def initNetwork(self, root):
        return _infomap.MemMapEquation_initNetwork(self, root)

    def initSuperNetwork(self, root):
        return _infomap.MemMapEquation_initSuperNetwork(self, root)

    def initSubNetwork(self, root):
        return _infomap.MemMapEquation_initSubNetwork(self, root)

    def initPartition(self, nodes):
        return _infomap.MemMapEquation_initPartition(self, nodes)

    def calcCodelength(self, parent):
        return _infomap.MemMapEquation_calcCodelength(self, parent)

    def addMemoryContributions(self, current, oldModuleDelta, moduleDeltaFlow):
        return _infomap.MemMapEquation_addMemoryContributions(self, current, oldModuleDelta, moduleDeltaFlow)

    def getDeltaCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers):
        return _infomap.MemMapEquation_getDeltaCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers)

    def updateCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers):
        return _infomap.MemMapEquation_updateCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers)

    def consolidateModules(self, modules):
        return _infomap.MemMapEquation_consolidateModules(self, modules)

    def printDebug(self):
        return _infomap.MemMapEquation_printDebug(self)
    codelength = property(_infomap.MemMapEquation_codelength_get, _infomap.MemMapEquation_codelength_set)
    indexCodelength = property(_infomap.MemMapEquation_indexCodelength_get, _infomap.MemMapEquation_indexCodelength_set)
    moduleCodelength = property(_infomap.MemMapEquation_moduleCodelength_get, _infomap.MemMapEquation_moduleCodelength_set)

# Register MemMapEquation in _infomap:
_infomap.MemMapEquation_swigregister(MemMapEquation)

def MemMapEquation_haveMemory():
    return _infomap.MemMapEquation_haveMemory()

class MemNodeSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.MemNodeSet_swiginit(self, _infomap.new_MemNodeSet(*args))
    numMemNodes = property(_infomap.MemNodeSet_numMemNodes_get, _infomap.MemNodeSet_numMemNodes_set)
    sumFlow = property(_infomap.MemNodeSet_sumFlow_get, _infomap.MemNodeSet_sumFlow_set)
    __swig_destroy__ = _infomap.delete_MemNodeSet

# Register MemNodeSet in _infomap:
_infomap.MemNodeSet_swigregister(MemNodeSet)

class MetaMapEquation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.MetaMapEquation_swiginit(self, _infomap.new_MetaMapEquation(*args))
    __swig_destroy__ = _infomap.delete_MetaMapEquation

    @staticmethod
    def haveMemory():
        return _infomap.MetaMapEquation_haveMemory()

    def getIndexCodelength(self):
        return _infomap.MetaMapEquation_getIndexCodelength(self)

    def getModuleCodelength(self):
        return _infomap.MetaMapEquation_getModuleCodelength(self)

    def getCodelength(self):
        return _infomap.MetaMapEquation_getCodelength(self)

    def getMetaCodelength(self, unweighted=False):
        return _infomap.MetaMapEquation_getMetaCodelength(self, unweighted)

    def _print(self, out):
        return _infomap.MetaMapEquation__print(self, out)

    def init(self, config):
        return _infomap.MetaMapEquation_init(self, config)

    def initNetwork(self, root):
        return _infomap.MetaMapEquation_initNetwork(self, root)

    def initSuperNetwork(self, root):
        return _infomap.MetaMapEquation_initSuperNetwork(self, root)

    def initSubNetwork(self, root):
        return _infomap.MetaMapEquation_initSubNetwork(self, root)

    def initPartition(self, nodes):
        return _infomap.MetaMapEquation_initPartition(self, nodes)

    def calcCodelength(self, parent):
        return _infomap.MetaMapEquation_calcCodelength(self, parent)

    def addMemoryContributions(self, current, oldModuleDelta, moduleDeltaFlow):
        return _infomap.MetaMapEquation_addMemoryContributions(self, current, oldModuleDelta, moduleDeltaFlow)

    def getDeltaCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers):
        return _infomap.MetaMapEquation_getDeltaCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers)

    def updateCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers):
        return _infomap.MetaMapEquation_updateCodelengthOnMovingNode(self, current, oldModuleDelta, newModuleDelta, moduleFlowData, moduleMembers)

    def consolidateModules(self, modules):
        return _infomap.MetaMapEquation_consolidateModules(self, modules)

    def printDebug(self):
        return _infomap.MetaMapEquation_printDebug(self)
    codelength = property(_infomap.MetaMapEquation_codelength_get, _infomap.MetaMapEquation_codelength_set)
    indexCodelength = property(_infomap.MetaMapEquation_indexCodelength_get, _infomap.MetaMapEquation_indexCodelength_set)
    moduleCodelength = property(_infomap.MetaMapEquation_moduleCodelength_get, _infomap.MetaMapEquation_moduleCodelength_set)

# Register MetaMapEquation in _infomap:
_infomap.MetaMapEquation_swigregister(MetaMapEquation)

def MetaMapEquation_haveMemory():
    return _infomap.MetaMapEquation_haveMemory()

class InfomapCore(InfomapBase):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapCore_swiginit(self, _infomap.new_InfomapCore(*args))
    __swig_destroy__ = _infomap.delete_InfomapCore

    def toString(self, out):
        return _infomap.InfomapCore_toString(self, out)

    def getCodelength(self):
        return _infomap.InfomapCore_getCodelength(self)

    def getIndexCodelength(self):
        return _infomap.InfomapCore_getIndexCodelength(self)

    def getModuleCodelength(self):
        return _infomap.InfomapCore_getModuleCodelength(self)

    def getMetaCodelength(self, unweighted=False):
        return _infomap.InfomapCore_getMetaCodelength(self, unweighted)

# Register InfomapCore in _infomap:
_infomap.InfomapCore_swigregister(InfomapCore)

class map_uint_vector_uint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def iterator(self):
        return _infomap.map_uint_vector_uint_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _infomap.map_uint_vector_uint___nonzero__(self)

    def __bool__(self):
        return _infomap.map_uint_vector_uint___bool__(self)

    def __len__(self):
        return _infomap.map_uint_vector_uint___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _infomap.map_uint_vector_uint___getitem__(self, key)

    def __delitem__(self, key):
        return _infomap.map_uint_vector_uint___delitem__(self, key)

    def has_key(self, key):
        return _infomap.map_uint_vector_uint_has_key(self, key)

    def keys(self):
        return _infomap.map_uint_vector_uint_keys(self)

    def values(self):
        return _infomap.map_uint_vector_uint_values(self)

    def items(self):
        return _infomap.map_uint_vector_uint_items(self)

    def __contains__(self, key):
        return _infomap.map_uint_vector_uint___contains__(self, key)

    def key_iterator(self):
        return _infomap.map_uint_vector_uint_key_iterator(self)

    def value_iterator(self):
        return _infomap.map_uint_vector_uint_value_iterator(self)

    def __setitem__(self, *args):
        return _infomap.map_uint_vector_uint___setitem__(self, *args)

    def asdict(self):
        return _infomap.map_uint_vector_uint_asdict(self)

    def __init__(self, *args):
        _infomap.map_uint_vector_uint_swiginit(self, _infomap.new_map_uint_vector_uint(*args))

    def empty(self):
        return _infomap.map_uint_vector_uint_empty(self)

    def size(self):
        return _infomap.map_uint_vector_uint_size(self)

    def swap(self, v):
        return _infomap.map_uint_vector_uint_swap(self, v)

    def begin(self):
        return _infomap.map_uint_vector_uint_begin(self)

    def end(self):
        return _infomap.map_uint_vector_uint_end(self)

    def rbegin(self):
        return _infomap.map_uint_vector_uint_rbegin(self)

    def rend(self):
        return _infomap.map_uint_vector_uint_rend(self)

    def clear(self):
        return _infomap.map_uint_vector_uint_clear(self)

    def get_allocator(self):
        return _infomap.map_uint_vector_uint_get_allocator(self)

    def count(self, x):
        return _infomap.map_uint_vector_uint_count(self, x)

    def erase(self, *args):
        return _infomap.map_uint_vector_uint_erase(self, *args)

    def find(self, x):
        return _infomap.map_uint_vector_uint_find(self, x)

    def lower_bound(self, x):
        return _infomap.map_uint_vector_uint_lower_bound(self, x)

    def upper_bound(self, x):
        return _infomap.map_uint_vector_uint_upper_bound(self, x)
    __swig_destroy__ = _infomap.delete_map_uint_vector_uint

# Register map_uint_vector_uint in _infomap:
_infomap.map_uint_vector_uint_swigregister(map_uint_vector_uint)

class InfomapWrapper(InfomapCore):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        _infomap.InfomapWrapper_swiginit(self, _infomap.new_InfomapWrapper(*args))
    __swig_destroy__ = _infomap.delete_InfomapWrapper

    def readInputData(self, *args):
        return _infomap.InfomapWrapper_readInputData(self, *args)

    def addNode(self, *args):
        return _infomap.InfomapWrapper_addNode(self, *args)

    def addName(self, id, name):
        return _infomap.InfomapWrapper_addName(self, id, name)

    def addPhysicalNode(self, *args):
        return _infomap.InfomapWrapper_addPhysicalNode(self, *args)

    def addStateNode(self, id, physId):
        return _infomap.InfomapWrapper_addStateNode(self, id, physId)

    def addLink(self, *args):
        return _infomap.InfomapWrapper_addLink(self, *args)

    def addMultilayerLink(self, layer1, n1, layer2, n2, weight=1.0):
        return _infomap.InfomapWrapper_addMultilayerLink(self, layer1, n1, layer2, n2, weight)

    def setBipartiteStartId(self, startId):
        return _infomap.InfomapWrapper_setBipartiteStartId(self, startId)

    def getModules(self, level=1, states=False):
        return _infomap.InfomapWrapper_getModules(self, level, states)

    def getMultilevelModules(self, states=False):
        return _infomap.InfomapWrapper_getMultilevelModules(self, states)

    def getModules(self, level=1, states=False):
        return dict(_infomap.InfomapWrapper_getModules(self, level, states))


# Register InfomapWrapper in _infomap:
_infomap.InfomapWrapper_swigregister(InfomapWrapper)

from collections import namedtuple
from contextlib import contextmanager

MultilayerNode = namedtuple("MultilayerNode", "layer_id, node_id")


class Infomap(InfomapWrapper):
    """Infomap

    This class is a thin wrapper around Infomap C++ compiled with SWIG.

    Examples
    --------
    Create an instance and add nodes and links:

    >>> import infomap
    >>> im = infomap.Infomap()
    >>> im.add_node(1)
    >>> im.add_node(2)
    >>> im.add_link(1, 2)
    >>> im.run()
    >>> im.codelength
    1.0


    Create an instance and read a network file:

    >>> import infomap
    >>> im = infomap.Infomap()
    >>> im.read_file("ninetriangles.net")
    >>> im.run("-N5")
    >>> im.codelength
    3.4841898804052187


    For more examples, see the examples directory.
    """

    def __init__(self, args=None):
        """Create a new Infomap instance.

        Parameters
        ----------
        args : str, optional
            Space delimited parameter list (see Infomap documentation).
        """
        if args is None:
            args = ""
        super().__init__(args)

    def read_file(self, filename, accumulate=True):
        """Read network data from file.

        Parameters
        ----------
        filename : str
        accumulate : bool, optional
            If the network data should be accumulated to already added
            nodes and links (default True).
        """
        return super().readInputData(filename, accumulate)

    def add_node(self, node_id, name=None, teleportation_weight=None):
        """Add a node.

        Notes
        -----
        Creates a state node for internal use.
        If you want to create empty named nodes, use ``set_name`` instead.

        See Also
        --------
        set_name

        Parameters
        ----------
        node_id : int
        name : str, optional
        teleportation_weight : float, optional
            Used for teleporting between layers in multilayer networks.
        """
        if name is None:
            name = ""

        if (len(name) and teleportation_weight is not None):
            return super().addNode(node_id, name, teleportation_weight)
        elif (len(name) and teleportation_weight is None):
            return super().addNode(node_id, name)
        elif (not len(name) and teleportation_weight is not None):
            return super().addNode(node_id, teleportation_weight)

        return super().addNode(node_id)

    def add_nodes(self, nodes):
        """Add several nodes.

        See Also
        --------
        add_node

        Examples
        --------
        Add nodes

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> im.add_nodes(range(4))
        None


        Add named nodes

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> nodes = (
        ...     (1, "Node 1"),
        ...     (2, "Node 2"),
        ...     (3, "Node 3")
        ... )
        >>> im.add_nodes(nodes)
        None


        Parameters
        ----------
        nodes : iterable of tuples or iterable of int
            Iterable of tuples on the form (node_id, [name], [teleportation_weight])
        """
        for node in nodes:
            if isinstance(node, int):
                self.add_node(node)
            else:
                self.add_node(*node)

    def set_name(self, node_id, name):
        """Set the name of a node.

        Notes
        -----
        Creates nodes if a node with the supplied node id does not exist.
        This is useful to create empty physical node in a state network.

        Parameters
        ----------
        node_id : int
        name : str
        """
        if name is None:
            name = ""
        return super().addName(node_id, name)

    def set_names(self, names):
        """Set names to several nodes at once.

        Example
        -------

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> names = (
        ...     (1, "Node 1"),
        ...     (2, "Node 2")
        ... )
        >>> im.set_names(names)
        None


        See Also
        --------
        set_name

        Parameters
        ----------
        names : iterable of tuples
            Iterable of tuples on the form (node_id, name).
        """
        for name in names:
            self.set_name(*name)

    def set_meta_data(self, node_id, meta_category):
        """Set meta data to a node.

        Parameters
        ----------
        node_id : int
        meta_category : int
        """
        return self.network.addMetaData(node_id, meta_category)

    def add_state_node(self, state_id, node_id):
        """Add a state node.

        Notes
        -----
        If a physical node with id node_id does not exist, it will be created.
        If you want to name the physical node, use ``set_name``.

        Parameters
        ----------
        state_id : int
        node_id : int
            Id of the physical node the state node should be added to.
        """
        return super().addStateNode(state_id, node_id)

    def add_state_nodes(self, state_nodes):
        """Add several state nodes.

        See Also
        --------
        add_state_node

        Example
        -------

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> states = (
        ...     (1, 1),
        ...     (2, 1),
        ...     (3, 2)
        ... )
        >>> im.add_state_nodes(states)
        None


        Parameters
        ----------
        state_nodes : iterable of tuples
            Iterable of tuples of the form (state_id, node_id)
        """
        for node in state_nodes:
            self.add_state_node(*node)

    def add_link(self, source_id, target_id, weight=1.0):
        """Add a link.

        Notes
        -----
        If the source or target nodes does not exist, they will be created.

        See Also
        --------
        remove_link

        Parameters
        ----------
        source_id : int
        target_id : int
        weight : float, optional
        """
        return super().addLink(source_id, target_id, weight)

    def add_links(self, links):
        """Add several links.

        Example
        -------

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> links = (
        ...     (1, 2),
        ...     (1, 3)
        ... )
        >>> im.add_links(links)
        None


        See Also
        --------
        add_link
        remove_link

        Parameters
        ----------
        links : iterable of tuples
            Iterable of tuples of int of the form (source_id, target_id, [weight])
        """
        for link in links:
            self.add_link(*link)

    def remove_link(self, source_id, target_id):
        """Remove a link.

        Notes
        -----
        Removing links will not remove nodes if they become disconnected.

        See Also
        --------
        add_link

        Parameters
        ----------
        source_id : int
        target_id : int
        """
        return self.network.removeLink(source_id, target_id)

    def remove_links(self, links):
        """Remove several links.

        Example
        -------

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> links = (
        ...     (1, 2),
        ...     (1, 3)
        ... )
        >>> im.remove_links(links)
        None


        See Also
        --------
        remove_link

        Parameters
        ----------
        links : iterable of tuples
            Iterable of tuples of the form (source_id, target_id)
        """
        for link in links:
            self.remove_link(*link)

    def add_multilayer_link(
            self,
            source_multilayer_node,
            target_multilayer_node,
            weight=1.0):
        """Add a multilayer link.

        Adds a link between layers in a multilayer network.

        Parameters
        ----------
        source_multilayer_node : tuple of int, or MultilayerNode
            If passed a tuple, it should be of the format (layer_id, node_id).
        target_multilayer_node : tuple of int, or MultilayerNode
            If passed a tuple, it should be of the format (layer_id, node_id).
        weight : float, optional

        Examples
        --------
        Usage with tuples:

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> source_multilayer_node = (0, 1) # layer_id, node_id
        >>> target_multilayer_node = (1, 2) # layer_id, node_id
        >>> im.add_multilayer_link(source_multilayer_node, target_multilayer_node)
        None


        Usage with MultilayerNode

        >>> from infomap import Infomap, MultilayerNode
        >>> im = Infomap()
        >>> source_multilayer_node = MultilayerNode(layer_id=0, node_id=1)
        >>> target_multilayer_node = MultilayerNode(layer_id=1, node_id=2)
        >>> im.add_multilayer_link(source_multilayer_node, target_multilayer_node)
        None

        """
        source_layer_id, source_node_id = source_multilayer_node
        target_layer_id, target_node_id = target_multilayer_node
        return super().addMultilayerLink(source_layer_id,
                                         source_node_id,
                                         target_layer_id,
                                         target_node_id,
                                         weight)

    def add_multilayer_links(self, links):
        """Add several multilayer links.

        Example
        -------

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> links = (
        ...     ((0, 1), (1, 2)),
        ...     ((0, 3), (1, 2))
        ... )
        >>> im.add_multilayer_links(links)
        None


        See Also
        --------
        add_multilayer_link

        Parameters
        ----------
        links : iterable of tuples
            Iterable of tuples of the form (source_node, target_node, [weight])
        """
        for link in links:
            self.add_multilayer_link(*link)

    def remove_multilayer_link(self):
        raise NotImplementedError

    @property
    def bipartite_start_id(self):
        """Get or set the bipartite start id.

        Example
        -------

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> im.add_node(1, "Left 1")
        >>> im.add_node(2, "Left 2")
        >>> im.bipartite_start_id = 3
        >>> im.add_node(3, "Right 3")
        >>> im.add_node(4, "Right 4")
        >>> im.add_link(1, 3)
        >>> im.add_link(1, 4)
        >>> im.add_link(2, 4)
        >>> im.run()
        None


        Parameters
        ----------
        start_id : int
            The node id where the second node type starts.

        Returns
        -------
        int
            The node id where the second node type starts.
        """
        return self.network.bipartiteStartId

    @bipartite_start_id.setter
    def bipartite_start_id(self, start_id):
        return super().setBipartiteStartId(start_id)

    @property
    def initial_partition(self):
        """Get or set the initial partition.

        This is a initial configuration of nodes into modules where Infomap
        will start the optimizer.

        Example
        -------

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> im.add_node(1)
        >>> im.add_node(2)
        >>> im.add_node(3)
        >>> im.add_node(4)
        >>> im.add_link(1, 2)
        >>> im.add_link(1, 3)
        >>> im.add_link(2, 3)
        >>> im.add_link(2, 4)
        >>> im.initial_partition = {
        ...     1: 0,
        ...     2: 0,
        ...     3: 1,
        ...     4: 1
        ... }
        >>> im.run()
        None


        Notes
        -----
        The initial partition is saved between runs.
        If you want to use an initial partition for one run only,
        use ``run(initial_partition=partition)``.

        Parameters
        ----------
        module_ids : dict of int, or None
            Dict with node ids as keys and module ids as values.

        Returns
        -------
        dict of int
            Dict with node ids as keys and module ids as values.
        """
        return super().getInitialPartition()

    @initial_partition.setter
    def initial_partition(self, module_ids):
        if module_ids is None:
            module_ids = {}
        return super().setInitialPartition(module_ids)

    @contextmanager
    def _initial_partition(self, partition):
# Internal use only
# Store the possiply set initial partition
# and use the new initial partition for one run only.
        old_partition = self.initial_partition
        try:
            self.initial_partition = partition
            yield
        finally:
            self.initial_partition = old_partition

    @property
    def no_infomap(self):
        """Set wether the optimizer should run or not.

        Parameters
        ----------
        no_infomap : bool
        """
        return super().noInfomap

    @no_infomap.setter
    def no_infomap(self, no_infomap):
        super().setNoInfomap(no_infomap)

    def run(self, args=None, initial_partition=None):
        """Run Infomap.

        Parameters
        ----------
        args : str, optional
            Space delimited parameter list (see Infomap documentation).
        initial_partition : dict, optional
            Initial partition to start optimizer from (see initial_partition).

        See Also
        --------
        initial_partition
        """
        if args is None:
            args = ""

        if initial_partition:
            with self._initial_partition(initial_partition):
                return super().run(args)

        return super().run(args)

    def get_modules(self, depth_level=1, states=False):
        """Get the modules for a given depth in the hierarchical tree.

        Parameters
        ----------
        depth_level : int, optional
            The level in the hierarchical tree. Set to 1 (default) to return the
            top modules (coarsest level), set to 2 for second coarsest level etc.
            Set to -1 to return the bottom level modules (finest level).
        states : bool, optional
            For higher-order networks, if ``states`` is True, it will iterate over state nodes,
            otherwise it will iterate over physical nodes, merging state nodes with same
            ``node_id`` if they are in the same module.
            Note that the same physical node may end up on different paths in the tree.
            See notes on ``physical_tree``.

        Returns
        -------
        dict of int
            Dict with node ids as keys and module ids as values.
        """
        return super().getModules(depth_level, states)

    def get_multilevel_modules(self, states=False):
        """Get all the modules.

        Parameters
        ----------
        states : bool, optional
            For higher-order networks, if ``states`` is True, it will iterate over state nodes,
            otherwise it will iterate over physical nodes, merging state nodes with same
            ``node_id`` if they are in the same module.
            Note that the same physical node may end up on different paths in the tree.
            See notes on ``physical_tree``.

        Returns
        -------
        dict of list of int
            Dict with node ids as keys and list of module ids as values.
        """
        return super().getMultilevelModules(states)

    @property
    def modules(self):
        """A view of the (top-level) modules

        Example
        -------

        >>> from infomap import Infomap
        >>> im = Infomap()
        >>> im.read_file("ninetriangles.net")
        >>> im.run("-N5")
        >>> for node_id, module_id in im.modules:
        ...     print(node_id, module_id)
        ...
        1 1
        2 1
        3 1
        4 1
        5 1
        6 1
        7 1
        8 1
        9 1
        10 2
        11 2
        12 2
        13 2
        14 2
        15 2
        16 2
        17 2
        18 2
        19 0
        20 0
        21 0
        22 0
        23 0
        24 0
        25 0
        26 0
        27 0


        See Also
        --------
        get_modules

        Yields
        -------
        tuple of int, int
            An iterator of node_id, module_id pairs.
        """
        return self.get_modules(depth_level=1, states=False).items()

    def get_tree(self, depth_level=1, states=False):
        """A view of the tree

        Parameters
        ----------
        depth_level : int, optional
            The module level returned by ``iterator.module_id``. Set to 1 (default) to
            return the top modules (coarsest level), set to 2 for second coarsest level
            etc. Set to -1 to return the bottom level modules (finest level).
        states : bool, optional
            For higher-order networks, if ``states`` is True, it will iterate over state nodes,
            otherwise it will iterate over physical nodes, merging state nodes with same
            ``node_id`` if they are in the same module.
            Note that the same physical node may end up on different paths in the tree.
            See notes on ``physical_tree``.

        Notes
        ----
        For higher-order networks, each node is represented by a set of state nodes
        with the same ``node_id``, where each state node represents a different memory
        constraining the random walker. This enables overlapping modules, where
        state nodes with the same ``node_id`` end up in different modules. However,
        the state nodes with the same ``node_id`` within each module are only visible
        as one (partial) physical node (if ``states = False``).

        Returns
        -------
        InfomapIterator or InfomapIteratorPhysical
            An iterator over each node in the tree, depth first from the root
        """
        if states:
            return super().iterTree(depth_level)
        return super().iterTreePhysical(depth_level)

    def get_nodes(self, depth_level=1, states=False):
        """A view of the tree

        Parameters
        ----------
        depth_level : int, optional
            The module level returned by ``iterator.module_id``. Set to 1 (default) to
            return the top modules (coarsest level), set to 2 for second coarsest level
            etc. Set to -1 to return the bottom level modules (finest level).
        states : bool, optional
            For higher-order networks, if ``states`` is True, it will iterate over state nodes,
            otherwise it will iterate over physical nodes, merging state nodes with same
            ``node_id`` if they are in the same module.
            Note that the same physical node may end up on different paths in the tree.
            See notes on ``physical_tree``.

        Notes
        ----
        For higher-order networks, each node is represented by a set of state nodes
        with the same ``node_id``, where each state node represents a different memory
        constraining the random walker. This enables overlapping modules, where
        state nodes with the same ``node_id`` end up in different modules. However,
        the state nodes with the same ``node_id`` within each module are only visible
        as one (partial) physical node (if ``states = False``).

        Returns
        -------
        InfomapIterator or InfomapIteratorPhysical
            An iterator over each node in the tree, depth first from the root
        """
        if states:
            return super().iterLeafNodes(depth_level)
        return super().iterLeafNodesPhysical(depth_level)

    @property
    def tree(self):
        """A view of the tree

        See Also
        --------
        get_tree
        InfomapIterator

        Returns
        -------
        InfomapIterator
            An iterator over each node in the tree, depth first from the root
        """
        return self.get_tree(depth_level=1, states=True)

    @property
    def physical_tree(self):
        """A view of the tree where that state nodes of the same
        ``node_id`` are merged to one physical node

        See Also
        --------
        get_tree
        InfomapIteratorPhysical

        Returns
        -------
        InfomapIteratorPhysical
            An iterator over each physical node in the tree, depth first from the root
        """
        return self.get_tree(depth_level=1, states=False)

    @property
    def leaf_modules(self):
        """A view of the leaf modules, i.e. the bottom modules containing leaf nodes.

        See Also
        --------
        get_modules
        InfomapLeafModuleIterator

        Returns
        -------
        InfomapLeafModuleIterator
            An iterator over each leaf module in the tree, depth first from the root
        """
        return super().iterLeafModules()

    @property
    def nodes(self):
        """A view of the leaf nodes with the top level module ids

        See Also
        --------
        get_nodes
        InfomapLeafIterator

        Returns
        -------
        InfomapLeafIterator
            An iterator over each leaf node in the tree, depth first from the root
        """
        return self.get_nodes(depth_level=1, states=True)

    @property
    def physical_nodes(self):
        """A view of the physical leaf nodes with the top level module ids

        See Also
        --------
        get_nodes
        InfomapLeafIteratorPhysical

        Returns
        -------
        InfomapLeafIteratorPhysical
            An iterator over each physical leaf node in the tree, depth first from the root
        """
        return self.get_nodes(depth_level=1, states=False)

    @property
    def num_top_modules(self):
        """Get the number of top modules in the tree

        Returns
        -------
        int
            The number of top modules
        """
        return super().numTopModules()

    @property
    def num_leaf_modules(self):
        """Get the number of leaf modules in the tree

        Returns
        -------
        int
            The number of leaf modules
        """
        num_leaf_modules = 0
        for _ in self.leaf_modules:
            num_leaf_modules += 1
        return num_leaf_modules

    @property
    def max_depth(self):
        """Get the max depth of the hierarchical tree.

        Returns
        -------
        int
            The max depth
        """
        return super().maxTreeDepth()

    @property
    def codelength(self):
        """Get the total (hierarchical) codelength.

        See Also
        --------
        index_codelength
        module_codelength

        Returns
        -------
        float
            The codelength
        """
        return super().codelength()

    @property
    def index_codelength(self):
        """Get the two-level index codelength.

        See Also
        --------
        codelength
        module_codelength

        Returns
        -------
        float
            The two-level index codelength
        """
        return super().getIndexCodelength()

    @property
    def module_codelength(self):
        """Get the two-level module codelength.

        See Also
        --------
        codelength
        index_codelength

        Returns
        -------
        float
            The two-level module codelength
        """
        return super().getModuleCodelength()

    @property
    def meta_codelength(self):
        """Get the meta codelength.

        This is the meta entropy times the meta data rate.

        See Also
        --------
        meta_entropy

        Returns
        -------
        float
            The meta codelength
        """
        return super().getMetaCodelength()

    @property
    def meta_entropy(self):
        """Get the meta entropy (unweighted by meta data rate).

        See Also
        --------
        meta_codelength

        Returns
        -------
        float
            The meta entropy
        """
        return super().getMetaCodelength(True)

    @property
    def network(self):
        """Get the internal network."""
        return super().network()

    def write_clu(self, filename, states=False, depth_level=1):
        """Write result to a clu file.

        See Also
        --------
        write_tree
        write_flow_tree

        Parameters
        ----------
        filename : str
        states : bool, optional
            If the state nodes should be included (default False).
        depth_level : int, optional
            The depth in the hierarchical tree to write.
        """
        return self.writeClu(filename, states, depth_level)

    def write_tree(self, filename, states=False):
        """Write result to a tree file.

        See Also
        --------
        write_clu
        write_flow_tree

        Parameters
        ----------
        filename : str
        states : bool, optional
            If the state nodes should be included (default False).
        """
        return self.writeTree(filename, states)

    def write_flow_tree(self, filename, states=False):
        """Write result to a ftree file.

        See Also
        --------
        write_clu
        write_tree

        Parameters
        ----------
        filename : str
        states : bool, optional
            If the state nodes should be included (default False).
        """
        return self.writeFlowTree(filename, states)



def main():
    import sys
    import infomap as im
    args = " ".join(sys.argv[1:])
    conf = im.Config(args, True)
    infomap = im.Infomap(conf)
    infomap.run()


if __name__ == '__main__':
    main()
