"""
服务层模块

提供题目管理、检索、导入和统计分析等核心业务服务。
按照业务功能划分为四个主要服务：
- Embedding服务 (EmbeddingService): 文本向量化服务
- 检索服务 (SearchService): 语义检索和关键词检索
- 管理服务 (ManagementService): 题目增删改查和批量操作
- 导入服务 (ImportService): 批量数据导入和外部数据源对接
- 统计服务 (StatisticsService): 多维度数据统计和分析
"""

from .embedding_service import EmbeddingService, EmbeddingProvider, CircuitBreaker
from .management_service import ManagementService
from .search_service import SearchService
from .import_service import ImportService, ImportSource, ImportStatus
from .analytics_service import AnalyticsService
from .export_service import ExportService

__all__ = [
    "EmbeddingService",
    "EmbeddingProvider",
    "CircuitBreaker",
    "ManagementService",
    "SearchService",
    "ImportService",
    "ImportSource",
    "ImportStatus",
    "AnalyticsService",
    "ExportService",
]
