"""
数据库访问层模块

提供 SQLite 和 ChromaDB 数据库的统一访问接口。
负责题目数据的持久化存储、向量存储和检索。
"""

from src.database.models import (
    QuestionModel,
    TagModel,
    QuestionTagRelation,
    QuestionCreateDTO,
    QuestionUpdateDTO,
    QuestionSearchFilter
)

from src.database.sqlite_dao import SQLiteDAO
from src.database.chroma_dao import ChromaDAO
from src.database.database_manager import DatabaseManager

__all__ = [
    # 数据模型
    "QuestionModel",
    "TagModel",
    "QuestionTagRelation",
    "QuestionCreateDTO",
    "QuestionUpdateDTO",
    "QuestionSearchFilter",
    
    # 数据访问对象
    "SQLiteDAO",
    "ChromaDAO",
    
    # 数据库管理器
    "DatabaseManager",
]
