@echo off
REM Questions MCP Server Windows部署脚本

echo ==================================
echo Questions MCP Server 部署脚本
echo ==================================

REM 检查Python
echo 检查Python版本...
python --version >nul 2>&1
if errorlevel 1 (
    echo 错误: 未找到Python
    exit /b 1
)
echo √ Python已安装

REM 创建虚拟环境
echo 创建Python虚拟环境...
if not exist ".venv" (
    python -m venv .venv
    echo √ 虚拟环境创建成功
) else (
    echo √ 虚拟环境已存在
)

REM 激活虚拟环境
echo 激活虚拟环境...
call .venv\Scripts\activate.bat

REM 安装依赖
echo 安装项目依赖...
python -m pip install --upgrade pip
pip install -r requirements.txt
echo √ 依赖安装完成

REM 创建必要的目录
echo 创建数据目录...
if not exist "data\chroma" mkdir data\chroma
if not exist "data\backups" mkdir data\backups
if not exist "logs" mkdir logs
echo √ 目录创建完成

REM 配置环境变量
echo 配置环境变量...
if not exist ".env" (
    copy .env.example .env
    echo 请编辑 .env 文件，配置必要的API密钥
) else (
    echo √ .env 文件已存在
)

echo ==================================
echo 部署完成！
echo ==================================
echo 运行服务: start.bat
echo 停止服务: 按 Ctrl+C
echo 查看日志: type logs\app.log
pause
