@echo off
REM 使用 uv 构建和发布 Questions MCP Server

echo ================================
echo Questions MCP Server - UV 构建
echo ================================

REM 检查 uv 是否安装
uv --version >nul 2>&1
if errorlevel 1 (
    echo 错误: 未找到 uv
    echo 请先安装 uv: pip install uv
    exit /b 1
)
echo √ uv 已安装

REM 清理旧的构建文件
echo 清理旧的构建文件...
if exist "dist" rd /s /q dist
if exist "build" rd /s /q build
if exist "src\questions_mcp_server.egg-info" rd /s /q src\questions_mcp_server.egg-info

REM 使用 uv 构建包
echo 使用 uv 构建包...
uv build

if errorlevel 1 (
    echo 构建失败
    exit /b 1
)

echo.
echo ================================
echo 构建完成！
echo ================================
echo.
echo 生成的文件：
dir /b dist\*
echo.
echo 安装命令：
echo   uv pip install dist\questions_mcp_server-1.0.0-py3-none-any.whl
echo.
echo 或使用 uvx 直接运行：
echo   uvx --from dist\questions_mcp_server-1.0.0-py3-none-any.whl questions-mcp-server
echo.

pause
