# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['skunkbooth', 'skunkbooth.data', 'skunkbooth.filters', 'skunkbooth.utils']

package_data = \
{'': ['*']}

install_requires = \
['asciimatics>=1.13,<2.0', 'opencv-python>=4.5,<5.0']

entry_points = \
{'console_scripts': ['skunkbooth = skunkbooth.main:main']}

setup_kwargs = {
    'name': 'skunkbooth',
    'version': '0.3',
    'description': 'A camera app in terminal. One more reason to stay inside terminal.',
    'long_description': '<!-- ![Image of skukbooth logo](Images/skunkbooth_readme.png) -->\n<div align="center">\n   <img src="Images/skunkbooth_readme.png" alt="Skunkbooth Logo" width="143" height="143">\n   <br/>\n   <br/>\n</div>\n\n[![GitHub issues](https://img.shields.io/github/issues/Davidy22/scholarlySkunkJam?style=for-the-badge)](https://github.com/Davidy22/scholarlySkunkJam/issues) &nbsp;&nbsp; [![GitHub forks](https://img.shields.io/github/forks/Davidy22/scholarlySkunkJam?style=for-the-badge)](https://github.com/Davidy22/scholarlySkunkJam/network) &nbsp;&nbsp; [![GitHub stars](https://img.shields.io/github/stars/Davidy22/scholarlySkunkJam?style=for-the-badge)](https://github.com/Davidy22/scholarlySkunkJam/stargazers)&nbsp;&nbsp; [![PyPI](https://img.shields.io/badge/PyPI-GO%20HERE-yellow?style=for-the-badge&logo=pypi)](https://pypi.org/project/skunkbooth/) &nbsp;&nbsp; [![Python](https://img.shields.io/badge/Python-TRUE-brightgreen?style=for-the-badge&logo=python)](https://www.google.com/url?sa=t&rct=j&q=&esrc=s&source=web&cd=&cad=rja&uact=8&ved=2ahUKEwimlcXOwPHxAhXt4nMBHR1LDBUQFjAAegQICxAD&url=https%3A%2F%2Fwww.python.org%2F&usg=AOvVaw0QREvGsjwHKp2GtoYvs1JH)&nbsp;&nbsp; [![Gitter](https://img.shields.io/gitter/room/SkunkBooth/community.svg?style=for-the-badge&logo=gitter)](https://gitter.im/SkunkBooth/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)\n\n- [Skunkbooth](#skunkbooth)\n  - [Why](#why)\n  - [See it in action](#see-it-in-action)\n- [Usage](#usage)\n  - [Installation](#installation)\n  - [Run](#run)\n  - [Media location](#media-location)\n- [Contributing](#contributing)\n  - [Install Poetry](#install-poetry)\n  - [Clone the repo](#clone-the-repo)\n  - [Activate poetry shell](#activate-poetry-shell)\n  - [Install dev deps](#install-dev-deps)\n  - [Run the application](#run-the-application)\n  - [Logs](#logs)\n- [App Walkthrough](#app-walkthrough)\n  - [Home](#-home)\n  - [Shoot](#-shoot)\n  - [Record](#-record)\n  - [Effects](#-effects)\n  - [Gallery](#-gallery)\n  - [Preview](#-preview)\n  - [Quit](#-quit)\n\n# Skunkbooth\n\nA camera app in terminal. One more reason to stay inside the box you call terminal.\n\n### Why\n\nWith our revolutionary application, you don’t have to leave your terminal and climb a mountain,\njust to get your next perfect Instagram picture.\nOpen terminal, run `skunkbooth` and capture funkiest images _inside_ the box (aka terminal).\n\nWe support all the modern operating systems. All you need is `python3`.\n\n### See it in action\n\n[![Alt text](https://img.youtube.com/vi/47_HYQGqVIU/0.jpg)](https://www.youtube.com/watch?v=47_HYQGqVIU)\n\n# Usage\n\n### Installation\n\n```shell\npip install skunkbooth\n```\n\n### Run\n\nAfter installation, use `skunkbooth` command to launch camera.\n\n```shell\nskunkbooth\n```\n\n### Media location\n\nThe photos and videos that you take are present in the following location\n\n- MacOS and Linux\n\n```shell\nls ~/skunkbooth/pictures\n```\n\n- Windows\n\n```powershell\ndir C:\\Users\\<username>\\skunkbooth\\pictures\n```\n\n# Contributing\n\n[Poetry](https://python-poetry.org/) is used for package management.\nFor setting up your environment, follow along.\n\n### Install Poetry\n\n- MacOS, Linux or WSL\n\n```shell\ncurl -sSL https://raw.githubusercontent.com/python-poetry/poetry/master/install-poetry.py | python -\n```\n\n- Windows Powershell\n\n```shell\n(Invoke-WebRequest -Uri https://raw.githubusercontent.com/python-poetry/poetry/master/install-poetry.py -UseBasicParsing).Content | python -\n```\n\n### Clone the repo\n\n```shell\ngit clone https://github.com/Davidy22/scholarlySkunkJam.git\ncd scholarlySkunkJam\n```\n\n### Activate poetry shell\n\n```shell\npoetry shell\n```\n\n### Install dev deps\n\n```shell\npoetry install\n```\n\n### Run the application\n\n```shell\npython3 -m skunkbooth.main\n```\n\n### Logs\n\nLogs are located in `skunkbooth` folder.\n\n- macOS and Linux\n\n```shell\ntail -f ~/skunkbooth/.logs/skunkbooth.log\n```\n\n- Windows (powershell)\n\n```powershell\nGet-Content C:\\Users\\<username>\\skunkbooth\\.logs\\skunkbooth.log -Wait\n```\n\n# App Walkthrough\n\n### 🏠 Home\n\nHome screen is the first point of contact for the application. It displays the camera output in the screen by default,\nwhen the application is started and enables access/navigation to all features of the application.\n\n<div align="center">\n   <br/>\n   <img src="Images/SB_Camera.png" alt="Home screen" width="1000" height="600">\n   <br/>\n   <br/>\n</div>\n\n### 📷 Shoot\n\nImage(s) can be taken instantly by clicking on Shoot button in home screen.\n\n### ⏯ Record\n\nRecord button in the home screen toggles video recording and it can be used to start and stop recording.\n\n_Image and video files generated will be stored in [Media location](#media-location) as .jpg and .avi respectively._\n\n### 🖌 Effects\n\nThe Effects screen features filters that can be applied to the camera output.\n\n<div align="center">\n   <br/>\n   <img src="Images/SB_Effects.png" alt="Effects screen" width="1000" height="600">\n   <br/>\n   <br/>\n</div>\n\nTo capture images and video by applying filters follow the below steps:\n\n- Enable the checkbox associated with the desired filter(s).\n\n- Navigate to the home screen using <👈 Back to 📷> button, which will now display the camera output\n  post application of the selected filters.\n\n- Use Shoot or Record options in the home screen as explained before.\n\nPlay around with multiple filters to capture some _grooviest_ images and videos.\n\n<div align="center">\n   <br/>\n   <img src="Images/SB_CamwithEffects.png" alt="Home screen with effects" width="1000" height="600">\n   <br/>\n   <br/>\n</div>\n\n### 🖼 Gallery\n\nGallery screen is a file browser which displays list of images and videos captured using the application,\nas shown in the image below.\n\n<div align="center">\n   <br/>\n   <img src="Images/SB_Gallery.png" alt="Gallery screen" width="1000" height="600">\n   <br/>\n   <br/>\n</div>\n\n### 👁 Preview\n\nPreview screen renders the media file that is opened via gallery screen. This screen currently\nsupports display of files only in .jpg format, with more formats to be added in the future versions.\n\n<div align="center">\n   <br/>\n   <img src="Images/SB_Preview.png" alt="Preview screen" width="1000" height="600">\n   <br/>\n   <br/>\n</div>\n\n### 🛑 Quit\n\nThe application can be safely exited using Quit button in home screen.\n',
    'author': 'Davidy22, dhananjaylatkar, Trisanu-007, shriram1998 and garuna-m6',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Davidy22/scholarlySkunkJam',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
